-- Copyright (C) 2018 Markus Welters     <markus@welters.de>
-- Copyright (C) 2023 Nikolay Brookstein <nikolay.brookstein@spesstech.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program. If not, see <https://www.gnu.org/licenses/>.
--

--
-- Ne pas placer de commentaire en fin de ligne, ce fichier est parsé lors
-- de l'install et tous les sigles '--' sont supprimés.
--

-- Descriptif des plans comptables DE SKR03 + SKR04
-- ADD 500000 to rowid # Do no remove this comment --

-- SKR03 (based on DATEV Art.-Nr. 11174 2023-01-03)
-- https://www.datev.de/web/de/datev-shop/material/kontenrahmen-datev-skr-03/
---- 0: Anlage- und Kapitalkonten
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,    5, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0005',   '0', 'Rückständige fällige Einzahlungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   10, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0010',   '0', 'Entgeltlich erworbene Konzessionen, gewerbliche Schutzrechte und ähnliche Rechte und Werte sowie Lizenzen an solchen Rechten und Werten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   15, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0015',   '10', 'Konzessionen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   20, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0020',   '10', 'Gewerbliche Schutzrechte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   25, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0025',   '10', 'Ähnliche Rechte und Werte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   27, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0027',   '10', 'EDV-Software');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   30, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0030',   '10', 'Lizenzen an gewerblichen Schutzrechten und ähnlichen Rechten und Werten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   35, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0035',    '0', 'Geschäfts- oder Firmenwert');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   38, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0038',    '0', 'Anzahlungen auf Geschäfts- oder Firmenwert');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   39, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0039',    '0', 'Geleistete Anzahlungen auf immaterielle Vermögensgegenstände');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   40, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0040',   '39', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   43, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0043',    '0', 'Selbst geschaffene immaterielle Vermögensgegenstände');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   44, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0044',   '43', 'EDV-Software');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   45, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0045',   '43', 'Lizenzen und Franchiseverträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   46, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0046',   '43', 'Konzessionen und gewerbliche Schutzrechte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   47, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0047',   '43', 'Rezepte, Verfahren, Prototypen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   48, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0048',   '43', 'Immaterielle Vermögensgegenstände in Entwicklung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   50, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0050',    '0', 'Grundstücke, grundstücksgleiche Rechte und Bauten einschließlich der Bauten auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   59, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0059',   '50', 'Grundstücksanteil des häuslichen Arbeitszimmers');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   60, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0060',    '0', 'Grundstücksgleiche Rechte ohne Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   65, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0065',   '60', 'Unbebaute Grundstücke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   70, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0070',   '60', 'Grundstücksgleiche Rechte (Erbbaurecht, Dauerwohnrecht, unbebaute Grundstücke)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   75, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0075',   '60', 'Grundstücke mit Substanzverzehr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   79, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0079',   '60', 'Anzahlungen auf Grund und Boden');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   80, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0080',    '0', 'Bauten auf eigenen Grundstücken und grundstücksgleichen Rechten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   85, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0085',   '80', 'Grundstückswerte eigener bebauter Grundstücke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,   90, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0090',   '80', 'Geschäftsbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  100, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0100',   '80', 'Fabrikbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  110, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0110',   '80', 'Garagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  111, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0111',   '80', 'Außenanlagen für Geschäfts-, Fabrik- und andere Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  112, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0112',   '80', 'Hof- und Wegebefestigungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  113, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0113',   '80', 'Einrichtungen für Geschäfts-, Fabrik- und andere Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  115, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0115',   '80', 'Andere Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  120, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0120',   '80', 'Geschäfts-, Fabrik- und andere Bauten im Bau auf eigenen Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  129, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0129',   '80', 'Anzahlungen auf Geschäfts-, Fabrik- und andere Bauten auf eigenen Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  140, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0140',   '80', 'Wohnbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  145, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0145',   '80', 'Garagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  146, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0146',   '80', 'Außenanlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  147, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0147',   '80', 'Hof- und Wegebefestigungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  148, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0148',   '80', 'Einrichtungen für Wohnbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  149, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0149',   '80', 'Gebäudeteil des häuslichen Arbeitszimmers');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  150, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0150',   '80', 'Wohnbauten im Bau auf eigenen Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  159, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0159',   '80', 'Anzahlungen auf Wohnbauten auf eigenen Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  160, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0160',    '0', 'Bauten auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  165, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0165',  '160', 'Geschäftsbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  170, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0170',  '160', 'Fabrikbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  175, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0175',  '160', 'Garagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  176, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0176',  '160', 'Außenanlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  177, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0177',  '160', 'Hof- und Wegebefestigungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  178, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0178',  '160', 'Einrichtungen für Geschäfts-, Fabrik-, Wohn- und andere Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  179, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0179',  '160', 'Andere Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  180, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0180',  '160', 'Geschäfts-, Fabrik- und andere Bauten im Bau auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  189, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0189',  '160', 'Anzahlungen auf Geschäfts-, Fabrik- und andere Bauten auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  190, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0190',  '160', 'Wohnbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  191, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0191',  '160', 'Garagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  192, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0192',  '160', 'Außenanlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  193, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0193',  '160', 'Hof- und Wegebefestigungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  194, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0194',  '160', 'Einrichtungen für Wohnbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  195, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0195',  '160', 'Wohnbauten im Bau auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  199, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0199',  '160', 'Anzahlungen auf Wohnbauten auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  200, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0200',    '0', 'Technische Anlagen und Maschinen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  210, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0210',  '200', 'Maschinen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  220, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0220',  '200', 'Maschinengebundene Werkzeuge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  240, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0240',  '200', 'Technische Anlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  260, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0260',  '200', 'Transportanlagen und Ähnliches');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  280, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0280',  '200', 'Betriebsvorrichtungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  290, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0290',  '200', 'Technische Anlagen und Maschinen im Bau');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  299, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0299',  '200', 'Anzahlungen auf technische Anlagen und Maschinen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  300, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0300',    '0', 'Andere Anlagen, Betriebs- und Geschäftsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  310, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0310',  '300', 'Andere Anlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  320, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0320',  '300', 'Pkw');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  350, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0350',  '300', 'Lkw');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  380, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0380',  '300', 'Sonstige Transportmittel');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  400, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0400',  '300', 'Betriebsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  410, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0410',  '300', 'Geschäftsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  420, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0420',  '300', 'Büroeinrichtung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  430, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0430',  '300', 'Ladeneinrichtung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  440, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0440',  '300', 'Werkzeuge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  450, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0450',  '300', 'Einbauten in fremde Grundstücke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  460, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0460',  '300', 'Gerüst- und Schalungsmaterial');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  480, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0480',  '300', 'Geringwertige Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  485, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0485',  '300', 'Wirtschaftsgüter (Sammelposten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  490, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0490',  '300', 'Sonstige Betriebs- und Geschäftsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  498, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0498',  '300', 'Andere Anlagen, Betriebs- und Geschäftsausstattung im Bau');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  499, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0499',  '300', 'Anzahlungen auf andere Anlagen, Betriebs- und Geschäftsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  500, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0500',    '0', 'Anteile an verbundenen Unternehmen (Anlagevermögen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  501, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0501',    '0', 'Anteile an verbundenen Unternehmen, Personengesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  502, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0502',    '0', 'Anteile an verbundenen Unternehmen, Kapitalgesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  503, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0503',    '0', 'Anteile an herrschender oder mehrheitlich beteiligter Gesellschaft, Kapitalgesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  504, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0504',    '0', 'Anteile an herrschender oder mehrheitlich beteiligter Gesellschaft');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  505, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0505',    '0', 'Ausleihungen an verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  506, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0506',    '0', 'Ausleihungen an verbundene Unternehmen, Personengesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  507, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0507',    '0', 'Ausleihungen an verbundene Unternehmen, Kapitalgesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  508, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0508',    '0', 'Ausleihungen an verbundene Unternehmen, Einzelunternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  509, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0509',    '0', 'Anteile an herrschender oder mehrheitlich beteiligter Gesellschaft, Personengesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  510, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0510',    '0', 'Beteiligungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  513, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0513',    '0', 'Typisch stille Beteiligungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  516, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0516',    '0', 'Atypisch stille Beteiligungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  517, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0517',    '0', 'Beteiligungen an Kapitalgesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  518, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0518',    '0', 'Beteiligungen an Personengesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  519, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0519',    '0', 'Beteiligung einer GmbH & Co. KG an einer Komplementär GmbH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  520, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0520',    '0', 'Ausleihungen an Unternehmen, mit denen ein Beteiligungsverhältnis besteht');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  523, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0523',    '0', 'Ausleihungen an Unternehmen, mit denen ein Beteiligungsverhältnis besteht, Personengesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  524, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0524',    '0', 'Ausleihungen an Unternehmen, mit denen ein Beteiligungsverhältnis besteht, Kapitalgesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  525, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0525',    '0', 'Wertpapiere des Anlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  530, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0530',  '525', 'Wertpapiere mit Gewinnbeteiligungsansprüchen, die dem Teileinkünfteverfahren unterliegen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  535, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0535',  '525', 'Festverzinsliche Wertpapiere');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  538, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0538',  '525', 'Anteile einer GmbH & Co. KG an einer Komplementär-GmbH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  540, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0540',    '0', 'Übrige sonstige Ausleihungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  550, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0550',  '540', 'Darlehen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  570, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0570',    '0', 'Genossenschaftsanteile zum langfristigen Verbleib');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  580, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0580',  '570', 'Ausleihungen an Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  582, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0582',  '570', 'Ausleihungen an GmbH-Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  583, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0583',  '570', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  584, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0584',  '570', 'Ausleihungen an persönlich haftende Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  586, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0586',  '570', 'Ausleihungen an Kommanditisten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  590, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0590',  '570', 'Ausleihungen an nahe stehende Personen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  595, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0595',    '0', 'Rückdeckungsansprüche aus Lebensversicherungen zum langfristigen Verbleib');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  600, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0600',    '0', 'Anleihen nicht konvertibel');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  601, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0601',  '600', 'Anleihen nicht konvertibel - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  605, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0605',  '600', 'Anleihen nicht konvertibel - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  610, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0610',  '600', 'Anleihen nicht konvertibel - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  615, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0615',  '600', 'Anleihen konvertibel');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  616, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0616',  '600', 'Anleihen konvertibel - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  620, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0620',  '600', 'Anleihen konvertibel - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  625, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0625',  '600', 'Anleihen konvertibel- Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  630, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0630',    '0', 'Verbindlichkeiten gegenüber Kreditinstituten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  631, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0631',  '630', 'Verbindlichkeiten gegenüber Kreditinstituten - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  640, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0640',  '630', 'Verbindlichkeiten gegenüber Kreditinstituten - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  650, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0650',  '630', 'Verbindlichkeiten gegenüber Kreditinstituten - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  660, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0660',  '630', 'Verbindlichkeiten gegenüber Kreditinstituten aus Teilzahlungsverträgen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  661, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0661',  '630', 'Verbindlichkeiten gegenüber Kreditinstituten aus Teilzahlungsverträgen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  670, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0670',  '630', 'Verbindlichkeiten gegenüber Kreditinstituten aus Teilzahlungsverträgen - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  680, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0680',  '630', 'Verbindlichkeiten gegenüber Kreditinstituten aus Teilzahlungsverträgen - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  690, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0690',  '630', 'Verbindlichkeiten gegenüber Kreditinstituten, vor Restlaufzeitdifferenzierung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  699, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0699',  '630', 'Gegenkonto 0630-0689 bei Aufteilung der Konten 0690-0698');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  700, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0700',    '0', 'Verbindlichkeiten gegenüber verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  701, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0701',  '700', 'Verbindlichkeiten gegenüber verbundenen Unternehmen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  705, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0705',  '700', 'Verbindlichkeiten gegenüber verbundenen Unternehmen - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  710, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0710',  '700', 'Verbindlichkeiten gegenüber verbundenen Unternehmen - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  715, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0715',    '0', 'Verbindlichkeiten gegenüber Unternehmen, mit denen ein Beteiligungsverhältnis besteht');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  716, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0716',  '715', 'Verbindlichkeiten gegenüber Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  720, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0720',  '715', 'Verbindlichkeiten gegenüber Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  725, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0725',  '715', 'Verbindlichkeiten gegenüber Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  730, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0730',    '0', 'Verbindlichkeiten gegenüber Gesellschaftern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  731, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0731',  '730', 'Verbindlichkeiten gegenüber Gesellschaftern - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  740, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0740',  '730', 'Verbindlichkeiten gegenüber Gesellschaftern - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  750, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0750',  '730', 'Verbindlichkeiten gegenüber Gesellschaftern - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  755, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0755',  '730', 'Verbindlichkeiten gegenüber Gesellschaftern für offene Ausschüttungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  760, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0760',  '730', 'Verbindlichkeiten gegenüber typisch stillen Gesellschaftern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  761, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0761',  '730', 'Verbindlichkeiten gegenüber typisch stillen Gesellschaftern - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  764, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0764',  '730', 'Verbindlichkeiten gegenüber typisch stillen Gesellschaftern - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  767, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0767',  '730', 'Verbindlichkeiten gegenüber typisch stillen Gesellschaftern - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  770, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0770',  '730', 'Verbindlichkeiten gegenüber atypisch stillen Gesellschaftern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  771, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0771',  '730', 'Verbindlichkeiten gegenüber atypisch stillen Gesellschaftern - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  774, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0774',  '730', 'Verbindlichkeiten gegenüber atypisch stillen Gesellschaftern - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  777, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0777',  '730', 'Verbindlichkeiten gegenüber atypisch stillen Gesellschaftern - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  780, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0780',  '730', 'Partiarische Darlehen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  781, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0781',  '730', 'Partiarische Darlehen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  784, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0784',  '730', 'Partiarische Darlehen - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  787, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0787',  '730', 'Partiarische Darlehen - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  790, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0790',  '730', 'Sonstige Verbindlichkeiten, vor Restlaufzeitdifferenzierung (nur Bilanzierer)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  799, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0799',  '730', 'Gegenkonto 0730-0789 und 1665-1678 und 1695-1698 bei Aufteilung der Konten 0790-0798');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  800, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0800',    '0', 'Gezeichnetes Kapital');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  809, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0809',  '800', 'Kapitalerhöhung aus Gesellschaftsmitteln');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  810, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0810',  '800', 'Geschäftsguthaben der verbleibenden Mitglieder');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  811, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0811',  '800', 'Geschäftsguthaben der ausscheidenden Mitglieder');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  812, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0812',  '800', 'Geschäftsguthaben aus gekündigten Geschäftsanteilen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  813, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0813',  '800', 'Rückständige fällige Einzahlungen auf Geschäftsanteile, vermerkt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  815, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0815',  '800', 'Gegenkonto Rückständige fällige Einzahlungen auf Geschäftsanteile, vermerkt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  819, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0819',  '800', 'Erworbene eigene Anteile');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  820, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0820',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, nicht eingefordert (Passivausweis, vom gezeichneten Kapital offen abgesetzt; eingeforderte ausstehende Einlagen s.Konten 0830-0838)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  821, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0821',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, nicht eingefordert (Passivausweis, vom gezeichneten Kapital offen abgesetzt; eingeforderte ausstehende Einlagen s.Konten 0830-0838)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  822, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0822',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, nicht eingefordert (Passivausweis, vom gezeichneten Kapital offen abgesetzt; eingeforderte ausstehende Einlagen s.Konten 0830-0838)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  823, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0823',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, nicht eingefordert (Passivausweis, vom gezeichneten Kapital offen abgesetzt; eingeforderte ausstehende Einlagen s.Konten 0830-0838)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  824, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0824',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, nicht eingefordert (Passivausweis, vom gezeichneten Kapital offen abgesetzt; eingeforderte ausstehende Einlagen s.Konten 0830-0838)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  825, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0825',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, nicht eingefordert (Passivausweis, vom gezeichneten Kapital offen abgesetzt; eingeforderte ausstehende Einlagen s.Konten 0830-0838)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  826, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0826',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, nicht eingefordert (Passivausweis, vom gezeichneten Kapital offen abgesetzt; eingeforderte ausstehende Einlagen s.Konten 0830-0838)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  827, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0827',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, nicht eingefordert (Passivausweis, vom gezeichneten Kapital offen abgesetzt; eingeforderte ausstehende Einlagen s.Konten 0830-0838)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  828, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0828',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, nicht eingefordert (Passivausweis, vom gezeichneten Kapital offen abgesetzt; eingeforderte ausstehende Einlagen s.Konten 0830-0838)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  829, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0829',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, nicht eingefordert (Passivausweis, vom gezeichneten Kapital offen abgesetzt; eingeforderte ausstehende Einlagen s.Konten 0830-0838)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  830, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0830',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, eingefordert (Forderungen, nicht eingeforderte ausstehende Einlagen s. Konten 0820-0829)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  831, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0831',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, eingefordert (Forderungen, nicht eingeforderte ausstehende Einlagen s. Konten 0820-0829)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  832, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0832',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, eingefordert (Forderungen, nicht eingeforderte ausstehende Einlagen s. Konten 0820-0829)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  833, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0833',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, eingefordert (Forderungen, nicht eingeforderte ausstehende Einlagen s. Konten 0820-0829)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  834, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0834',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, eingefordert (Forderungen, nicht eingeforderte ausstehende Einlagen s. Konten 0820-0829)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  835, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0835',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, eingefordert (Forderungen, nicht eingeforderte ausstehende Einlagen s. Konten 0820-0829)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  836, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0836',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, eingefordert (Forderungen, nicht eingeforderte ausstehende Einlagen s. Konten 0820-0829)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  837, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0837',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, eingefordert (Forderungen, nicht eingeforderte ausstehende Einlagen s. Konten 0820-0829)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  838, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0838',  '800', 'Ausstehende Einlagen auf das gezeichnete Kapital, eingefordert (Forderungen, nicht eingeforderte ausstehende Einlagen s. Konten 0820-0829)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  839, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0839',  '800', 'Nachschüsse (Forderungen, Gegenkonto 0845)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  840, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0840',    '0', 'Kapitalrücklage');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  841, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0841',  '840', 'Kapitalrücklage durch Ausgabe von Anteilen über Nennbetrag');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  842, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0842',  '840', 'Kapitalrücklage durch Ausgabe von Schuldverschreibungen für Wandlungsrechte und Optionsrechte zum Erwerb von Anteilen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  843, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0843',  '840', 'Kapitalrücklage durch Zuzahlungen gegen Gewährung eines Vorzugs für Anteile');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  844, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0844',  '840', 'Kapitalrücklage durch andere Zuzahlungen in das Eigenkapital');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  845, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0845',  '840', 'Nachschusskapital (Gegenkonto 0839)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  846, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0846',    '0', 'Gesetzliche Rücklage');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  848, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0848',  '846', 'Andere Gewinnrücklagen aus dem Erwerb eigener Anteile');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  849, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0849',  '846', 'Rücklage für Anteile an einem herrschenden oder mehrheitlich beteiligten Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  851, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0851',    '0', 'Satzungsmäßige Rücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  852, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0852',  '581', 'Andere Ergebnisrücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  853, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0853',    '0', 'Gewinnrücklagen aus den Übergangsvorschriften BilMoG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  854, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0854',  '853', 'Gewinnrücklagen aus den Übergangsvorschriften BilMoG (Zuschreibung Sachanlagevermögen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  855, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0855',    '0', 'Andere Gewinnrücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  856, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0856',  '855', 'Eigenkapitalanteil von Wertaufholungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  857, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0857',  '855', 'Gewinnrücklagen aus den Übergangsvorschriften BilMoG (Zuschreibung Finanzanlagevermögen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  858, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0858',  '855', 'Gewinnrücklagen aus den Übergangsvorschriften BilMoG (Auflösung der Sonderposten mit Rücklageanteil)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  859, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0859',  '855', 'Latente Steuern (Gewinnrücklage Haben) aus erfolgsneutralen Verrechnungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  860, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0860',    '0', 'Gewinnvortrag vor Verwendung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  865, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0865',  '860', 'Gewinnvortrag vor Verwendung (mit Aufteilung für Kapitalkontenentwicklung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  867, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0867',  '860', 'Verlustvortrag vor Verwendung (mit Aufteilung für Kapitalkontenentwicklung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  868, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0868',    '0', 'Verlustvortrag vor Verwendung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  870, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0870',    '0', 'Festkapital');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  871, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0871',    '0', 'Kapital (fester Anteil, nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  880, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0880',    '0', 'Variables Kapital');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  881, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0881',    '0', 'Kapital (variabler Anteil, nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  890, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0890',    '0', 'Gesellschafter-Darlehen');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  891, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0891',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  892, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0892',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  893, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0893',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  894, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0894',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  895, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0895',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  896, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0896',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  897, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0897',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  898, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0898',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  899, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0899',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  900, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0900',    '0', 'Kommandit-Kapital');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  901, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0901',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  902, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0902',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  903, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0903',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  904, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0904',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  905, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0905',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  906, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0906',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  907, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0907',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  908, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0908',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  909, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0909',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  910, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0910',    '0', 'Verlustausgleichskonto');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  911, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0911',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  912, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0912',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  913, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0913',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  914, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0914',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  915, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0915',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  916, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0916',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  917, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0917',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  918, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0918',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  919, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0919',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  920, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0920',    '0', 'Gesellschafter-Darlehen');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  921, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0921',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  922, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0922',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  923, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0923',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  924, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0924',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  925, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0925',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  926, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0926',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  927, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0927',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  928, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0928',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  929, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0929',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  930, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0930',    '0', 'Übrige andere Sonderposten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  931, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0931',    '0', 'Steuerfreie Rücklagen nach § 6b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  932, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0932',    '0', 'Rücklage für Ersatzbeschaffung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  940, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0940',    '0', 'Sonderposten mit Rücklageanteil, Sonderabschreibungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  945, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0945',    '0', 'Ausgleichsposten bei Entnahmen § 4g EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  946, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0946',    '0', 'Rücklage für Zuschüsse');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  947, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0947',    '0', 'Sonderposten mit Rücklageanteil nach § 7g Abs. 5 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  948, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0948',    '0', 'Sonderposten für Zuschüsse Dritter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  949, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0949',    '0', 'Sonderposten für Investitionszulagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  950, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0950',    '0', 'Rückstellungen für Pensionen und ähnliche Verpflichtungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  951, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0951',  '950', 'Rückstellungen für Pensionen und ähnliche Verpflichtungen zur Saldierung mit Vermögensgegenständen zum langfristigen Verbleib nach § 246 Abs. 2 HGB');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  952, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0952',  '950', 'Rückstellungen für Pensionen und ähnliche Verpflichtungen gegenüber Gesellschaftern oder nahe stehenden Personen (10 % Beteiligung am Kapital)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  953, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0953',  '950', 'Rückstellungen für Direktzusagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  954, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0954',  '950', 'Rückstellungen für Zuschussverpflichtungen für Pensionskassen und Lebensversicherungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  955, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0955',    '0', 'Steuerrückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  956, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0956',  '955', 'Gewerbesteuerrückstellung nach § 4 Abs. 5b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  961, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0961',  '955', 'Urlaubsrückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  962, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0962',  '955', 'Steuerrückstellung aus Steuerstundung (BStBK)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  963, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0963',  '955', 'Körperschaftsteuerrückstellung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  964, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0964',  '955', 'Rückstellungen für mit der Altersversorgung vergleichbare langfristige Verpflichtungen zum langfristigen Verbleib');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  965, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0965',  '955', 'Rückstellungen für Personalkosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  966, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0966',  '955', 'Rückstellungen zur Erfüllung der Aufbewahrungspflichten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  967, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0967',  '955', 'Rückstellungen für mit der Altersversorgung vergleichbare langfristige Verpflichtungen zur Saldierung mit Vermögensgegenständen zum langfristigen Verbleib nach § 246 Abs. 2 HGB');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  968, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0968',  '955', 'Passive latente Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  969, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0969',  '955', 'Rückstellung für latente Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  970, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0970',  '955', 'Sonstige Rückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  971, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0971',  '955', 'Rückstellungen für unterlassene Aufwendungen für Instandhaltung, Nachholung in den ersten drei Monaten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  973, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0973',  '955', 'Rückstellungen für Abraum- und Abfallbeseitigung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  974, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0974',  '955', 'Rückstellungen für Gewährleistungen (Gegenkonto 4790)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  976, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0976',  '955', 'Rückstellungen für drohende Verluste aus schwebenden Geschäften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  977, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0977',  '955', 'Rückstellungen für Abschluss- und Prüfungskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  978, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0978',  '955', 'Aufwandsrückstellungen nach § 249 Abs. 2 HGB a. F.');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  979, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0979',  '955', 'Rückstellungen für Umweltschutz');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  980, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0980',    '0', 'Aktive Rechnungsabgrenzung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  983, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0983',  '980', 'Aktive latente Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  984, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0984',  '980', 'Als Aufwand berücksichtigte Zölle und Verbrauchsteuern auf Vorräte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  985, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0985',  '980', 'Als Aufwand berücksichtigte Umsatzsteuer auf Anzahlungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  986, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0986',  '980', 'Damnum/Disagio');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  987, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0987',  '980', 'Rechnungsabgrenzungsposten (Gewinnrücklage Soll) aus erfolgsneutralen Verrechnungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  988, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0988',  '980', 'Latente Steuern (Gewinnrücklage Soll) aus erfolgsneutralen Verrechnungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  989, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0989',  '980', 'Gesamthänderisch gebundene Rücklagen (mit Aufteilung für Kapitalkontenentwicklung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  990, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0990',    '0', 'Passive Rechnungsabgrenzung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  992, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0992',  '990', 'Abgrenzungen unterjährig pauschal gebuchter Abschreibungen für BWA');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  996, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0996',  '990', 'Pauschalwertberichtigung auf Forderungen - Restlaufzeit bis zu 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  997, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0997',  '990', 'Pauschalwertberichtigung auf Forderungen - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  998, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0998',  '990', 'Einzelwertberichtigungen auf Forderungen - Restlaufzeit bis zu 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__,  999, 'SKR03', '0: Anlage- und Kapitalkonten',                               '0999',  '990', 'Einzelwertberichtigungen auf Forderungen - Restlaufzeit größer 1 Jahr');
---- 1: Finanz- und Privatkonten
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1000, 'SKR03', '1: Finanz- und Privatkonten',                                '1000',    '0', 'Kasse');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1010, 'SKR03', '1: Finanz- und Privatkonten',                                '1010', '1000', 'Nebenkasse 1');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1020, 'SKR03', '1: Finanz- und Privatkonten',                                '1020', '1000', 'Nebenkasse 2');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1100, 'SKR03', '1: Finanz- und Privatkonten',                                '1100',    '0', 'Bank (Postbank)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1110, 'SKR03', '1: Finanz- und Privatkonten',                                '1110', '1100', 'Bank (Postbank 1)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1120, 'SKR03', '1: Finanz- und Privatkonten',                                '1120', '1100', 'Bank (Postbank 2)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1130, 'SKR03', '1: Finanz- und Privatkonten',                                '1130', '1100', 'Bank (Postbank 3)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1190, 'SKR03', '1: Finanz- und Privatkonten',                                '1190', '1100', 'LZB-Guthaben');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1195, 'SKR03', '1: Finanz- und Privatkonten',                                '1195', '1100', 'Bundesbankguthaben');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1200, 'SKR03', '1: Finanz- und Privatkonten',                                '1200',    '0', 'Bank');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1210, 'SKR03', '1: Finanz- und Privatkonten',                                '1210', '1200', 'Bank 1');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1220, 'SKR03', '1: Finanz- und Privatkonten',                                '1220', '1200', 'Bank 2');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1230, 'SKR03', '1: Finanz- und Privatkonten',                                '1230', '1200', 'Bank 3');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1240, 'SKR03', '1: Finanz- und Privatkonten',                                '1240', '1200', 'Bank 4');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1250, 'SKR03', '1: Finanz- und Privatkonten',                                '1250', '1200', 'Bank 5');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1289, 'SKR03', '1: Finanz- und Privatkonten',                                '1289', '1200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1290, 'SKR03', '1: Finanz- und Privatkonten',                                '1290', '1200', 'Finanzmittelanlagen im Rahmen der kurzfristigen Finanzdisposition (nicht im Finanzmittelfonds enthalten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1295, 'SKR03', '1: Finanz- und Privatkonten',                                '1295', '1200', 'Verbindlichkeiten gegenüber Kreditinstituten (nicht im Finanzmittelfonds enthalten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1300, 'SKR03', '1: Finanz- und Privatkonten',                                '1300', '1200', 'Wechsel aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1301, 'SKR03', '1: Finanz- und Privatkonten',                                '1301', '1200', 'Wechsel aus Lieferungen und Leistungen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1302, 'SKR03', '1: Finanz- und Privatkonten',                                '1302', '1200', 'Wechsel aus Lieferungen und Leistungen - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1305, 'SKR03', '1: Finanz- und Privatkonten',                                '1305', '1200', 'Wechsel aus Lieferungen und Leistungen, bundesbankfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1310, 'SKR03', '1: Finanz- und Privatkonten',                                '1310', '1200', 'Besitzwechsel gegen verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1311, 'SKR03', '1: Finanz- und Privatkonten',                                '1311', '1200', 'Besitzwechsel gegen verbundene Unternehmen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1312, 'SKR03', '1: Finanz- und Privatkonten',                                '1312', '1200', 'Besitzwechsel gegen verbundene Unternehmen - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1315, 'SKR03', '1: Finanz- und Privatkonten',                                '1315', '1200', 'Besitzwechsel gegen verbundene Unternehmen, bundesbankfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1320, 'SKR03', '1: Finanz- und Privatkonten',                                '1320', '1200', 'Besitzwechsel gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1321, 'SKR03', '1: Finanz- und Privatkonten',                                '1321', '1200', 'Besitzwechsel gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1322, 'SKR03', '1: Finanz- und Privatkonten',                                '1322', '1200', 'Besitzwechsel gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1325, 'SKR03', '1: Finanz- und Privatkonten',                                '1325', '1200', 'Besitzwechsel gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht, bundesbankfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1327, 'SKR03', '1: Finanz- und Privatkonten',                                '1327', '1200', 'Finanzwechsel');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1329, 'SKR03', '1: Finanz- und Privatkonten',                                '1329', '1200', 'Andere Wertpapiere mit unwesentlichen Wertschwankungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1330, 'SKR03', '1: Finanz- und Privatkonten',                                '1330',    '0', 'Schecks');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1340, 'SKR03', '1: Finanz- und Privatkonten',                                '1340',    '0', 'Anteile an verbundenen Unternehmen (Umlaufvermögen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1344, 'SKR03', '1: Finanz- und Privatkonten',                                '1344',    '0', 'Anteile an herrschender oder mit Mehrheit beteiligter Gesellschaft');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1348, 'SKR03', '1: Finanz- und Privatkonten',                                '1348',    '0', 'Sonstige Wertpapiere');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1349, 'SKR03', '1: Finanz- und Privatkonten',                                '1349', '1348', 'Wertpapieranlagen im Rahmen der kurzfristigen Finanzdisposition');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1350, 'SKR03', '1: Finanz- und Privatkonten',                                '1350',    '0', 'GmbH-Anteile zum kurzfristigen Verbleib');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1352, 'SKR03', '1: Finanz- und Privatkonten',                                '1352',    '0', 'Genossenschaftsanteile zum kurzfristigen Verbleib');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1353, 'SKR03', '1: Finanz- und Privatkonten',                                '1353',    '0', 'Vermögensgegenstände zur Erfüllung von mit der Altersversorgung vergleichbaren langfristigen Verpflichtungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1354, 'SKR03', '1: Finanz- und Privatkonten',                                '1354',    '0', 'Vermögensgegenstände zur Saldierung mit der Altersversorgung vergleichbaren langfristigen Verpflichtungen nach § 246 Abs. 2 HGB');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1355, 'SKR03', '1: Finanz- und Privatkonten',                                '1355',    '0', 'Ansprüche aus Rückdeckungsversicherungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1356, 'SKR03', '1: Finanz- und Privatkonten',                                '1356',    '0', 'Vermögensgegenstände zur Erfüllung von Pensionsrückstellungen und ähnlichen Verpflichtungen zum langfristigen Verbleib');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1357, 'SKR03', '1: Finanz- und Privatkonten',                                '1357',    '0', 'Vermögensgegenstände zur Saldierung mit Pensionsrückstellungen und ähnlichen Verpflichtungen zum langfristigen Verbleib nach § 246 Abs. 2 HGB');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1358, 'SKR03', '1: Finanz- und Privatkonten',                                '1358',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1359, 'SKR03', '1: Finanz- und Privatkonten',                                '1359',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1360, 'SKR03', '1: Finanz- und Privatkonten',                                '1360',    '0', 'Geldtransit');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1370, 'SKR03', '1: Finanz- und Privatkonten',                                '1370',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1371, 'SKR03', '1: Finanz- und Privatkonten',                                '1371',    '0', 'Verrechnungskonto Gewinnermittlung § 4 Abs. 3 EStG, nicht ergebniswirksam');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1372, 'SKR03', '1: Finanz- und Privatkonten',                                '1372',    '0', 'Wirtschaftsgüter des Umlaufvermögens nach § 4 Abs. 3 Satz 4 EStG');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1373, 'SKR03', '1: Finanz- und Privatkonten',                                '1373',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1374, 'SKR03', '1: Finanz- und Privatkonten',                                '1374',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1375, 'SKR03', '1: Finanz- und Privatkonten',                                '1375',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1376, 'SKR03', '1: Finanz- und Privatkonten',                                '1376',    '0', 'Forderungen gegen typisch stille Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1377, 'SKR03', '1: Finanz- und Privatkonten',                                '1377',    '0', 'Forderungen gegen typisch stille Gesellschafter - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1378, 'SKR03', '1: Finanz- und Privatkonten',                                '1378',    '0', 'Forderungen gegen typisch stille Gesellschafter - Restlaufzeit größer 1 Jahr');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1379, 'SKR03', '1: Finanz- und Privatkonten',                                '1379',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1380, 'SKR03', '1: Finanz- und Privatkonten',                                '1380',    '0', 'Überleitungskonto Kostenstelle');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1381, 'SKR03', '1: Finanz- und Privatkonten',                                '1381',    '0', 'Forderungen gegen GmbH-Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1382, 'SKR03', '1: Finanz- und Privatkonten',                                '1382',    '0', 'Forderungen gegen GmbH-Gesellschafter - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1383, 'SKR03', '1: Finanz- und Privatkonten',                                '1383',    '0', 'Forderungen gegen GmbH-Gesellschafter - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1385, 'SKR03', '1: Finanz- und Privatkonten',                                '1385',    '0', 'Forderungen gegen persönlich haftende Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1386, 'SKR03', '1: Finanz- und Privatkonten',                                '1386',    '0', 'Forderungen gegen persönlich haftende Gesellschafter - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1387, 'SKR03', '1: Finanz- und Privatkonten',                                '1387',    '0', 'Forderungen gegen persönlich haftende Gesellschafter - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1389, 'SKR03', '1: Finanz- und Privatkonten',                                '1389',    '0', 'Ansprüche aus betrieblicher Altersversorgung und Pensionsansprüche (Mitunternehmer)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1390, 'SKR03', '1: Finanz- und Privatkonten',                                '1390',    '0', 'Verrechnungskonto Ist-Versteuerung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1391, 'SKR03', '1: Finanz- und Privatkonten',                                '1391',    '0', 'Neutralisierung ertragswirksamer Sachverhalte für § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1394, 'SKR03', '1: Finanz- und Privatkonten',                                '1394',    '0', 'Forderungen gegen Gesellschaft/Gesamthand');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1400, 'SKR03', '1: Finanz- und Privatkonten',                                '1400',    '0', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1401, 'SKR03', '1: Finanz- und Privatkonten',                                '1401', '1400', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1402, 'SKR03', '1: Finanz- und Privatkonten',                                '1402', '1400', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1403, 'SKR03', '1: Finanz- und Privatkonten',                                '1403', '1400', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1404, 'SKR03', '1: Finanz- und Privatkonten',                                '1404', '1400', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1405, 'SKR03', '1: Finanz- und Privatkonten',                                '1405', '1400', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1406, 'SKR03', '1: Finanz- und Privatkonten',                                '1406', '1400', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1410, 'SKR03', '1: Finanz- und Privatkonten',                                '1410', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1411, 'SKR03', '1: Finanz- und Privatkonten',                                '1411', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1412, 'SKR03', '1: Finanz- und Privatkonten',                                '1412', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1413, 'SKR03', '1: Finanz- und Privatkonten',                                '1413', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1414, 'SKR03', '1: Finanz- und Privatkonten',                                '1414', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1415, 'SKR03', '1: Finanz- und Privatkonten',                                '1415', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1416, 'SKR03', '1: Finanz- und Privatkonten',                                '1416', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1417, 'SKR03', '1: Finanz- und Privatkonten',                                '1417', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1418, 'SKR03', '1: Finanz- und Privatkonten',                                '1418', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1419, 'SKR03', '1: Finanz- und Privatkonten',                                '1419', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1420, 'SKR03', '1: Finanz- und Privatkonten',                                '1420', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1421, 'SKR03', '1: Finanz- und Privatkonten',                                '1421', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1422, 'SKR03', '1: Finanz- und Privatkonten',                                '1422', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1423, 'SKR03', '1: Finanz- und Privatkonten',                                '1423', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1424, 'SKR03', '1: Finanz- und Privatkonten',                                '1424', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1425, 'SKR03', '1: Finanz- und Privatkonten',                                '1425', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1426, 'SKR03', '1: Finanz- und Privatkonten',                                '1426', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1427, 'SKR03', '1: Finanz- und Privatkonten',                                '1427', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1428, 'SKR03', '1: Finanz- und Privatkonten',                                '1428', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1429, 'SKR03', '1: Finanz- und Privatkonten',                                '1429', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1430, 'SKR03', '1: Finanz- und Privatkonten',                                '1430', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1431, 'SKR03', '1: Finanz- und Privatkonten',                                '1431', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1432, 'SKR03', '1: Finanz- und Privatkonten',                                '1432', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1433, 'SKR03', '1: Finanz- und Privatkonten',                                '1433', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1434, 'SKR03', '1: Finanz- und Privatkonten',                                '1434', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1435, 'SKR03', '1: Finanz- und Privatkonten',                                '1435', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1436, 'SKR03', '1: Finanz- und Privatkonten',                                '1436', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1437, 'SKR03', '1: Finanz- und Privatkonten',                                '1437', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1438, 'SKR03', '1: Finanz- und Privatkonten',                                '1438', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1439, 'SKR03', '1: Finanz- und Privatkonten',                                '1439', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1440, 'SKR03', '1: Finanz- und Privatkonten',                                '1440', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1441, 'SKR03', '1: Finanz- und Privatkonten',                                '1441', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1442, 'SKR03', '1: Finanz- und Privatkonten',                                '1442', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1443, 'SKR03', '1: Finanz- und Privatkonten',                                '1443', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1444, 'SKR03', '1: Finanz- und Privatkonten',                                '1444', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1445, 'SKR03', '1: Finanz- und Privatkonten',                                '1445', '1400', 'Forderungen aus Lieferungen und Leistungen zum allgemeinen Umsatzsteuersatz oder eines Kleinunternehmers (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1446, 'SKR03', '1: Finanz- und Privatkonten',                                '1446', '1400', 'Forderungen aus Lieferungen und Leistungen zum ermäßigten Umsatzsteuersatz (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1447, 'SKR03', '1: Finanz- und Privatkonten',                                '1447', '1400', 'Forderungen aus steuerfreien oder nicht steuerbaren Lieferungen und Leistungen (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1448, 'SKR03', '1: Finanz- und Privatkonten',                                '1448', '1400', 'Forderungen aus Lieferungen und Leistungen nach Durchschnittssätzen nach § 24 UStG (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1449, 'SKR03', '1: Finanz- und Privatkonten',                                '1449', '1400', 'Gegenkonto 1445-1448 bei Aufteilung der Forderungen nach Steuersätzen (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1450, 'SKR03', '1: Finanz- und Privatkonten',                                '1450', '1400', 'Forderungen nach § 11 Abs. 1 Satz 2 EStG für § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1451, 'SKR03', '1: Finanz- und Privatkonten',                                '1451', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent (Restlaufzeit bis 1 Jahr)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1455, 'SKR03', '1: Finanz- und Privatkonten',                                '1455', '1400', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent (Restlaufzeit größer 1 Jahr)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1460, 'SKR03', '1: Finanz- und Privatkonten',                                '1460', '1400', 'Zweifelhafte Forderungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1461, 'SKR03', '1: Finanz- und Privatkonten',                                '1461', '1400', 'Zweifelhafte Forderungen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1465, 'SKR03', '1: Finanz- und Privatkonten',                                '1465', '1400', 'Zweifelhafte Forderungen - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1470, 'SKR03', '1: Finanz- und Privatkonten',                                '1470', '1400', 'Forderungen aus Lieferungen und Leistungen gegen verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1471, 'SKR03', '1: Finanz- und Privatkonten',                                '1471', '1400', 'Forderungen aus Lieferungen und Leistungen gegen verbundene Unternehmen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1475, 'SKR03', '1: Finanz- und Privatkonten',                                '1475', '1400', 'Forderungen aus Lieferungen und Leistungen gegen verbundene Unternehmen - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1478, 'SKR03', '1: Finanz- und Privatkonten',                                '1478', '1400', 'Wertberichtigungen auf Forderungen gegen verbundene Unternehmen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1479, 'SKR03', '1: Finanz- und Privatkonten',                                '1479', '1400', 'Wertberichtigungen auf Forderungen gegen verbundene Unternehmen - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1480, 'SKR03', '1: Finanz- und Privatkonten',                                '1480', '1400', 'Forderungen aus Lieferungen und Leistungen gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1481, 'SKR03', '1: Finanz- und Privatkonten',                                '1481', '1400', 'Forderungen aus Lieferungen und Leistungen gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1485, 'SKR03', '1: Finanz- und Privatkonten',                                '1485', '1400', 'Forderungen aus Lieferungen und Leistungen gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1488, 'SKR03', '1: Finanz- und Privatkonten',                                '1488', '1400', 'Wertberichtigungen auf Forderungen gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1489, 'SKR03', '1: Finanz- und Privatkonten',                                '1489', '1400', 'Wertberichtigungen auf Forderungen gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1490, 'SKR03', '1: Finanz- und Privatkonten',                                '1490', '1400', 'Forderungen aus Lieferungen und Leistungen gegen Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1491, 'SKR03', '1: Finanz- und Privatkonten',                                '1491', '1400', 'Forderungen aus Lieferungen und Leistungen gegen Gesellschafter - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1495, 'SKR03', '1: Finanz- und Privatkonten',                                '1495', '1400', 'Forderungen aus Lieferungen und Leistungen gegen Gesellschafter - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1498, 'SKR03', '1: Finanz- und Privatkonten',                                '1498', '1400', 'Gegenkonto zu sonstigen Vermögensgegenständen bei Buchungen über Debitorenkonto');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1499, 'SKR03', '1: Finanz- und Privatkonten',                                '1499', '1400', 'Gegenkonto 1451-1497 bei Aufteilung Debitorenkonto');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1500, 'SKR03', '1: Finanz- und Privatkonten',                                '1500',    '0', 'Sonstige Vermögensgegenstände');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1501, 'SKR03', '1: Finanz- und Privatkonten',                                '1501', '1500', 'Sonstige Vermögensgegenstände - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1502, 'SKR03', '1: Finanz- und Privatkonten',                                '1502', '1500', 'Sonstige Vermögensgegenstände - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1503, 'SKR03', '1: Finanz- und Privatkonten',                                '1503', '1500', 'Forderungen gegen Vorstandsmitglieder und Geschäftsführer - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1504, 'SKR03', '1: Finanz- und Privatkonten',                                '1504', '1500', 'Forderungen gegen Vorstandsmitglieder und Geschäftsführer - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1505, 'SKR03', '1: Finanz- und Privatkonten',                                '1505', '1500', 'Forderungen gegen Aufsichtsrats- und Beiratsmitglieder - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1506, 'SKR03', '1: Finanz- und Privatkonten',                                '1506', '1500', 'Forderungen gegen Aufsichtsrats- und Beiratsmitglieder - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1507, 'SKR03', '1: Finanz- und Privatkonten',                                '1507', '1500', 'Forderungen gegen sonstige Gesellschafter - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1508, 'SKR03', '1: Finanz- und Privatkonten',                                '1508', '1500', 'Forderungen gegen sonstige Gesellschafter - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1510, 'SKR03', '1: Finanz- und Privatkonten',                                '1510',    '0', 'Geleistete Anzahlungen auf Vorräte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1511, 'SKR03', '1: Finanz- und Privatkonten',                                '1511', '1510', 'Geleistete Anzahlungen, 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1512, 'SKR03', '1: Finanz- und Privatkonten',                                '1512', '1510', 'Geleistete Anzahlungen, 5 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1513, 'SKR03', '1: Finanz- und Privatkonten',                                '1513', '1510', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1514, 'SKR03', '1: Finanz- und Privatkonten',                                '1514', '1510', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1515, 'SKR03', '1: Finanz- und Privatkonten',                                '1515', '1510', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1516, 'SKR03', '1: Finanz- und Privatkonten',                                '1516', '1510', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1517, 'SKR03', '1: Finanz- und Privatkonten',                                '1517', '1510', 'Geleistete Anzahlungen, 16 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1518, 'SKR03', '1: Finanz- und Privatkonten',                                '1518', '1510', 'Geleistete Anzahlungen, 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1519, 'SKR03', '1: Finanz- und Privatkonten',                                '1519', '1510', 'Forderungen gegen Arbeitsgemeinschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1520, 'SKR03', '1: Finanz- und Privatkonten',                                '1520', '1510', 'Forderungen gegenüber Krankenkassen aus Aufwendungsausgleichsgesetz');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1521, 'SKR03', '1: Finanz- und Privatkonten',                                '1521', '1510', 'Agenturwarenabrechnung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1522, 'SKR03', '1: Finanz- und Privatkonten',                                '1522', '1510', 'Genussrechte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1524, 'SKR03', '1: Finanz- und Privatkonten',                                '1524', '1510', 'Einzahlungsansprüche zu Nebenleistungen oder Zuzahlungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1525, 'SKR03', '1: Finanz- und Privatkonten',                                '1525', '1510', 'Kautionen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1526, 'SKR03', '1: Finanz- und Privatkonten',                                '1526', '1510', 'Kautionen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1527, 'SKR03', '1: Finanz- und Privatkonten',                                '1527', '1510', 'Kautionen - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1528, 'SKR03', '1: Finanz- und Privatkonten',                                '1528', '1510', 'Nachträglich abziehbare Vorsteuer nach § 15a Abs. 2 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1529, 'SKR03', '1: Finanz- und Privatkonten',                                '1529', '1510', 'Zurückzuzahlende Vorsteuer nach § 15a Abs. 2 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1530, 'SKR03', '1: Finanz- und Privatkonten',                                '1530', '1510', 'Forderungen gegen Personal aus Lohn- und Gehaltsabrechnung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1531, 'SKR03', '1: Finanz- und Privatkonten',                                '1531', '1510', 'Forderungen gegen Personal aus Lohn- und Gehaltsabrechnung - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1537, 'SKR03', '1: Finanz- und Privatkonten',                                '1537', '1510', 'Forderungen gegen Personal aus Lohn- und Gehaltsabrechnung - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1540, 'SKR03', '1: Finanz- und Privatkonten',                                '1540', '1510', 'Forderungen aus Gewerbesteuerüberzahlungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1542, 'SKR03', '1: Finanz- und Privatkonten',                                '1542', '1510', 'Steuererstattungsansprüche gegenüber anderen Ländern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1543, 'SKR03', '1: Finanz- und Privatkonten',                                '1543', '1510', 'Forderungen an das Finanzamt aus abgeführtem Bauabzugsbetrag');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1544, 'SKR03', '1: Finanz- und Privatkonten',                                '1544', '1510', 'Forderung gegenüber Bundesagentur für Arbeit');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1545, 'SKR03', '1: Finanz- und Privatkonten',                                '1545', '1510', 'Forderungen aus Umsatzsteuer-Vorauszahlungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1546, 'SKR03', '1: Finanz- und Privatkonten',                                '1546', '1510', 'Umsatzsteuerforderungen Vorjahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1547, 'SKR03', '1: Finanz- und Privatkonten',                                '1547', '1510', 'Forderungen aus entrichteten Verbrauchsteuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1548, 'SKR03', '1: Finanz- und Privatkonten',                                '1548', '1510', 'Vorsteuer in Folgeperiode/im Folgejahr abziehbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1549, 'SKR03', '1: Finanz- und Privatkonten',                                '1549', '1510', 'Körperschaftsteuerrückforderung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1550, 'SKR03', '1: Finanz- und Privatkonten',                                '1550', '1510', 'Darlehen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1551, 'SKR03', '1: Finanz- und Privatkonten',                                '1551', '1510', 'Darlehen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1555, 'SKR03', '1: Finanz- und Privatkonten',                                '1555', '1510', 'Darlehen - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1556, 'SKR03', '1: Finanz- und Privatkonten',                                '1556', '1510', 'Nachträglich abziehbare Vorsteuer nach § 15a Abs. 1 UStG, bewegliche Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1557, 'SKR03', '1: Finanz- und Privatkonten',                                '1557', '1510', 'Zurückzuzahlende Vorsteuer nach § 15a Abs. 1 UStG, bewegliche Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1558, 'SKR03', '1: Finanz- und Privatkonten',                                '1558', '1510', 'Nachträglich abziehbare Vorsteuer nach § 15a Abs. 1 UStG, unbewegliche Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1559, 'SKR03', '1: Finanz- und Privatkonten',                                '1559', '1510', 'Zurückzuzahlende Vorsteuer nach § 15a Abs. 1 UStG, unbewegliche Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1560, 'SKR03', '1: Finanz- und Privatkonten',                                '1560', '1510', 'Aufzuteilende Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1561, 'SKR03', '1: Finanz- und Privatkonten',                                '1561', '1510', 'Aufzuteilende Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1562, 'SKR03', '1: Finanz- und Privatkonten',                                '1562', '1510', 'Aufzuteilende Vorsteuer aus innergemeinschaftlichem Erwerb');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1563, 'SKR03', '1: Finanz- und Privatkonten',                                '1563', '1510', 'Aufzuteilende Vorsteuer aus innergemeinschaftlichem Erwerb 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1564, 'SKR03', '1: Finanz- und Privatkonten',                                '1564', '1510', 'Aufzuteilende Vorsteuer 5 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1565, 'SKR03', '1: Finanz- und Privatkonten',                                '1565', '1510', 'Aufzuteilende Vorsteuer 16 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1566, 'SKR03', '1: Finanz- und Privatkonten',                                '1566', '1510', 'Aufzuteilende Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1567, 'SKR03', '1: Finanz- und Privatkonten',                                '1567', '1510', 'Aufzuteilende Vorsteuer nach §§ 13a und 13b UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1568, 'SKR03', '1: Finanz- und Privatkonten',                                '1568', '1510', 'Abziehbare Vorsteuer 5 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1569, 'SKR03', '1: Finanz- und Privatkonten',                                '1569', '1510', 'Aufzuteilende Vorsteuer nach §§ 13a und 13b UStG 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1570, 'SKR03', '1: Finanz- und Privatkonten',                                '1570', '1510', 'Abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1571, 'SKR03', '1: Finanz- und Privatkonten',                                '1571', '1510', 'Abziehbare Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1572, 'SKR03', '1: Finanz- und Privatkonten',                                '1572', '1510', 'Abziehbare Vorsteuer aus innergemeinschaftlichem Erwerb');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1573, 'SKR03', '1: Finanz- und Privatkonten',                                '1573', '1510', 'Vorsteuer aus Erwerb als letzter Abnehmer innerhalb eines Dreiecksgeschäfts');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1574, 'SKR03', '1: Finanz- und Privatkonten',                                '1574', '1510', 'Abziehbare Vorsteuer aus innergemeinschaftlichem Erwerb 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1575, 'SKR03', '1: Finanz- und Privatkonten',                                '1575', '1510', 'Abziehbare Vorsteuer 16 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1576, 'SKR03', '1: Finanz- und Privatkonten',                                '1576', '1510', 'Abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1577, 'SKR03', '1: Finanz- und Privatkonten',                                '1577', '1510', 'Abziehbare Vorsteuer nach § 13b UStG 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1578, 'SKR03', '1: Finanz- und Privatkonten',                                '1578', '1510', 'Abziehbare Vorsteuer nach § 13b UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1579, 'SKR03', '1: Finanz- und Privatkonten',                                '1579', '1510', 'Abziehbare Vorsteuer nach § 13b UStG 16 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1580, 'SKR03', '1: Finanz- und Privatkonten',                                '1580', '1510', 'Gegenkonto Vorsteuer § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1581, 'SKR03', '1: Finanz- und Privatkonten',                                '1581', '1510', 'Auflösung Vorsteuer aus Vorjahr § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1582, 'SKR03', '1: Finanz- und Privatkonten',                                '1582', '1510', 'Vorsteuer aus Investitionen § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1583, 'SKR03', '1: Finanz- und Privatkonten',                                '1583', '1510', 'Gegenkonto für Vorsteuer nach Durchschnittssätzen für § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1584, 'SKR03', '1: Finanz- und Privatkonten',                                '1584', '1510', 'Abziehbare Vorsteuer aus innergemeinschaftlichem Erwerb von Neufahrzeugen von Lieferanten ohne USt-Id-Nr.');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1585, 'SKR03', '1: Finanz- und Privatkonten',                                '1585', '1510', 'Abziehbare Vorsteuer aus der Auslagerung von Gegenständen aus einem Umsatzsteuerlager');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1587, 'SKR03', '1: Finanz- und Privatkonten',                                '1587', '1510', 'Vorsteuer nach allgemeinen Durchschnittssätzen UStVA Kz. 63');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1588, 'SKR03', '1: Finanz- und Privatkonten',                                '1588', '1510', 'Entstandene Einfuhrumsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1589, 'SKR03', '1: Finanz- und Privatkonten',                                '1589', '1510', 'Abziehbare Vorsteuer aus innergemeinschaftlichem Erwerb 16 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1590, 'SKR03', '1: Finanz- und Privatkonten',                                '1590', '1510', 'Durchlaufende Posten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1592, 'SKR03', '1: Finanz- und Privatkonten',                                '1592', '1510', 'Fremdgeld');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1593, 'SKR03', '1: Finanz- und Privatkonten',                                '1593', '1510', 'Verrechnungskonto erhaltene Anzahlungen bei Buchung über Debitorenkonto');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1594, 'SKR03', '1: Finanz- und Privatkonten',                                '1594',    '0', 'Forderungen gegen verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1595, 'SKR03', '1: Finanz- und Privatkonten',                                '1595', '1594', 'Forderungen gegen verbundene Unternehmen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1596, 'SKR03', '1: Finanz- und Privatkonten',                                '1596', '1594', 'Forderungen gegen verbundene Unternehmen - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1597, 'SKR03', '1: Finanz- und Privatkonten',                                '1597', '1594', 'Forderungen gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1598, 'SKR03', '1: Finanz- und Privatkonten',                                '1598', '1594', 'Forderungen gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1599, 'SKR03', '1: Finanz- und Privatkonten',                                '1599', '1594', 'Forderungen gegen Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1600, 'SKR03', '1: Finanz- und Privatkonten',                                '1600',    '0', 'Verbindlichkeiten aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1601, 'SKR03', '1: Finanz- und Privatkonten',                                '1601', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1602, 'SKR03', '1: Finanz- und Privatkonten',                                '1602', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1603, 'SKR03', '1: Finanz- und Privatkonten',                                '1603', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1605, 'SKR03', '1: Finanz- und Privatkonten',                                '1605', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen zum allgemeinen Umsatzsteuersatz (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1606, 'SKR03', '1: Finanz- und Privatkonten',                                '1606', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen zum ermäßigten Umsatzsteuersatz (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1607, 'SKR03', '1: Finanz- und Privatkonten',                                '1607', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Vorsteuerabzug (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1609, 'SKR03', '1: Finanz- und Privatkonten',                                '1609', '1600', 'Gegenkonto 1605-1607 bei Aufteilung der Verbindlichkeiten nach Steuersätzen (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1610, 'SKR03', '1: Finanz- und Privatkonten',                                '1610', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1611, 'SKR03', '1: Finanz- und Privatkonten',                                '1611', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1612, 'SKR03', '1: Finanz- und Privatkonten',                                '1612', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1613, 'SKR03', '1: Finanz- und Privatkonten',                                '1613', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1614, 'SKR03', '1: Finanz- und Privatkonten',                                '1614', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1615, 'SKR03', '1: Finanz- und Privatkonten',                                '1615', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1616, 'SKR03', '1: Finanz- und Privatkonten',                                '1616', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1617, 'SKR03', '1: Finanz- und Privatkonten',                                '1617', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1618, 'SKR03', '1: Finanz- und Privatkonten',                                '1618', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1619, 'SKR03', '1: Finanz- und Privatkonten',                                '1619', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1620, 'SKR03', '1: Finanz- und Privatkonten',                                '1620', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1621, 'SKR03', '1: Finanz- und Privatkonten',                                '1621', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1622, 'SKR03', '1: Finanz- und Privatkonten',                                '1622', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1623, 'SKR03', '1: Finanz- und Privatkonten',                                '1623', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1624, 'SKR03', '1: Finanz- und Privatkonten',                                '1624', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen für Investitionen für § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1625, 'SKR03', '1: Finanz- und Privatkonten',                                '1625', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1626, 'SKR03', '1: Finanz- und Privatkonten',                                '1626', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1628, 'SKR03', '1: Finanz- und Privatkonten',                                '1628', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen ohne Kontokorrent - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1630, 'SKR03', '1: Finanz- und Privatkonten',                                '1630', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1631, 'SKR03', '1: Finanz- und Privatkonten',                                '1631', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber verbundenen Unternehmen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1635, 'SKR03', '1: Finanz- und Privatkonten',                                '1635', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber verbundenen Unternehmen - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1638, 'SKR03', '1: Finanz- und Privatkonten',                                '1638', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber verbundenen Unternehmen - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1640, 'SKR03', '1: Finanz- und Privatkonten',                                '1640', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber Unternehmen, mit denen ein Beteiligungsverhältnis besteht');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1641, 'SKR03', '1: Finanz- und Privatkonten',                                '1641', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1645, 'SKR03', '1: Finanz- und Privatkonten',                                '1645', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1648, 'SKR03', '1: Finanz- und Privatkonten',                                '1648', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber Unternehmen, mit denen ein Beteiligungsverhältnis besteht - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1650, 'SKR03', '1: Finanz- und Privatkonten',                                '1650', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber Gesellschaftern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1651, 'SKR03', '1: Finanz- und Privatkonten',                                '1651', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber Gesellschaftern - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1655, 'SKR03', '1: Finanz- und Privatkonten',                                '1655', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber Gesellschaftern - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1658, 'SKR03', '1: Finanz- und Privatkonten',                                '1658', '1600', 'Verbindlichkeiten aus Lieferungen und Leistungen gegenüber Gesellschaftern - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1659, 'SKR03', '1: Finanz- und Privatkonten',                                '1659', '1600', 'Gegenkonto 1625-1658 bei Aufteilung Kreditorenkonto');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1660, 'SKR03', '1: Finanz- und Privatkonten',                                '1660',    '0', 'Wechselverbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1661, 'SKR03', '1: Finanz- und Privatkonten',                                '1661', '1660', 'Wechselverbindlichkeiten - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1662, 'SKR03', '1: Finanz- und Privatkonten',                                '1662', '1660', 'Wechselverbindlichkeiten - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1663, 'SKR03', '1: Finanz- und Privatkonten',                                '1663', '1660', 'Wechselverbindlichkeiten - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1665, 'SKR03', '1: Finanz- und Privatkonten',                                '1665', '1660', 'Verbindlichkeiten gegenüber GmbH-Gesellschaftern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1666, 'SKR03', '1: Finanz- und Privatkonten',                                '1666', '1660', 'Verbindlichkeiten gegenüber GmbH-Gesellschaftern - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1667, 'SKR03', '1: Finanz- und Privatkonten',                                '1667', '1660', 'Verbindlichkeiten gegenüber GmbH-Gesellschaftern - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1668, 'SKR03', '1: Finanz- und Privatkonten',                                '1668', '1660', 'Verbindlichkeiten gegenüber GmbH-Gesellschaftern - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1670, 'SKR03', '1: Finanz- und Privatkonten',                                '1670', '1660', 'Verbindlichkeiten gegenüber persönlich haftenden Gesellschaftern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1671, 'SKR03', '1: Finanz- und Privatkonten',                                '1671', '1660', 'Verbindlichkeiten gegenüber persönlich haftenden Gesellschaftern - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1672, 'SKR03', '1: Finanz- und Privatkonten',                                '1672', '1660', 'Verbindlichkeiten gegenüber persönlich haftenden Gesellschaftern - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1673, 'SKR03', '1: Finanz- und Privatkonten',                                '1673', '1660', 'Verbindlichkeiten gegenüber persönlich haftenden Gesellschaftern - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1675, 'SKR03', '1: Finanz- und Privatkonten',                                '1675', '1660', 'Verbindlichkeiten gegenüber Kommanditisten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1676, 'SKR03', '1: Finanz- und Privatkonten',                                '1676', '1660', 'Verbindlichkeiten gegenüber Kommanditisten - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1677, 'SKR03', '1: Finanz- und Privatkonten',                                '1677', '1660', 'Verbindlichkeiten gegenüber Kommanditisten - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1678, 'SKR03', '1: Finanz- und Privatkonten',                                '1678', '1660', 'Verbindlichkeiten gegenüber Kommanditisten - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1691, 'SKR03', '1: Finanz- und Privatkonten',                                '1691', '1660', 'Verbindlichkeiten gegenüber Arbeitsgemeinschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1692, 'SKR03', '1: Finanz- und Privatkonten',                                '1692', '1660', 'Neutralisierung aufwandswirksamer Sachverhalte für § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1693, 'SKR03', '1: Finanz- und Privatkonten',                                '1693', '1660', 'Ergebnisneutrale Sachverhalte für § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1695, 'SKR03', '1: Finanz- und Privatkonten',                                '1695', '1660', 'Verbindlichkeiten gegenüber stillen Gesellschaftern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1696, 'SKR03', '1: Finanz- und Privatkonten',                                '1696', '1660', 'Verbindlichkeiten gegenüber stillen Gesellschaftern - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1697, 'SKR03', '1: Finanz- und Privatkonten',                                '1697', '1660', 'Verbindlichkeiten gegenüber stillen Gesellschaftern - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1698, 'SKR03', '1: Finanz- und Privatkonten',                                '1698', '1660', 'Verbindlichkeiten gegenüber stillen Gesellschaftern - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1700, 'SKR03', '1: Finanz- und Privatkonten',                                '1700',    '0', 'Sonstige Verbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1701, 'SKR03', '1: Finanz- und Privatkonten',                                '1701', '1700', 'Sonstige Verbindlichkeiten - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1702, 'SKR03', '1: Finanz- und Privatkonten',                                '1702', '1700', 'Sonstige Verbindlichkeiten - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1703, 'SKR03', '1: Finanz- und Privatkonten',                                '1703', '1700', 'Sonstige Verbindlichkeiten - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1704, 'SKR03', '1: Finanz- und Privatkonten',                                '1704', '1700', 'Sonstige Verbindlichkeiten nach § 11 Abs. 2 Satz 2 EStG für § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1705, 'SKR03', '1: Finanz- und Privatkonten',                                '1705', '1700', 'Darlehen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1706, 'SKR03', '1: Finanz- und Privatkonten',                                '1706', '1700', 'Darlehen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1707, 'SKR03', '1: Finanz- und Privatkonten',                                '1707', '1700', 'Darlehen - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1708, 'SKR03', '1: Finanz- und Privatkonten',                                '1708', '1700', 'Darlehen - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1709, 'SKR03', '1: Finanz- und Privatkonten',                                '1709', '1700', 'Gewinnverfügungskonto stille Gesellschafter - sonstige Verbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1710, 'SKR03', '1: Finanz- und Privatkonten',                                '1710',    '0', 'Erhaltene Anzahlungen auf Bestellungen (Verbindlichkeiten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1711, 'SKR03', '1: Finanz- und Privatkonten',                                '1711', '1710', 'Erhaltene, versteuerte Anzahlungen 7 % USt (Verbindlichkeiten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1712, 'SKR03', '1: Finanz- und Privatkonten',                                '1712', '1710', 'Erhaltene, versteuerte Anzahlungen 5 % USt (Verbindlichkeiten)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1713, 'SKR03', '1: Finanz- und Privatkonten',                                '1713', '1710', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1714, 'SKR03', '1: Finanz- und Privatkonten',                                '1714', '1710', 'Erhaltene, versteuerte Anzahlungen 0 % USt (Verbindlichkeiten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1715, 'SKR03', '1: Finanz- und Privatkonten',                                '1715', '1710', 'Erhaltene Anzahlungen - Nachsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1716, 'SKR03', '1: Finanz- und Privatkonten',                                '1716', '1710', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1717, 'SKR03', '1: Finanz- und Privatkonten',                                '1717', '1710', 'Erhaltene, versteuerte Anzahlungen 16 % USt (Verbindlichkeiten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1718, 'SKR03', '1: Finanz- und Privatkonten',                                '1718', '1710', 'Erhaltene, versteuerte Anzahlungen 19 % USt (Verbindlichkeiten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1719, 'SKR03', '1: Finanz- und Privatkonten',                                '1719', '1710', 'Erhaltene Anzahlungen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1720, 'SKR03', '1: Finanz- und Privatkonten',                                '1720', '1710', 'Erhaltene Anzahlungen - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1721, 'SKR03', '1: Finanz- und Privatkonten',                                '1721', '1710', 'Erhaltene Anzahlungen - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1722, 'SKR03', '1: Finanz- und Privatkonten',                                '1722', '1710', 'Erhaltene Anzahlungen auf Bestellungen (von Vorräten offen abgesetzt)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1725, 'SKR03', '1: Finanz- und Privatkonten',                                '1725', '1710', 'Umsatzsteuer in Folgeperiode fällig (§§ 13 Abs. 1 Nr. 6 und 13b Abs. 2 UStG)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1728, 'SKR03', '1: Finanz- und Privatkonten',                                '1728', '1710', 'Umsatzsteuer aus im anderen EU-Land steuerpflichtigen elektronischen Dienstleistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1729, 'SKR03', '1: Finanz- und Privatkonten',                                '1729', '1710', 'Steuerzahlungen aus im anderen EU-Land steuerpflichtigen Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1730, 'SKR03', '1: Finanz- und Privatkonten',                                '1730', '1710', 'Kreditkartenabrechnung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1731, 'SKR03', '1: Finanz- und Privatkonten',                                '1731', '1710', 'Agenturwarenabrechnung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1732, 'SKR03', '1: Finanz- und Privatkonten',                                '1732', '1710', 'Erhaltene Kautionen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1733, 'SKR03', '1: Finanz- und Privatkonten',                                '1733', '1710', 'Erhaltene Kautionen - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1734, 'SKR03', '1: Finanz- und Privatkonten',                                '1734', '1710', 'Erhaltene Kautionen - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1735, 'SKR03', '1: Finanz- und Privatkonten',                                '1735', '1710', 'Erhaltene Kautionen - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1736, 'SKR03', '1: Finanz- und Privatkonten',                                '1736', '1710', 'Verbindlichkeiten aus Steuern und Abgaben');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1737, 'SKR03', '1: Finanz- und Privatkonten',                                '1737', '1710', 'Verbindlichkeiten aus Steuern und Abgaben - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1738, 'SKR03', '1: Finanz- und Privatkonten',                                '1738', '1710', 'Verbindlichkeiten aus Steuern und Abgaben - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1739, 'SKR03', '1: Finanz- und Privatkonten',                                '1739', '1710', 'Verbindlichkeiten aus Steuern und Abgaben - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1740, 'SKR03', '1: Finanz- und Privatkonten',                                '1740', '1710', 'Verbindlichkeiten aus Lohn und Gehalt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1741, 'SKR03', '1: Finanz- und Privatkonten',                                '1741', '1710', 'Verbindlichkeiten aus Lohn- und Kirchensteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1742, 'SKR03', '1: Finanz- und Privatkonten',                                '1742', '1710', 'Verbindlichkeiten im Rahmen der sozialen Sicherheit');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1743, 'SKR03', '1: Finanz- und Privatkonten',                                '1743', '1710', 'Verbindlichkeiten im Rahmen der sozialen Sicherheit - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1744, 'SKR03', '1: Finanz- und Privatkonten',                                '1744', '1710', 'Verbindlichkeiten im Rahmen der sozialen Sicherheit - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1745, 'SKR03', '1: Finanz- und Privatkonten',                                '1745', '1710', 'Verbindlichkeiten im Rahmen der sozialen Sicherheit - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1746, 'SKR03', '1: Finanz- und Privatkonten',                                '1746', '1710', 'Verbindlichkeiten aus Einbehaltungen (KapESt und SolZ, KiSt auf KapESt) für offene Ausschüttungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1747, 'SKR03', '1: Finanz- und Privatkonten',                                '1747', '1710', 'Verbindlichkeiten für Verbrauchsteuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1748, 'SKR03', '1: Finanz- und Privatkonten',                                '1748', '1710', 'Verbindlichkeiten für Einbehaltungen von Arbeitnehmern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1749, 'SKR03', '1: Finanz- und Privatkonten',                                '1749', '1710', 'Verbindlichkeiten an das Finanzamt aus abzuführendem Bauabzugsbetrag');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1750, 'SKR03', '1: Finanz- und Privatkonten',                                '1750', '1710', 'Verbindlichkeiten aus Vermögensbildung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1751, 'SKR03', '1: Finanz- und Privatkonten',                                '1751', '1710', 'Verbindlichkeiten aus Vermögensbildung - Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1752, 'SKR03', '1: Finanz- und Privatkonten',                                '1752', '1710', 'Verbindlichkeiten aus Vermögensbildung - Restlaufzeit 1 bis 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1753, 'SKR03', '1: Finanz- und Privatkonten',                                '1753', '1710', 'Verbindlichkeiten aus Vermögensbildung - Restlaufzeit größer 5 Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1754, 'SKR03', '1: Finanz- und Privatkonten',                                '1754', '1710', 'Steuerzahlungen an andere Länder');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1755, 'SKR03', '1: Finanz- und Privatkonten',                                '1755',    '0', 'Lohn- und Gehaltsverrechnung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1756, 'SKR03', '1: Finanz- und Privatkonten',                                '1756', '1755', 'Lohn- und Gehaltsverrechnung nach § 11 Abs. 2 Satz 2 EStG für § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1757, 'SKR03', '1: Finanz- und Privatkonten',                                '1757', '1755', 'Verbindlichkeiten gegenüber Gesellschaft/Gesamthand');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1758, 'SKR03', '1: Finanz- und Privatkonten',                                '1758', '1755', 'Sonstige Verbindlichkeiten aus genossenschaftlicher Rückvergütung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1759, 'SKR03', '1: Finanz- und Privatkonten',                                '1759', '1755', 'Voraussichtliche Beitragsschuld gegenüber den Sozialversicherungsträgern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1760, 'SKR03', '1: Finanz- und Privatkonten',                                '1760', '1755', 'Umsatzsteuer nicht fällig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1761, 'SKR03', '1: Finanz- und Privatkonten',                                '1761', '1755', 'Umsatzsteuer nicht fällig 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1762, 'SKR03', '1: Finanz- und Privatkonten',                                '1762', '1755', 'Umsatzsteuer nicht fällig aus im Inland steuerpflichtigen EU-Lieferungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1763, 'SKR03', '1: Finanz- und Privatkonten',                                '1763', '1755', 'Umsatzsteuer nicht fällig 5 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1764, 'SKR03', '1: Finanz- und Privatkonten',                                '1764', '1755', 'Umsatzsteuer nicht fällig aus im Inland steuerpflichtigen EU-Lieferungen 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1765, 'SKR03', '1: Finanz- und Privatkonten',                                '1765', '1755', 'Umsatzsteuer nicht fällig 16 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1766, 'SKR03', '1: Finanz- und Privatkonten',                                '1766', '1755', 'Umsatzsteuer nicht fällig 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1767, 'SKR03', '1: Finanz- und Privatkonten',                                '1767', '1755', 'Umsatzsteuer aus im anderen EU-Land steuerpflichtigen Lieferungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1768, 'SKR03', '1: Finanz- und Privatkonten',                                '1768', '1755', 'Umsatzsteuer aus im anderen EU-Land steuerpflichtigen sonstigen Leistungen/Werklieferungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1769, 'SKR03', '1: Finanz- und Privatkonten',                                '1769', '1755', 'Umsatzsteuer aus der Auslagerung von Gegenständen aus einem Umsatzsteuerlager');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1770, 'SKR03', '1: Finanz- und Privatkonten',                                '1770', '1755', 'Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1771, 'SKR03', '1: Finanz- und Privatkonten',                                '1771', '1755', 'Umsatzsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1772, 'SKR03', '1: Finanz- und Privatkonten',                                '1772', '1755', 'Umsatzsteuer aus innergemeinschaftlichem Erwerb');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1773, 'SKR03', '1: Finanz- und Privatkonten',                                '1773', '1755', 'Umsatzsteuer 5 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1774, 'SKR03', '1: Finanz- und Privatkonten',                                '1774', '1755', 'Umsatzsteuer aus innergemeinschaftlichem Erwerb 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1775, 'SKR03', '1: Finanz- und Privatkonten',                                '1775', '1755', 'Umsatzsteuer 16 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1776, 'SKR03', '1: Finanz- und Privatkonten',                                '1776', '1755', 'Umsatzsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1777, 'SKR03', '1: Finanz- und Privatkonten',                                '1777', '1755', 'Umsatzsteuer aus im Inland steuerpflichtigen EU-Lieferungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1778, 'SKR03', '1: Finanz- und Privatkonten',                                '1778', '1755', 'Umsatzsteuer aus im Inland steuerpflichtigen EU-Lieferungen 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1779, 'SKR03', '1: Finanz- und Privatkonten',                                '1779', '1755', 'Umsatzsteuer aus innergemeinschaftlichem Erwerb ohne Vorsteuerabzug');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1780, 'SKR03', '1: Finanz- und Privatkonten',                                '1780', '1755', 'Umsatzsteuer-Vorauszahlungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1781, 'SKR03', '1: Finanz- und Privatkonten',                                '1781', '1755', 'Umsatzsteuer-Vorauszahlungen 1/11');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1782, 'SKR03', '1: Finanz- und Privatkonten',                                '1782', '1755', 'Nachsteuer, UStVA Kz. 65');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1783, 'SKR03', '1: Finanz- und Privatkonten',                                '1783', '1755', 'In Rechnung unrichtig oder unberechtigt ausgewiesene Steuerbeträge, UStVA Kz. 69');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1784, 'SKR03', '1: Finanz- und Privatkonten',                                '1784', '1755', 'Umsatzsteuer aus innergemeinschaftlichem Erwerb von Neufahrzeugen von Lieferanten ohne Umsatzsteuer-Identifikationsnummer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1785, 'SKR03', '1: Finanz- und Privatkonten',                                '1785', '1755', 'Umsatzsteuer nach § 13b UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1786, 'SKR03', '1: Finanz- und Privatkonten',                                '1786', '1755', 'Umsatzsteuer aus innergemeinschaftlichem Erwerb 16 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1787, 'SKR03', '1: Finanz- und Privatkonten',                                '1787', '1755', 'Umsatzsteuer nach § 13b UStG 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1788, 'SKR03', '1: Finanz- und Privatkonten',                                '1788', '1755', 'Einfuhrumsatzsteuer aufgeschoben bis ...');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1789, 'SKR03', '1: Finanz- und Privatkonten',                                '1789', '1755', 'Umsatzsteuer laufendes Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1790, 'SKR03', '1: Finanz- und Privatkonten',                                '1790', '1755', 'Umsatzsteuer Vorjahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1791, 'SKR03', '1: Finanz- und Privatkonten',                                '1791', '1755', 'Umsatzsteuer frühere Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1792, 'SKR03', '1: Finanz- und Privatkonten',                                '1792', '1755', 'Sonstige Verrechnungskonten (Interimskonten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1793, 'SKR03', '1: Finanz- und Privatkonten',                                '1793', '1755', 'Verrechnungskonto geleistete Anzahlungen bei Buchung über Kreditorenkonto');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1794, 'SKR03', '1: Finanz- und Privatkonten',                                '1794', '1755', 'Umsatzsteuer aus Erwerb als letzter Abnehmer innerhalb eines Dreiecksgeschäfts');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1795, 'SKR03', '1: Finanz- und Privatkonten',                                '1795', '1755', 'Verbindlichkeiten im Rahmen der sozialen Sicherheit für § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1796, 'SKR03', '1: Finanz- und Privatkonten',                                '1796', '1755', 'Ausgegebene Geschenkgutscheine');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1797, 'SKR03', '1: Finanz- und Privatkonten',                                '1797', '1755', 'Verbindlichkeiten aus Umsatzsteuer-Vorauszahlungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1798, 'SKR03', '1: Finanz- und Privatkonten',                                '1798', '1755', 'Umsatzsteuer aus im Inland steuerpflichtigen EU-Lieferungen, nur OSS');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1799, 'SKR03', '1: Finanz- und Privatkonten',                                '1799', '1755', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1800, 'SKR03', '1: Finanz- und Privatkonten',                                '1800',    '0', 'Privatentnahmen allgemein');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1801, 'SKR03', '1: Finanz- und Privatkonten',                                '1801',    '0', 'Privatentnahmen allgemein (nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1810, 'SKR03', '1: Finanz- und Privatkonten',                                '1810',    '0', 'Privatsteuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1811, 'SKR03', '1: Finanz- und Privatkonten',                                '1811',    '0', 'Privatsteuern (nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1820, 'SKR03', '1: Finanz- und Privatkonten',                                '1820',    '0', 'Sonderausgaben beschränkt abzugsfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1821, 'SKR03', '1: Finanz- und Privatkonten',                                '1821',    '0', 'Sonderausgaben beschränkt abzugsfähig (nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1830, 'SKR03', '1: Finanz- und Privatkonten',                                '1830',    '0', 'Sonderausgaben unbeschränkt abzugsfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1831, 'SKR03', '1: Finanz- und Privatkonten',                                '1831',    '0', 'Sonderausgaben unbeschränkt abzugsfähig (nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1840, 'SKR03', '1: Finanz- und Privatkonten',                                '1840',    '0', 'Zuwendungen, Spenden');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1841, 'SKR03', '1: Finanz- und Privatkonten',                                '1841',    '0', 'Zuwendungen, Spenden (nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1850, 'SKR03', '1: Finanz- und Privatkonten',                                '1850',    '0', 'Außergewöhnliche Belastungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1851, 'SKR03', '1: Finanz- und Privatkonten',                                '1851',    '0', 'Außergewöhnliche Belastungen (nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1860, 'SKR03', '1: Finanz- und Privatkonten',                                '1860',    '0', 'Grundstücksaufwand');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1861, 'SKR03', '1: Finanz- und Privatkonten',                                '1861',    '0', 'Grundstücksaufwand (nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1869, 'SKR03', '1: Finanz- und Privatkonten',                                '1869',    '0', 'Grundstücksaufwand (Umsatzsteuerschlüssel möglich, nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1870, 'SKR03', '1: Finanz- und Privatkonten',                                '1870',    '0', 'Grundstücksertrag');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1871, 'SKR03', '1: Finanz- und Privatkonten',                                '1871',    '0', 'Grundstücksertrag (nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1879, 'SKR03', '1: Finanz- und Privatkonten',                                '1879',    '0', 'Grundstücksertrag (Umsatzsteuerschlüssel möglich, nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1880, 'SKR03', '1: Finanz- und Privatkonten',                                '1880',    '0', 'Unentgeltliche Wertabgaben');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1881, 'SKR03', '1: Finanz- und Privatkonten',                                '1881',    '0', 'Unentgeltliche Wertabgaben (nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1890, 'SKR03', '1: Finanz- und Privatkonten',                                '1890',    '0', 'Privateinlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1891, 'SKR03', '1: Finanz- und Privatkonten',                                '1891',    '0', 'Privateinlagen (nur Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1900, 'SKR03', '1: Finanz- und Privatkonten',                                '1900',    '0', 'Privatentnahmen allgemein (TH), FK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1901, 'SKR03', '1: Finanz- und Privatkonten',                                '1901',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1902, 'SKR03', '1: Finanz- und Privatkonten',                                '1902',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1903, 'SKR03', '1: Finanz- und Privatkonten',                                '1903',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1904, 'SKR03', '1: Finanz- und Privatkonten',                                '1904',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1905, 'SKR03', '1: Finanz- und Privatkonten',                                '1905',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1906, 'SKR03', '1: Finanz- und Privatkonten',                                '1906',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1907, 'SKR03', '1: Finanz- und Privatkonten',                                '1907',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1908, 'SKR03', '1: Finanz- und Privatkonten',                                '1908',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1909, 'SKR03', '1: Finanz- und Privatkonten',                                '1909',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1910, 'SKR03', '1: Finanz- und Privatkonten',                                '1910',    '0', 'Privatsteuern (TH), FK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1911, 'SKR03', '1: Finanz- und Privatkonten',                                '1911',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1912, 'SKR03', '1: Finanz- und Privatkonten',                                '1912',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1913, 'SKR03', '1: Finanz- und Privatkonten',                                '1913',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1914, 'SKR03', '1: Finanz- und Privatkonten',                                '1914',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1915, 'SKR03', '1: Finanz- und Privatkonten',                                '1915',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1916, 'SKR03', '1: Finanz- und Privatkonten',                                '1916',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1917, 'SKR03', '1: Finanz- und Privatkonten',                                '1917',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1918, 'SKR03', '1: Finanz- und Privatkonten',                                '1918',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1919, 'SKR03', '1: Finanz- und Privatkonten',                                '1919',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1920, 'SKR03', '1: Finanz- und Privatkonten',                                '1920',    '0', 'Sonderausgaben beschränkt abzugsfähig (TH), FK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1921, 'SKR03', '1: Finanz- und Privatkonten',                                '1921',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1922, 'SKR03', '1: Finanz- und Privatkonten',                                '1922',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1923, 'SKR03', '1: Finanz- und Privatkonten',                                '1923',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1924, 'SKR03', '1: Finanz- und Privatkonten',                                '1924',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1925, 'SKR03', '1: Finanz- und Privatkonten',                                '1925',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1926, 'SKR03', '1: Finanz- und Privatkonten',                                '1926',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1927, 'SKR03', '1: Finanz- und Privatkonten',                                '1927',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1928, 'SKR03', '1: Finanz- und Privatkonten',                                '1928',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1929, 'SKR03', '1: Finanz- und Privatkonten',                                '1929',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1930, 'SKR03', '1: Finanz- und Privatkonten',                                '1930',    '0', 'Sonderausgaben unbeschränkt abzugsfähig (TH), FK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1931, 'SKR03', '1: Finanz- und Privatkonten',                                '1931',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1932, 'SKR03', '1: Finanz- und Privatkonten',                                '1932',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1933, 'SKR03', '1: Finanz- und Privatkonten',                                '1933',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1934, 'SKR03', '1: Finanz- und Privatkonten',                                '1934',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1935, 'SKR03', '1: Finanz- und Privatkonten',                                '1935',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1936, 'SKR03', '1: Finanz- und Privatkonten',                                '1936',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1937, 'SKR03', '1: Finanz- und Privatkonten',                                '1937',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1938, 'SKR03', '1: Finanz- und Privatkonten',                                '1938',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1939, 'SKR03', '1: Finanz- und Privatkonten',                                '1939',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1940, 'SKR03', '1: Finanz- und Privatkonten',                                '1940',    '0', 'Zuwendungen, Spenden (TH), FK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1941, 'SKR03', '1: Finanz- und Privatkonten',                                '1941',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1942, 'SKR03', '1: Finanz- und Privatkonten',                                '1942',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1943, 'SKR03', '1: Finanz- und Privatkonten',                                '1943',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1944, 'SKR03', '1: Finanz- und Privatkonten',                                '1944',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1945, 'SKR03', '1: Finanz- und Privatkonten',                                '1945',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1946, 'SKR03', '1: Finanz- und Privatkonten',                                '1946',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1947, 'SKR03', '1: Finanz- und Privatkonten',                                '1947',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1948, 'SKR03', '1: Finanz- und Privatkonten',                                '1948',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1949, 'SKR03', '1: Finanz- und Privatkonten',                                '1949',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1950, 'SKR03', '1: Finanz- und Privatkonten',                                '1950',    '0', 'Außergewöhnliche Belastungen (TH), FK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1951, 'SKR03', '1: Finanz- und Privatkonten',                                '1951',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1952, 'SKR03', '1: Finanz- und Privatkonten',                                '1952',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1953, 'SKR03', '1: Finanz- und Privatkonten',                                '1953',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1954, 'SKR03', '1: Finanz- und Privatkonten',                                '1954',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1955, 'SKR03', '1: Finanz- und Privatkonten',                                '1955',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1956, 'SKR03', '1: Finanz- und Privatkonten',                                '1956',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1957, 'SKR03', '1: Finanz- und Privatkonten',                                '1957',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1958, 'SKR03', '1: Finanz- und Privatkonten',                                '1958',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1959, 'SKR03', '1: Finanz- und Privatkonten',                                '1959',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1960, 'SKR03', '1: Finanz- und Privatkonten',                                '1960',    '0', 'Grundstücksaufwand (TH), FK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1961, 'SKR03', '1: Finanz- und Privatkonten',                                '1961',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1962, 'SKR03', '1: Finanz- und Privatkonten',                                '1962',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1963, 'SKR03', '1: Finanz- und Privatkonten',                                '1963',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1964, 'SKR03', '1: Finanz- und Privatkonten',                                '1964',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1965, 'SKR03', '1: Finanz- und Privatkonten',                                '1965',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1966, 'SKR03', '1: Finanz- und Privatkonten',                                '1966',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1967, 'SKR03', '1: Finanz- und Privatkonten',                                '1967',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1968, 'SKR03', '1: Finanz- und Privatkonten',                                '1968',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1969, 'SKR03', '1: Finanz- und Privatkonten',                                '1969',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1970, 'SKR03', '1: Finanz- und Privatkonten',                                '1970',    '0', 'Grundstücksertrag (TH), FK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1971, 'SKR03', '1: Finanz- und Privatkonten',                                '1971',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1972, 'SKR03', '1: Finanz- und Privatkonten',                                '1972',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1973, 'SKR03', '1: Finanz- und Privatkonten',                                '1973',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1974, 'SKR03', '1: Finanz- und Privatkonten',                                '1974',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1975, 'SKR03', '1: Finanz- und Privatkonten',                                '1975',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1976, 'SKR03', '1: Finanz- und Privatkonten',                                '1976',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1977, 'SKR03', '1: Finanz- und Privatkonten',                                '1977',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1978, 'SKR03', '1: Finanz- und Privatkonten',                                '1978',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1979, 'SKR03', '1: Finanz- und Privatkonten',                                '1979',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1980, 'SKR03', '1: Finanz- und Privatkonten',                                '1980',    '0', 'Unentgeltliche Wertabgaben (TH), FK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1981, 'SKR03', '1: Finanz- und Privatkonten',                                '1981',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1982, 'SKR03', '1: Finanz- und Privatkonten',                                '1982',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1983, 'SKR03', '1: Finanz- und Privatkonten',                                '1983',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1984, 'SKR03', '1: Finanz- und Privatkonten',                                '1984',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1985, 'SKR03', '1: Finanz- und Privatkonten',                                '1985',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1986, 'SKR03', '1: Finanz- und Privatkonten',                                '1986',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1987, 'SKR03', '1: Finanz- und Privatkonten',                                '1987',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1988, 'SKR03', '1: Finanz- und Privatkonten',                                '1988',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1989, 'SKR03', '1: Finanz- und Privatkonten',                                '1989',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1990, 'SKR03', '1: Finanz- und Privatkonten',                                '1990',    '0', 'Privateinlagen (TH), FK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1991, 'SKR03', '1: Finanz- und Privatkonten',                                '1991',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1992, 'SKR03', '1: Finanz- und Privatkonten',                                '1992',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1993, 'SKR03', '1: Finanz- und Privatkonten',                                '1993',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1994, 'SKR03', '1: Finanz- und Privatkonten',                                '1994',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1995, 'SKR03', '1: Finanz- und Privatkonten',                                '1995',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1996, 'SKR03', '1: Finanz- und Privatkonten',                                '1996',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1997, 'SKR03', '1: Finanz- und Privatkonten',                                '1997',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1998, 'SKR03', '1: Finanz- und Privatkonten',                                '1998',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 1999, 'SKR03', '1: Finanz- und Privatkonten',                                '1999',    '0', '');
---- 2: Abgrenzungskonten
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2000, 'SKR03', '2: Abgrenzungskonten',                                       '2000',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2001, 'SKR03', '2: Abgrenzungskonten',                                       '2001',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2004, 'SKR03', '2: Abgrenzungskonten',                                       '2004',    '0', 'Verluste durch Verschmelzung und Umwandlung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2006, 'SKR03', '2: Abgrenzungskonten',                                       '2006',    '0', 'Verluste durch außergewöhnliche Schadensfälle (nur Bilanzierer)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2007, 'SKR03', '2: Abgrenzungskonten',                                       '2007',    '0', 'Aufwendungen für Restrukturierungs- und Sanierungsmaßnahmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2008, 'SKR03', '2: Abgrenzungskonten',                                       '2008',    '0', 'Verluste aus der Veräußerung oder der Aufgabe von Geschäftsaktivitäten nach Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2010, 'SKR03', '2: Abgrenzungskonten',                                       '2010',    '0', 'Betriebsfremde Aufwendungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2020, 'SKR03', '2: Abgrenzungskonten',                                       '2020',    '0', 'Periodenfremde Aufwendungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2090, 'SKR03', '2: Abgrenzungskonten',                                       '2090',    '0', 'Aufwendungen aus der Anwendung von Übergangsvorschriften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2091, 'SKR03', '2: Abgrenzungskonten',                                       '2091',    '0', 'Aufwendungen aus der Anwendung von Übergangsvorschriften (Pensionsrückstellungen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2094, 'SKR03', '2: Abgrenzungskonten',                                       '2094',    '0', 'Aufwendungen aus der Anwendung von Übergangsvorschriften (Latente Steuern)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2100, 'SKR03', '2: Abgrenzungskonten',                                       '2100',    '0', 'Zinsen und ähnliche Aufwendungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2102, 'SKR03', '2: Abgrenzungskonten',                                       '2102', '2100', 'Steuerlich nicht abzugsfähige andere Nebenleistungen zu Steuern § 4 Abs. 5b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2103, 'SKR03', '2: Abgrenzungskonten',                                       '2103', '2100', 'Steuerlich abzugsfähige andere Nebenleistungen zu Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2104, 'SKR03', '2: Abgrenzungskonten',                                       '2104', '2100', 'Steuerlich nicht abzugsfähige andere Nebenleistungen zu Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2105, 'SKR03', '2: Abgrenzungskonten',                                       '2105', '2100', 'Zinsaufwendungen § 233a AO nicht abzugsfähig');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2106, 'SKR03', '2: Abgrenzungskonten',                                       '2106', '2100', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2107, 'SKR03', '2: Abgrenzungskonten',                                       '2107', '2100', 'Zinsaufwendungen § 233a AO abzugsfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2108, 'SKR03', '2: Abgrenzungskonten',                                       '2108', '2100', 'Zinsaufwendungen §§ 234 bis 237 AO nicht abzugsfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2109, 'SKR03', '2: Abgrenzungskonten',                                       '2109', '2100', 'Zinsaufwendungen an verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2110, 'SKR03', '2: Abgrenzungskonten',                                       '2110', '2100', 'Zinsaufwendungen für kurzfristige Verbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2111, 'SKR03', '2: Abgrenzungskonten',                                       '2111', '2100', 'Zinsaufwendungen §§ 234 bis 237 AO abzugsfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2113, 'SKR03', '2: Abgrenzungskonten',                                       '2113', '2100', 'Nicht abzugsfähige Schuldzinsen nach § 4 Abs. 4a EStG (Hinzurechnungsbetrag)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2114, 'SKR03', '2: Abgrenzungskonten',                                       '2114', '2100', 'Zinsen für Gesellschafterdarlehen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2115, 'SKR03', '2: Abgrenzungskonten',                                       '2115', '2100', 'Zinsen und ähnliche Aufwendungen §§ 3 Nr. 40 und 3c EStG bzw. § 8b Abs. 1 und 4 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2116, 'SKR03', '2: Abgrenzungskonten',                                       '2116', '2100', 'Zinsen und ähnliche Aufwendungen an verbundene Unternehmen §§ 3 Nr. 40 und 3c EStG bzw. § 8b Abs. 1 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2117, 'SKR03', '2: Abgrenzungskonten',                                       '2117', '2100', 'Zinsen an Gesellschafter mit einer Beteiligung von mehr als 25 % bzw. diesen nahe stehende Personen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2118, 'SKR03', '2: Abgrenzungskonten',                                       '2118', '2100', 'Zinsen auf Kontokorrentkonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2119, 'SKR03', '2: Abgrenzungskonten',                                       '2119', '2100', 'Zinsaufwendungen für kurzfristige Verbindlichkeiten an verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2120, 'SKR03', '2: Abgrenzungskonten',                                       '2120', '2100', 'Zinsaufwendungen für langfristige Verbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2123, 'SKR03', '2: Abgrenzungskonten',                                       '2123', '2100', 'Abschreibungen auf ein Agio oder Disagio/Damnum zur Finanzierung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2124, 'SKR03', '2: Abgrenzungskonten',                                       '2124', '2100', 'Abschreibungen auf ein Agio oder Disagio/Damnum zur Finanzierung des Anlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2125, 'SKR03', '2: Abgrenzungskonten',                                       '2125', '2100', 'Zinsaufwendungen für Gebäude, die zum Betriebsvermögen gehören');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2126, 'SKR03', '2: Abgrenzungskonten',                                       '2126', '2100', 'Zinsen zur Finanzierung des Anlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2127, 'SKR03', '2: Abgrenzungskonten',                                       '2127', '2100', 'Renten und dauernde Lasten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2128, 'SKR03', '2: Abgrenzungskonten',                                       '2128', '2100', 'Zinsaufwendungen für Kapitalüberlassung durch Mitunternehmer § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2129, 'SKR03', '2: Abgrenzungskonten',                                       '2129', '2100', 'Zinsaufwendungen für langfristige Verbindlichkeiten an verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2130, 'SKR03', '2: Abgrenzungskonten',                                       '2130', '2100', 'Diskontaufwendungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2139, 'SKR03', '2: Abgrenzungskonten',                                       '2139', '2100', 'Diskontaufwendungen an verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2140, 'SKR03', '2: Abgrenzungskonten',                                       '2140', '2100', 'Zinsähnliche Aufwendungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2141, 'SKR03', '2: Abgrenzungskonten',                                       '2141', '2100', 'Kreditprovisionen und Verwaltungskostenbeiträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2142, 'SKR03', '2: Abgrenzungskonten',                                       '2142', '2100', 'Zinsanteil der Zuführungen zu Pensionsrückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2143, 'SKR03', '2: Abgrenzungskonten',                                       '2143', '2100', 'Zinsaufwendungen aus der Abzinsung von Verbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2144, 'SKR03', '2: Abgrenzungskonten',                                       '2144', '2100', 'Zinsaufwendungen aus der Abzinsung von Rückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2145, 'SKR03', '2: Abgrenzungskonten',                                       '2145', '2100', 'Zinsaufwendungen aus der Abzinsung von Pensionsrückstellungen und ähnlichen/vergleichbaren Verpflichtungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2146, 'SKR03', '2: Abgrenzungskonten',                                       '2146', '2100', 'Zinsaufwendungen aus der Abzinsung von Pensionsrückstellungen und ähnlichen/vergleichbaren Verpflichtungen zur Verrechnung nach § 246 Abs. 2 HGB');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2147, 'SKR03', '2: Abgrenzungskonten',                                       '2147', '2100', 'Aufwendungen aus Vermögensgegenständen zur Verrechnung nach § 246 Abs. 2 HGB');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2148, 'SKR03', '2: Abgrenzungskonten',                                       '2148', '2100', 'Steuerlich nicht abzugsfähige Zinsaufwendungen aus der Abzinsung von Rückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2149, 'SKR03', '2: Abgrenzungskonten',                                       '2149', '2100', 'Zinsähnliche Aufwendungen an verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2150, 'SKR03', '2: Abgrenzungskonten',                                       '2150', '2100', 'Aufwendungen aus der Währungsumrechnung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2151, 'SKR03', '2: Abgrenzungskonten',                                       '2151', '2100', 'Aufwendungen aus der Währungsumrechnung (nicht § 256a HGB)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2166, 'SKR03', '2: Abgrenzungskonten',                                       '2166', '2100', 'Aufwendungen aus Bewertung Finanzmittelfonds');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2170, 'SKR03', '2: Abgrenzungskonten',                                       '2170', '2100', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2171, 'SKR03', '2: Abgrenzungskonten',                                       '2171', '2100', 'Nicht abziehbare Vorsteuer 7 %');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2174, 'SKR03', '2: Abgrenzungskonten',                                       '2174', '2100', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2175, 'SKR03', '2: Abgrenzungskonten',                                       '2175', '2100', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2176, 'SKR03', '2: Abgrenzungskonten',                                       '2176', '2100', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2200, 'SKR03', '2: Abgrenzungskonten',                                       '2200',    '0', 'Körperschaftsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2203, 'SKR03', '2: Abgrenzungskonten',                                       '2203',    '0', 'Körperschaftsteuer für Vorjahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2204, 'SKR03', '2: Abgrenzungskonten',                                       '2204',    '0', 'Körperschaftsteuererstattungen für Vorjahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2208, 'SKR03', '2: Abgrenzungskonten',                                       '2208',    '0', 'Solidaritätszuschlag');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2209, 'SKR03', '2: Abgrenzungskonten',                                       '2209',    '0', 'Solidaritätszuschlag für Vorjahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2210, 'SKR03', '2: Abgrenzungskonten',                                       '2210',    '0', 'Solidaritätszuschlagerstattungen für Vorjahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2213, 'SKR03', '2: Abgrenzungskonten',                                       '2213',    '0', 'Kapitalertragsteuer 25 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2216, 'SKR03', '2: Abgrenzungskonten',                                       '2216',    '0', 'Anrechenbarer Solidaritätszuschlag auf Kapitalertragsteuer 25 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2218, 'SKR03', '2: Abgrenzungskonten',                                       '2218',    '0', 'Ausländische Steuer auf im Inland steuerfreie DBA-Einkünfte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2219, 'SKR03', '2: Abgrenzungskonten',                                       '2219',    '0', 'Anrechnung/Abzug ausländische Quellensteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2250, 'SKR03', '2: Abgrenzungskonten',                                       '2250',    '0', 'Aufwendungen aus der Zuführung und Auflösung von latenten Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2255, 'SKR03', '2: Abgrenzungskonten',                                       '2255',    '0', 'Erträge aus der Zuführung und Auflösung von latenten Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2260, 'SKR03', '2: Abgrenzungskonten',                                       '2260',    '0', 'Aufwendungen aus der Zuführung zu Steuerrückstellungen für Steuerstundung (BStBK)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2265, 'SKR03', '2: Abgrenzungskonten',                                       '2265',    '0', 'Erträge aus der Auflösung von Steuerrückstellungen für Steuerstundung (BStBK)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2281, 'SKR03', '2: Abgrenzungskonten',                                       '2281',    '0', 'Gewerbesteuernachzahlungen und Gewerbesteuererstattungen für Vorjahre nach § 4 Abs. 5b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2283, 'SKR03', '2: Abgrenzungskonten',                                       '2283',    '0', 'Erträge aus der Auflösung von Gewerbesteuerrückstellungen nach § 4 Abs. 5b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2285, 'SKR03', '2: Abgrenzungskonten',                                       '2285',    '0', 'Steuernachzahlungen Vorjahre für sonstige Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2287, 'SKR03', '2: Abgrenzungskonten',                                       '2287',    '0', 'Steuererstattungen Vorjahre für sonstige Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2289, 'SKR03', '2: Abgrenzungskonten',                                       '2289',    '0', 'Erträge aus der Auflösung von Rückstellungen für sonstige Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2300, 'SKR03', '2: Abgrenzungskonten',                                       '2300',    '0', 'Sonstige Aufwendungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2307, 'SKR03', '2: Abgrenzungskonten',                                       '2307', '2300', 'Sonstige Aufwendungen betriebsfremd und regelmäßig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2308, 'SKR03', '2: Abgrenzungskonten',                                       '2308', '2300', 'Sonstige nicht abziehbare Aufwendungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2309, 'SKR03', '2: Abgrenzungskonten',                                       '2309', '2300', 'Sonstige Aufwendungen unregelmäßig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2310, 'SKR03', '2: Abgrenzungskonten',                                       '2310', '2300', 'Anlagenabgänge Sachanlagen (Restbuchwert bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2311, 'SKR03', '2: Abgrenzungskonten',                                       '2311', '2300', 'Anlagenabgänge immaterielle Vermögensgegenstände (Restbuchwert bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2312, 'SKR03', '2: Abgrenzungskonten',                                       '2312', '2300', 'Anlagenabgänge Finanzanlagen (Restbuchwert bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2313, 'SKR03', '2: Abgrenzungskonten',                                       '2313', '2300', 'Anlagenabgänge Finanzanlagen § 3 Nr. 40 EStG bzw. § 8b Abs. 3 KStG (Restbuchwert bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2315, 'SKR03', '2: Abgrenzungskonten',                                       '2315', '2300', 'Anlagenabgänge Sachanlagen (Restbuchwert bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2316, 'SKR03', '2: Abgrenzungskonten',                                       '2316', '2300', 'Anlagenabgänge immaterielle Vermögensgegenstände (Restbuchwert bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2317, 'SKR03', '2: Abgrenzungskonten',                                       '2317', '2300', 'Anlagenabgänge Finanzanlagen (Restbuchwert bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2318, 'SKR03', '2: Abgrenzungskonten',                                       '2318', '2300', 'Anlagenabgänge Finanzanlagen § 3 Nr. 40 EStG bzw. § 8b Abs. 2 KStG (Restbuchwert bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2320, 'SKR03', '2: Abgrenzungskonten',                                       '2320', '2300', 'Verluste aus dem Abgang von Gegenständen des Anlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2323, 'SKR03', '2: Abgrenzungskonten',                                       '2323', '2300', 'Verluste aus der Veräußerung von Anteilen an Kapitalgesellschaften (Finanzanlagevermögen) § 3 Nr. 40 EStG bzw. § 8b Abs. 3 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2325, 'SKR03', '2: Abgrenzungskonten',                                       '2325', '2300', 'Verluste aus dem Abgang von Gegenständen des Umlaufvermögens (außer Vorräte)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2326, 'SKR03', '2: Abgrenzungskonten',                                       '2326', '2300', 'Verluste aus dem Abgang von Gegenständen des Umlaufvermögens (außer Vorräte) § 3 Nr. 40 EStG bzw. § 8b Abs. 3 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2327, 'SKR03', '2: Abgrenzungskonten',                                       '2327', '2300', 'Abgang von Wirtschaftsgütern des Umlaufvermögens nach § 4 Abs. 3 Satz 4 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2328, 'SKR03', '2: Abgrenzungskonten',                                       '2328', '2300', 'Abgang von Wirtschaftsgütern des Umlaufvermögens § 3 Nr. 40 EStG bzw. § 8b Abs. 3 KStG nach § 4 Abs. 3 Satz 4 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2339, 'SKR03', '2: Abgrenzungskonten',                                       '2339', '2300', 'Einstellungen in die steuerliche Rücklage nach § 4g EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2342, 'SKR03', '2: Abgrenzungskonten',                                       '2342', '2300', 'Einstellungen in die steuerliche Rücklage nach § 6b Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2343, 'SKR03', '2: Abgrenzungskonten',                                       '2343', '2300', 'Einstellungen in die steuerliche Rücklage nach § 6b Abs. 10 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2344, 'SKR03', '2: Abgrenzungskonten',                                       '2344', '2300', 'Einstellungen in die Rücklage für Ersatzbeschaffung nach R 6.6 EStR');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2345, 'SKR03', '2: Abgrenzungskonten',                                       '2345', '2300', 'Einstellungen in sonstige steuerliche Rücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2347, 'SKR03', '2: Abgrenzungskonten',                                       '2347', '2300', 'Aufwendungen aus dem Erwerb eigener Anteile');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2350, 'SKR03', '2: Abgrenzungskonten',                                       '2350', '2300', 'Sonstige Grundstücksaufwendungen (neutral)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2375, 'SKR03', '2: Abgrenzungskonten',                                       '2375', '2300', 'Grundsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2380, 'SKR03', '2: Abgrenzungskonten',                                       '2380', '2300', 'Zuwendungen, Spenden, steuerlich nicht abziehbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2381, 'SKR03', '2: Abgrenzungskonten',                                       '2381', '2300', 'Zuwendungen, Spenden für wissenschaftliche und kulturelle Zwecke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2382, 'SKR03', '2: Abgrenzungskonten',                                       '2382', '2300', 'Zuwendungen, Spenden für mildtätige Zwecke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2383, 'SKR03', '2: Abgrenzungskonten',                                       '2383', '2300', 'Zuwendungen, Spenden für kirchliche, religiöse und gemeinnützige Zwecke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2384, 'SKR03', '2: Abgrenzungskonten',                                       '2384', '2300', 'Zuwendungen, Spenden an politische Parteien');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2385, 'SKR03', '2: Abgrenzungskonten',                                       '2385', '2300', 'Nicht abziehbare Hälfte der Aufsichtsratsvergütungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2386, 'SKR03', '2: Abgrenzungskonten',                                       '2386', '2300', 'Abziehbare Aufsichtsratsvergütungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2387, 'SKR03', '2: Abgrenzungskonten',                                       '2387', '2300', 'Zuwendungen, Spenden in das zu erhaltende Vermögen (Vermögensstock) einer Stiftung für gemeinnützige Zwecke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2389, 'SKR03', '2: Abgrenzungskonten',                                       '2389', '2300', 'Zuwendungen, Spenden in das zu erhaltende Vermögen (Vermögensstock) einer Stiftung für kirchliche, religiöse und gemeinnützige Zwecke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2390, 'SKR03', '2: Abgrenzungskonten',                                       '2390', '2300', 'Zuwendungen, Spenden an Stiftungen in das zu erhaltende Vermögen (Vermögensstock) für wissenschaftliche, mildtätige, kulturelle Zwecke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2400, 'SKR03', '2: Abgrenzungskonten',                                       '2400',    '0', 'Forderungsverluste (übliche Höhe)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2401, 'SKR03', '2: Abgrenzungskonten',                                       '2401', '2400', 'Forderungsverluste 7 % USt (übliche Höhe)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2402, 'SKR03', '2: Abgrenzungskonten',                                       '2402', '2400', 'Forderungsverluste aus steuerfreien EU-Lieferungen (übliche Höhe)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2403, 'SKR03', '2: Abgrenzungskonten',                                       '2403', '2400', 'Forderungsverluste aus im Inland steuerpflichtigen EU-Lieferungen 7 % USt (übliche Höhe)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2404, 'SKR03', '2: Abgrenzungskonten',                                       '2404', '2400', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2405, 'SKR03', '2: Abgrenzungskonten',                                       '2405', '2400', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2406, 'SKR03', '2: Abgrenzungskonten',                                       '2406', '2400', 'Forderungsverluste 19 % USt (übliche Höhe)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2407, 'SKR03', '2: Abgrenzungskonten',                                       '2407', '2400', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2408, 'SKR03', '2: Abgrenzungskonten',                                       '2408', '2400', 'Forderungsverluste aus im Inland steuerpflichtigen EU-Lieferungen 19 % USt (übliche Höhe)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2409, 'SKR03', '2: Abgrenzungskonten',                                       '2409', '2400', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2430, 'SKR03', '2: Abgrenzungskonten',                                       '2430', '2400', 'Forderungsverluste, unüblich hoch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2431, 'SKR03', '2: Abgrenzungskonten',                                       '2431', '2400', 'Forderungsverluste 7 % USt (soweit unüblich hoch)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2432, 'SKR03', '2: Abgrenzungskonten',                                       '2432', '2400', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2433, 'SKR03', '2: Abgrenzungskonten',                                       '2433', '2400', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2434, 'SKR03', '2: Abgrenzungskonten',                                       '2434', '2400', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2435, 'SKR03', '2: Abgrenzungskonten',                                       '2435', '2400', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2436, 'SKR03', '2: Abgrenzungskonten',                                       '2436', '2400', 'Forderungsverluste 19 % USt (soweit unüblich hoch)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2437, 'SKR03', '2: Abgrenzungskonten',                                       '2437', '2400', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2438, 'SKR03', '2: Abgrenzungskonten',                                       '2438', '2400', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2440, 'SKR03', '2: Abgrenzungskonten',                                       '2440', '2400', 'Abschreibungen auf Forderungen gegenüber Kapitalgesellschaften, an denen eine Beteiligung besteht (soweit unüblich hoch), § 3c EStG bzw. § 8b Abs. 3 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2441, 'SKR03', '2: Abgrenzungskonten',                                       '2441', '2400', 'Abschreibungen auf Forderungen gegenüber Gesellschaftern und nahe stehenden Personen (soweit unüblich hoch), § 8b Abs. 3 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2450, 'SKR03', '2: Abgrenzungskonten',                                       '2450', '2400', 'Einstellungen in die Pauschalwertberichtigung auf Forderungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2451, 'SKR03', '2: Abgrenzungskonten',                                       '2451', '2400', 'Einstellungen in die Einzelwertberichtigung auf Forderungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2480, 'SKR03', '2: Abgrenzungskonten',                                       '2480', '2400', 'Einstellungen in die Rücklage für Anteile an einem herrschenden oder mehrheitlich beteiligten Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2481, 'SKR03', '2: Abgrenzungskonten',                                       '2481', '2400', 'Einstellungen in gesamthänderisch gebundene Rücklagen (mit Aufteilung für Kapitalkontenentwicklung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2485, 'SKR03', '2: Abgrenzungskonten',                                       '2485', '2400', 'Einstellungen in andere Ergebnisrücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2488, 'SKR03', '2: Abgrenzungskonten',                                       '2488', '2400', 'Änderung steuerlicher Ausgleichsposten (Körperschaften)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2489, 'SKR03', '2: Abgrenzungskonten',                                       '2489', '2400', 'Änderung steuerlicher Ausgleichsposten (Personengesellschaften, Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2490, 'SKR03', '2: Abgrenzungskonten',                                       '2490', '2400', 'Aufwendungen aus Verlustübernahme');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2491, 'SKR03', '2: Abgrenzungskonten',                                       '2491', '2400', 'Abgeführte Gewinnanteile (Soll) / ausgeglichene Verlustanteile (Haben) bei atypisch stiller Beteiligung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2492, 'SKR03', '2: Abgrenzungskonten',                                       '2492', '2400', 'Abgeführte Gewinne auf Grund einer Gewinngemeinschaft');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2493, 'SKR03', '2: Abgrenzungskonten',                                       '2493', '2400', 'Abgeführte Gewinnanteile (Soll) / ausgeglichene Verlustanteile (Haben) bei typisch stiller Beteiligung § 8 GewStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2494, 'SKR03', '2: Abgrenzungskonten',                                       '2494', '2400', 'Abgeführte Gewinne auf Grund eines Gewinn- oder Teilgewinnabführungsvertrags');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2495, 'SKR03', '2: Abgrenzungskonten',                                       '2495', '2400', 'Einstellungen in die Kapitalrücklage nach den Vorschriften über die vereinfachte Kapitalherabsetzung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2496, 'SKR03', '2: Abgrenzungskonten',                                       '2496', '2400', 'Einstellungen in die gesetzliche Rücklage');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2497, 'SKR03', '2: Abgrenzungskonten',                                       '2497', '2400', 'Einstellungen in satzungsmäßige Rücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2498, 'SKR03', '2: Abgrenzungskonten',                                       '2498', '2400', 'Einstellungen in den Ausgleichsposten für aktivierte eigene Anteile');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2499, 'SKR03', '2: Abgrenzungskonten',                                       '2499', '2400', 'Einstellungen in andere Gewinnrücklagen');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2500, 'SKR03', '2: Abgrenzungskonten',                                       '2500',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2501, 'SKR03', '2: Abgrenzungskonten',                                       '2501',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2504, 'SKR03', '2: Abgrenzungskonten',                                       '2504',    '0', 'Erträge durch Verschmelzung und Umwandlung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2508, 'SKR03', '2: Abgrenzungskonten',                                       '2508',    '0', 'Gewinn aus der Veräußerung oder der Aufgabe von Geschäftsaktivitäten nach Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2510, 'SKR03', '2: Abgrenzungskonten',                                       '2510',    '0', 'Sonstige betriebsfremde Erträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2520, 'SKR03', '2: Abgrenzungskonten',                                       '2520',    '0', 'Periodenfremde Erträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2590, 'SKR03', '2: Abgrenzungskonten',                                       '2590',    '0', 'Erträge aus der Anwendung von Übergangsvorschriften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2594, 'SKR03', '2: Abgrenzungskonten',                                       '2594',    '0', 'Erträge aus der Anwendung von Übergangsvorschriften (latente Steuern)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2600, 'SKR03', '2: Abgrenzungskonten',                                       '2600',    '0', 'Erträge aus Beteiligungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2603, 'SKR03', '2: Abgrenzungskonten',                                       '2603',    '0', 'Erträge aus Beteiligungen an Personengesellschaften (verbundene Unternehmen), § 9 GewStG bzw. § 18 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2613, 'SKR03', '2: Abgrenzungskonten',                                       '2613',    '0', 'Erträge aus typisch stillen Beteiligungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2614, 'SKR03', '2: Abgrenzungskonten',                                       '2614',    '0', 'Erträge aus atypisch stillen Beteiligungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2615, 'SKR03', '2: Abgrenzungskonten',                                       '2615',    '0', 'Erträge aus Anteilen an Kapitalgesellschaften (Beteiligung) § 3 Nr. 40 EStG bzw. § 8b Abs. 1 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2616, 'SKR03', '2: Abgrenzungskonten',                                       '2616',    '0', 'Erträge aus Anteilen an Kapitalgesellschaften (verbundene Unternehmen) § 3 Nr. 40 EStG bzw. § 8b Abs. 1 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2618, 'SKR03', '2: Abgrenzungskonten',                                       '2618',    '0', 'Gewinnanteile aus gewerblichen und selbständigen Mitunternehmerschaften, § 9 GewStG bzw. § 18 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2619, 'SKR03', '2: Abgrenzungskonten',                                       '2619',    '0', 'Erträge aus Beteiligungen an verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2620, 'SKR03', '2: Abgrenzungskonten',                                       '2620',    '0', 'Erträge aus anderen Wertpapieren und Ausleihungen des Finanzanlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2621, 'SKR03', '2: Abgrenzungskonten',                                       '2621',    '0', 'Erträge aus Ausleihungen des Finanzanlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2622, 'SKR03', '2: Abgrenzungskonten',                                       '2622',    '0', 'Erträge aus Ausleihungen des Finanzanlagevermögens an verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2623, 'SKR03', '2: Abgrenzungskonten',                                       '2623',    '0', 'Erträge aus Anteilen an Personengesellschaften (Finanzanlagevermögen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2625, 'SKR03', '2: Abgrenzungskonten',                                       '2625',    '0', 'Erträge aus Anteilen an Kapitalgesellschaften (Finanzanlagevermögen) § 3 Nr. 40 EStG bzw. § 8b Abs. 1 und 4 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2626, 'SKR03', '2: Abgrenzungskonten',                                       '2626',    '0', 'Erträge aus Anteilen an Kapitalgesellschaften (verbundene Unternehmen) § 3 Nr. 40 EStG bzw. § 8b Abs. 1 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2640, 'SKR03', '2: Abgrenzungskonten',                                       '2640',    '0', 'Zins- und Dividendenerträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2641, 'SKR03', '2: Abgrenzungskonten',                                       '2641',    '0', 'Erhaltene Ausgleichszahlungen (als außenstehender Aktionär)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2646, 'SKR03', '2: Abgrenzungskonten',                                       '2646',    '0', 'Erträge aus Anteilen an Personengesellschaften (verbundene Unternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2647, 'SKR03', '2: Abgrenzungskonten',                                       '2647',    '0', 'Erträge aus anderen Wertpapieren des Finanzanlagevermögens an Kapitalgesellschaften (verbundene Unternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2648, 'SKR03', '2: Abgrenzungskonten',                                       '2648',    '0', 'Erträge aus anderen Wertpapieren des Finanzanlagevermögens an Personengesellschaften (verbundene Unternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2649, 'SKR03', '2: Abgrenzungskonten',                                       '2649',    '0', 'Erträge aus anderen Wertpapieren und Ausleihungen des Finanzanlagevermögens aus verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2650, 'SKR03', '2: Abgrenzungskonten',                                       '2650',    '0', 'Sonstige Zinsen und ähnliche Erträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2653, 'SKR03', '2: Abgrenzungskonten',                                       '2653', '2650', 'Zinserträge § 233a AO und § 4 Abs. 5b EStG, steuerfrei');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2654, 'SKR03', '2: Abgrenzungskonten',                                       '2654', '2650', 'Erträge aus anderen Wertpapieren und Ausleihungen des Umlaufvermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2655, 'SKR03', '2: Abgrenzungskonten',                                       '2655', '2650', 'Erträge aus Anteilen an Kapitalgesellschaften (Umlaufvermögen) § 3 Nr. 40 EStG bzw. § 8b Abs. 1 und 4 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2656, 'SKR03', '2: Abgrenzungskonten',                                       '2656', '2650', 'Erträge aus Anteilen an Kapitalgesellschaften (verbundene Unternehmen) § 3 Nr. 40 EStG bzw. § 8b Abs. 1 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2657, 'SKR03', '2: Abgrenzungskonten',                                       '2657', '2650', 'Zinserträge § 233a AO, steuerpflichtig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2658, 'SKR03', '2: Abgrenzungskonten',                                       '2658', '2650', 'Zinserträge § 233a AO, steuerfrei (Anlage GK KSt)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2659, 'SKR03', '2: Abgrenzungskonten',                                       '2659', '2650', 'Sonstige Zinsen und ähnliche Erträge aus verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2660, 'SKR03', '2: Abgrenzungskonten',                                       '2660', '2650', 'Erträge aus der Währungsumrechnung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2661, 'SKR03', '2: Abgrenzungskonten',                                       '2661', '2650', 'Erträge aus der Währungsumrechnung (nicht § 256a HGB)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2666, 'SKR03', '2: Abgrenzungskonten',                                       '2666', '2650', 'Erträge aus Bewertung Finanzmittelfonds');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2670, 'SKR03', '2: Abgrenzungskonten',                                       '2670', '2650', 'Diskonterträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2679, 'SKR03', '2: Abgrenzungskonten',                                       '2679', '2650', 'Diskonterträge aus verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2680, 'SKR03', '2: Abgrenzungskonten',                                       '2680', '2650', 'Zinsähnliche Erträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2682, 'SKR03', '2: Abgrenzungskonten',                                       '2682', '2650', 'Steuerfreie Zinserträge aus der Abzinsung von Rückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2683, 'SKR03', '2: Abgrenzungskonten',                                       '2683', '2650', 'Zinserträge aus der Abzinsung von Verbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2684, 'SKR03', '2: Abgrenzungskonten',                                       '2684', '2650', 'Zinserträge aus der Abzinsung von Rückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2685, 'SKR03', '2: Abgrenzungskonten',                                       '2685', '2650', 'Zinserträge aus der Abzinsung von Pensionsrückstellungen und ähnlichen/vergleichbaren Verpflichtungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2686, 'SKR03', '2: Abgrenzungskonten',                                       '2686', '2650', 'Zinserträge aus der Abzinsung von Pensionsrückstellungen und ähnlichen/vergleichbaren Verpflichtungen zur Verrechnung nach § 246 Abs. 2 HGB');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2687, 'SKR03', '2: Abgrenzungskonten',                                       '2687', '2650', 'Erträge aus Vermögensgegenständen zur Verrechnung nach § 246 Abs. 2 HGB');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2688, 'SKR03', '2: Abgrenzungskonten',                                       '2688', '2650', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2689, 'SKR03', '2: Abgrenzungskonten',                                       '2689', '2650', 'Zinsähnliche Erträge aus verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2700, 'SKR03', '2: Abgrenzungskonten',                                       '2700',    '0', 'Andere betriebs- und/oder periodenfremde (neutrale) sonstige Erträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2705, 'SKR03', '2: Abgrenzungskonten',                                       '2705', '2700', 'Sonstige betriebliche und regelmäßige Erträge (neutral)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2707, 'SKR03', '2: Abgrenzungskonten',                                       '2707', '2700', 'Sonstige Erträge betriebsfremd und regelmäßig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2709, 'SKR03', '2: Abgrenzungskonten',                                       '2709', '2700', 'Sonstige Erträge unregelmäßig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2710, 'SKR03', '2: Abgrenzungskonten',                                       '2710', '2700', 'Erträge aus Zuschreibungen des Sachanlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2711, 'SKR03', '2: Abgrenzungskonten',                                       '2711', '2700', 'Erträge aus Zuschreibungen des immateriellen Anlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2712, 'SKR03', '2: Abgrenzungskonten',                                       '2712', '2700', 'Erträge aus Zuschreibungen des Finanzanlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2713, 'SKR03', '2: Abgrenzungskonten',                                       '2713', '2700', 'Erträge aus Zuschreibungen des Finanzanlagevermögens § 3 Nr. 40 EStG bzw. § 8b Abs. 3 Satz 8 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2714, 'SKR03', '2: Abgrenzungskonten',                                       '2714', '2700', 'Erträge aus Zuschreibungen § 3 Nr. 40 EStG bzw. § 8b Abs. 2 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2715, 'SKR03', '2: Abgrenzungskonten',                                       '2715', '2700', 'Erträge aus Zuschreibungen des Umlaufvermögens (außer Vorräte)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2716, 'SKR03', '2: Abgrenzungskonten',                                       '2716', '2700', 'Erträge aus Zuschreibungen des Umlaufvermögens § 3 Nr. 40 EStG bzw. § 8b Abs. 3 Satz 8 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2720, 'SKR03', '2: Abgrenzungskonten',                                       '2720', '2700', 'Erträge aus dem Abgang von Gegenständen des Anlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2723, 'SKR03', '2: Abgrenzungskonten',                                       '2723', '2700', 'Erträge aus der Veräußerung von Anteilen an Kapitalgesellschaften (Finanzanlagevermögen) § 3 Nr. 40 EStG bzw. § 8b Abs. 2 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2725, 'SKR03', '2: Abgrenzungskonten',                                       '2725', '2700', 'Erträge aus dem Abgang von Gegenständen des Umlaufvermögens (außer Vorräte)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2726, 'SKR03', '2: Abgrenzungskonten',                                       '2726', '2700', 'Erträge aus dem Abgang von Gegenständen des Umlaufvermögens (außer Vorräte) § 3 Nr. 40 EStG bzw. § 8b Abs. 2 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2727, 'SKR03', '2: Abgrenzungskonten',                                       '2727', '2700', 'Erträge aus der Auflösung einer steuerlichen Rücklage nach § 6b Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2728, 'SKR03', '2: Abgrenzungskonten',                                       '2728', '2700', 'Erträge aus der Auflösung einer steuerlichen Rücklage nach § 6b Abs. 10 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2729, 'SKR03', '2: Abgrenzungskonten',                                       '2729', '2700', 'Erträge aus der Auflösung der Rücklage für Ersatzbeschaffung, R 6.6 EStR');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2730, 'SKR03', '2: Abgrenzungskonten',                                       '2730', '2700', 'Erträge aus der Herabsetzung der Pauschalwertberichtigung auf Forderungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2731, 'SKR03', '2: Abgrenzungskonten',                                       '2731', '2700', 'Erträge aus der Herabsetzung der Einzelwertberichtigung auf Forderungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2732, 'SKR03', '2: Abgrenzungskonten',                                       '2732', '2700', 'Erträge aus abgeschriebenen Forderungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2735, 'SKR03', '2: Abgrenzungskonten',                                       '2735', '2700', 'Erträge aus der Auflösung von Rückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2736, 'SKR03', '2: Abgrenzungskonten',                                       '2736', '2700', 'Erträge aus der Herabsetzung von Verbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2737, 'SKR03', '2: Abgrenzungskonten',                                       '2737', '2700', 'Erträge aus der Auflösung einer steuerlichen Rücklage nach § 4g EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2740, 'SKR03', '2: Abgrenzungskonten',                                       '2740', '2700', 'Erträge aus der Auflösung sonstiger steuerlicher Rücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2741, 'SKR03', '2: Abgrenzungskonten',                                       '2741', '2700', 'Erträge aus der Auflösung steuerrechtlicher Sonderabschreibungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2742, 'SKR03', '2: Abgrenzungskonten',                                       '2742', '2700', 'Versicherungsentschädigungen und Schadenersatzleistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2743, 'SKR03', '2: Abgrenzungskonten',                                       '2743', '2700', 'Investitionszuschüsse (steuerpflichtig)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2744, 'SKR03', '2: Abgrenzungskonten',                                       '2744', '2700', 'Investitionszulagen (steuerfrei)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2745, 'SKR03', '2: Abgrenzungskonten',                                       '2745', '2700', 'Erträge aus Kapitalherabsetzung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2746, 'SKR03', '2: Abgrenzungskonten',                                       '2746', '2700', 'Steuerfreie Erträge aus der Auflösung von steuerlichen Rücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2747, 'SKR03', '2: Abgrenzungskonten',                                       '2747', '2700', 'Sonstige steuerfreie Betriebseinnahmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2749, 'SKR03', '2: Abgrenzungskonten',                                       '2749', '2700', 'Erstattungen Aufwendungsausgleichsgesetz');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2750, 'SKR03', '2: Abgrenzungskonten',                                       '2750', '2700', 'Grundstückserträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2751, 'SKR03', '2: Abgrenzungskonten',                                       '2751', '2700', 'Erlöse aus Vermietung und Verpachtung, umsatzsteuerfrei § 4 Nr. 12 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2752, 'SKR03', '2: Abgrenzungskonten',                                       '2752', '2700', 'Erlöse aus Vermietung und Verpachtung 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2753, 'SKR03', '2: Abgrenzungskonten',                                       '2753', '2700', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2754, 'SKR03', '2: Abgrenzungskonten',                                       '2754', '2700', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2760, 'SKR03', '2: Abgrenzungskonten',                                       '2760', '2700', 'Erträge aus der Aktivierung unentgeltlich erworbener Vermögensgegenstände');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2762, 'SKR03', '2: Abgrenzungskonten',                                       '2762', '2700', 'Kostenerstattungen, Rückvergütungen und Gutschriften für frühere Jahre');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2764, 'SKR03', '2: Abgrenzungskonten',                                       '2764', '2700', 'Erträge aus Verwaltungskostenumlage');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2790, 'SKR03', '2: Abgrenzungskonten',                                       '2790', '2700', 'Erträge aus Verlustübernahme');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2792, 'SKR03', '2: Abgrenzungskonten',                                       '2792', '2700', 'Erhaltene Gewinne auf Grund einer Gewinngemeinschaft');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2794, 'SKR03', '2: Abgrenzungskonten',                                       '2794', '2700', 'Erhaltene Gewinne auf Grund eines Gewinn- oder Teilgewinnabführungsvertrags');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2795, 'SKR03', '2: Abgrenzungskonten',                                       '2795', '2700', 'Entnahmen aus der Kapitalrücklage');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2796, 'SKR03', '2: Abgrenzungskonten',                                       '2796', '2700', 'Entnahmen aus der gesetzlichen Rücklage');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2797, 'SKR03', '2: Abgrenzungskonten',                                       '2797', '2700', 'Entnahmen aus satzungsmäßigen Rücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2798, 'SKR03', '2: Abgrenzungskonten',                                       '2798', '2700', 'Entnahmen aus dem Ausgleichsposten für aktivierte eigene Anteile');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2799, 'SKR03', '2: Abgrenzungskonten',                                       '2799', '2700', 'Entnahmen aus anderen Gewinnrücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2840, 'SKR03', '2: Abgrenzungskonten',                                       '2840', '2700', 'Entnahmen aus der Rücklage für Anteile an einem herrschenden oder mehrheitlich beteiligten Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2841, 'SKR03', '2: Abgrenzungskonten',                                       '2841', '2700', 'Entnahmen aus gesamthänderisch gebundenen Rücklagen (mit Aufteilung für Kapitalkontenentwicklung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2850, 'SKR03', '2: Abgrenzungskonten',                                       '2850', '2700', 'Entnahmen aus anderen Ergebnisrücklagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2860, 'SKR03', '2: Abgrenzungskonten',                                       '2860',    '0', 'Gewinnvortrag nach Verwendung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2865, 'SKR03', '2: Abgrenzungskonten',                                       '2865', '2860', 'Gewinnvortrag nach Verwendung (mit Aufteilung für Kapitalkontenentwicklung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2867, 'SKR03', '2: Abgrenzungskonten',                                       '2867', '2860', 'Verlustvortrag nach Verwendung (mit Aufteilung für Kapitalkontenentwicklung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2868, 'SKR03', '2: Abgrenzungskonten',                                       '2868',    '0', 'Verlustvortrag nach Verwendung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2870, 'SKR03', '2: Abgrenzungskonten',                                       '2870', '2868', 'Vorabausschüttung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2890, 'SKR03', '2: Abgrenzungskonten',                                       '2890',    '0', 'Verrechneter kalkulatorischer Unternehmerlohn');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2891, 'SKR03', '2: Abgrenzungskonten',                                       '2891',    '0', 'Verrechnete kalkulatorische Miete und Pacht');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2892, 'SKR03', '2: Abgrenzungskonten',                                       '2892',    '0', 'Verrechnete kalkulatorische Zinsen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2893, 'SKR03', '2: Abgrenzungskonten',                                       '2893',    '0', 'Verrechnete kalkulatorische Abschreibungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2894, 'SKR03', '2: Abgrenzungskonten',                                       '2894',    '0', 'Verrechnete kalkulatorische Wagnisse');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2895, 'SKR03', '2: Abgrenzungskonten',                                       '2895',    '0', 'Verrechneter kalkulatorischer Lohn für unentgeltliche Mitarbeiter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 2900, 'SKR03', '2: Abgrenzungskonten',                                       '2900',    '0', '');
---- 3: Wareneingangs- und Bestandskonten
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3000, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3000',    '0', 'Roh-, Hilfs- und Betriebsstoffe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3010, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3010',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3011, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3011',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3012, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3012',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3013, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3013',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3014, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3014',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3015, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3015',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3016, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3016',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3017, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3017',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3018, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3018',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3019, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3019',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3020, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3020',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3021, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3021',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3022, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3022',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3023, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3023',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3024, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3024',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3025, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3025',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3026, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3026',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3027, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3027',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3028, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3028',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3029, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3029',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe ohne Vorsteuerabzug');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3030, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3030',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3031, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3031',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3032, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3032',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3033, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3033',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3034, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3034',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3035, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3035',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3036, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3036',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3037, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3037',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3038, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3038',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3039, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3039',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3040, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3040',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3041, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3041',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3042, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3042',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3043, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3043',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3044, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3044',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3045, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3045',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3046, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3046',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3047, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3047',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3048, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3048',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3049, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3049',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3050, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3050',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3051, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3051',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3052, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3052',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3053, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3053',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3054, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3054',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3055, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3055',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3056, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3056',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3057, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3057',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3058, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3058',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3059, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3059',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3060, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3060',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe, innergemeinschaftlicher Erwerb 7 % Vorsteuer und 7 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3061, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3061',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3062, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3062',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe, innergemeinschaftlicher Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3063, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3063',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe, innergemeinschaftlicher Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3064, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3064',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3065, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3065',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3066, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3066',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe, innergemeinschaftlicher Erwerb ohne Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3067, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3067',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe, innergemeinschaftlicher Erwerb ohne Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3068, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3068',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3069, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3069',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3070, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3070',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 5,5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3071, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3071',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe 9,5 % / 9,0 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3072, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3072',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3073, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3073',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3074, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3074',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3075, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3075',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe aus einem USt-Lager § 13a UStG 7 % Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3076, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3076',    '0', 'Einkauf Roh-, Hilfs- und Betriebsstoffe aus einem USt-Lager § 13a UStG 19 % Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3077, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3077',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3078, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3078',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3079, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3079',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3080, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3080',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3081, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3081',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3082, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3082',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3083, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3083',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3084, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3084',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3085, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3085',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3086, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3086',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3087, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3087',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3088, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3088',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3089, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3089',    '0', 'Erwerb Roh-, Hilfs- und Betriebsstoffe als letzter Abnehmer innerhalb Dreiecksgeschäft 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3090, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3090',    '0', 'Energiestoffe (Fertigung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3091, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3091',    '0', 'Energiestoffe (Fertigung) 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3092, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3092',    '0', 'Energiestoffe (Fertigung) 19 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3093, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3093',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3094, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3094',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3095, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3095',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3096, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3096',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3097, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3097',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3098, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3098',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3100, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3100',    '0', 'Fremdleistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3106, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3106', '3100', 'Fremdleistungen 19 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3107, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3107', '3100', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3108, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3108', '3100', 'Fremdleistungen 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3109, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3109', '3100', 'Fremdleistungen ohne Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3110, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3110',    '0', 'Bauleistungen eines im Inland ansässigen Unternehmers 7 % Vorsteuer und 7 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3111, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3111',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3112, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3112',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3113, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3113',    '0', 'Sonstige Leistungen eines im anderen EU-Land ansässigen Unternehmers 7 % Vorsteuer und 7 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3114, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3114',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3115, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3115',    '0', 'Leistungen eines im Ausland ansässigen Unternehmers 7 % Vorsteuer und 7 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3116, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3116',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3117, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3117',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3118, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3118',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3119, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3119',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3120, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3120',    '0', 'Bauleistungen eines im Inland ansässigen Unternehmers 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3121, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3121',    '0', 'Bauleistungen eines im Inland ansässigen Unternehmers 19 % Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3122, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3122',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3123, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3123',    '0', 'Sonstige Leistungen eines im anderen EU-Land ansässigen Unternehmers 19 % Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3124, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3124',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3125, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3125',    '0', 'Leistungen eines im Ausland ansässigen Unternehmers 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3126, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3126',    '0', 'Leistungen eines im Ausland ansässigen Unternehmers 19 % Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3127, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3127',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3128, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3128',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3129, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3129',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3130, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3130',    '0', 'Bauleistungen eines im Inland ansässigen Unternehmers ohne Vorsteuer und 7 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3131, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3131',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3132, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3132',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3133, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3133',    '0', 'Sonstige Leistungen eines im anderen EU-Land ansässigen Unternehmers ohne Vorsteuer und 7 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3134, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3134',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3135, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3135',    '0', 'Leistungen eines im Ausland ansässigen Unternehmers ohne Vorsteuer und 7 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3136, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3136',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3137, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3137',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3138, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3138',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3139, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3139',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3140, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3140',    '0', 'Bauleistungen eines im Inland ansässigen Unternehmers ohne Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3141, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3141',    '0', 'Bauleistungen eines im Inland ansässigen Unternehmers ohne Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3142, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3142',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3143, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3143',    '0', 'Sonstige Leistungen eines im anderen EU-Land ansässigen Unternehmers ohne Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3144, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3144',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3145, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3145',    '0', 'Leistungen eines im Ausland ansässigen Unternehmers ohne Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3146, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3146',    '0', 'Leistungen eines im Ausland ansässigen Unternehmers ohne Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3147, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3147',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3148, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3148',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3149, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3149',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3150, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3150',    '0', 'Erhaltene Skonti aus Leistungen, für die als Leistungsempfänger die Steuer nach § 13b UStG geschuldet wird');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3151, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3151',    '0', 'Erhaltene Skonti aus Leistungen, für die als Leistungsempfänger die Steuer nach § 13b UStG geschuldet wird 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3152, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3152',    '0', 'Erhaltene Skonti aus Leistungen, für die als Leistungsempfänger die Steuer nach § 13b UStG geschuldet wird 16 % Vorsteuer und 16 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3153, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3153',    '0', 'Erhaltene Skonti aus Leistungen, für die als Leistungsempfänger die Steuer nach § 13b UStG geschuldet wird ohne Vorsteuer aber mit Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3154, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3154',    '0', 'Erhaltene Skonti aus Leistungen, für die als Leistungsempfänger die Steuer nach § 13b UStG geschuldet wird ohne Vorsteuer, mit 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3155, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3155',    '0', 'Erhaltene Skonti aus Leistungen, für die als Leistungsempfänger die Steuer nach § 13b UStG geschuldet wird ohne Vorsteuer, mit 16 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3156, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3156',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3157, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3157',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3158, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3158',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3159, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3159',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3160, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3160',    '0', 'Leistungen nach § 13b UStG mit Vorsteuerabzug');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3165, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3165',    '0', 'Leistungen nach § 13b UStG ohne Vorsteuerabzug');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3170, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3170',    '0', 'Fremdleistungen (Miet- und Pachtzinsen bewegliche Wirtschaftsgüter)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3175, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3175',    '0', 'Fremdleistungen (Miet- und Pachtzinsen unbewegliche Wirtschaftsgüter)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3180, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3180',    '0', 'Fremdleistungen (Entgelte für Rechte und Lizenzen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3185, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3185',    '0', 'Fremdleistungen (Vergütungen für die Überlassung von Wirtschaftsgütern - mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3200, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3200',    '0', 'Wareneingang');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3300, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3300', '3200', 'Wareneingang 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3301, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3301', '3200', 'Wareneingang 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3302, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3302', '3200', 'Wareneingang 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3303, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3303', '3200', 'Wareneingang 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3304, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3304', '3200', 'Wareneingang 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3305, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3305', '3200', 'Wareneingang 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3306, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3306', '3200', 'Wareneingang 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3307, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3307', '3200', 'Wareneingang 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3308, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3308', '3200', 'Wareneingang 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3309, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3309', '3200', 'Wareneingang 7 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3310, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3310', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3311, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3311', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3312, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3312', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3313, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3313', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3314, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3314', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3315, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3315', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3316, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3316', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3317, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3317', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3318, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3318', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3319, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3319', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3320, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3320', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3321, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3321', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3322, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3322', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3323, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3323', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3324, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3324', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3325, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3325', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3326, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3326', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3327, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3327', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3328, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3328', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3329, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3329', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3330, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3330', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3331, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3331', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3332, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3332', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3333, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3333', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3334, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3334', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3335, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3335', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3336, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3336', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3337, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3337', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3338, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3338', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3339, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3339', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3340, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3340', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3341, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3341', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3342, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3342', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3343, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3343', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3344, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3344', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3345, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3345', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3346, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3346', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3347, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3347', '3200', 'Wareneingang 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3348, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3348', '3200', 'Wareneingang 5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3349, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3349', '3200', 'Wareneingang ohne Vorsteuerabzug');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3400, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3400', '3200', 'Wareneingang 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3401, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3401', '3200', 'Wareneingang 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3402, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3402', '3200', 'Wareneingang 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3403, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3403', '3200', 'Wareneingang 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3404, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3404', '3200', 'Wareneingang 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3405, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3405', '3200', 'Wareneingang 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3406, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3406', '3200', 'Wareneingang 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3407, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3407', '3200', 'Wareneingang 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3408, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3408', '3200', 'Wareneingang 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3409, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3409', '3200', 'Wareneingang 19 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3410, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3410', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3411, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3411', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3412, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3412', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3413, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3413', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3414, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3414', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3415, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3415', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3416, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3416', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3417, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3417', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3418, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3418', '3200', 'Wareneingang 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3419, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3419', '3200', 'Wareneingang 16 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3420, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3420', '3200', 'Innergemeinschaftlicher Erwerb 7 % Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3421, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3421', '3200', 'Innergemeinschaftlicher Erwerb 7 % Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3422, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3422', '3200', 'Innergemeinschaftlicher Erwerb 7 % Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3423, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3423', '3200', 'Innergemeinschaftlicher Erwerb 7 % Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3424, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3424', '3200', 'Innergemeinschaftlicher Erwerb 7 % Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3425, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3425', '3200', 'Innergemeinschaftlicher Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3426, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3426', '3200', 'Innergemeinschaftlicher Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3427, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3427', '3200', 'Innergemeinschaftlicher Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3428, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3428', '3200', 'Innergemeinschaftlicher Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3429, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3429', '3200', 'Innergemeinschaftlicher Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3430, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3430', '3200', 'Innergemeinschaftlicher Erwerb ohne Vorsteuer und 7 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3431, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3431', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3432, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3432', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3433, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3433', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3434, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3434', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3435, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3435', '3200', 'Innergemeinschaftlicher Erwerb ohne Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3436, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3436', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3437, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3437', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3438, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3438', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3439, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3439', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3440, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3440', '3200', 'Innergemeinschaftlicher Erwerb von Neufahrzeugen von Lieferanten ohne USt-Id-Nr. 19 % Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3441, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3441', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3442, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3442', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3443, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3443', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3444, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3444', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3445, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3445', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3446, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3446', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3447, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3447', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3448, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3448', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3449, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3449', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3500, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3500', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3501, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3501', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3502, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3502', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3503, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3503', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3504, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3504', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3505, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3505', '3200', 'Wareneingang 5,5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3506, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3506', '3200', 'Wareneingang 5,5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3507, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3507', '3200', 'Wareneingang 5,5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3508, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3508', '3200', 'Wareneingang 5,5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3509, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3509', '3200', 'Wareneingang 5,5 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3510, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3510', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3511, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3511', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3512, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3512', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3513, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3513', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3514, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3514', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3515, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3515', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3516, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3516', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3517, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3517', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3518, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3518', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3519, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3519', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3520, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3520', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3521, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3521', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3522, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3522', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3523, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3523', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3524, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3524', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3525, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3525', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3526, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3526', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3527, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3527', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3528, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3528', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3529, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3529', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3530, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3530', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3531, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3531', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3532, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3532', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3533, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3533', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3534, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3534', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3535, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3535', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3536, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3536', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3537, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3537', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3538, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3538', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3539, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3539', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3540, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3540', '3200', 'Wareneingang zum Durchschnittssatz nach § 24 UStG 9,5 % / 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3541, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3541', '3200', 'Wareneingang zum Durchschnittssatz nach § 24 UStG 9,5 % / 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3542, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3542', '3200', 'Wareneingang zum Durchschnittssatz nach § 24 UStG 9,5 % / 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3543, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3543', '3200', 'Wareneingang zum Durchschnittssatz nach § 24 UStG 9,5 % / 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3544, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3544', '3200', 'Wareneingang zum Durchschnittssatz nach § 24 UStG 9,5 % / 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3545, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3545', '3200', 'Wareneingang zum Durchschnittssatz nach § 24 UStG 9,5 % / 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3546, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3546', '3200', 'Wareneingang zum Durchschnittssatz nach § 24 UStG 9,5 % / 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3547, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3547', '3200', 'Wareneingang zum Durchschnittssatz nach § 24 UStG 9,5 % / 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3548, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3548', '3200', 'Wareneingang zum Durchschnittssatz nach § 24 UStG 9,5 % / 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3549, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3549', '3200', 'Wareneingang zum Durchschnittssatz nach § 24 UStG 9,5 % / 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3550, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3550', '3200', 'Steuerfreier innergemeinschaftlicher Erwerb');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3551, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3551', '3200', 'Wareneingang im Drittland steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3552, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3552', '3200', 'Erwerb 1. Abnehmer innerhalb eines Dreiecksgeschäftes');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3553, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3553', '3200', 'Erwerb Waren als letzter Abnehmer innerhalb Dreiecksgeschäft 19 % Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3554, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3554', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3555, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3555', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3556, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3556', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3557, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3557', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3558, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3558', '3200', 'Wareneingang im anderen EU-Land steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3559, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3559', '3200', 'Steuerfreie Einfuhren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3560, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3560', '3200', 'Waren aus einem Umsatzsteuerlager, § 13a UStG 7 % Vorsteuer und 7 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3561, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3561', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3562, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3562', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3563, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3563', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3564, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3564', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3565, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3565', '3200', 'Waren aus einem Umsatzsteuerlager, § 13a UStG 19 % Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3566, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3566', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3567, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3567', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3568, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3568', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3569, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3569', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3600, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3600', '3200', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3601, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3601', '3200', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3602, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3602', '3200', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3603, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3603', '3200', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3604, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3604', '3200', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3605, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3605', '3200', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3606, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3606', '3200', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3607, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3607', '3200', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3608, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3608', '3200', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3609, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3609', '3200', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3610, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3610', '3200', 'Nicht abziehbare Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3611, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3611', '3200', 'Nicht abziehbare Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3612, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3612', '3200', 'Nicht abziehbare Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3613, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3613', '3200', 'Nicht abziehbare Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3614, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3614', '3200', 'Nicht abziehbare Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3615, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3615', '3200', 'Nicht abziehbare Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3616, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3616', '3200', 'Nicht abziehbare Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3617, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3617', '3200', 'Nicht abziehbare Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3618, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3618', '3200', 'Nicht abziehbare Vorsteuer 7 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3619, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3619', '3200', 'Nicht abziehbare Vorsteuer 7 %');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3620, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3620', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3621, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3621', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3622, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3622', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3623, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3623', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3624, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3624', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3625, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3625', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3626, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3626', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3627, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3627', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3628, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3628', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3629, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3629', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3650, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3650', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3651, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3651', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3652, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3652', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3653, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3653', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3654, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3654', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3655, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3655', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3656, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3656', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3657, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3657', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3658, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3658', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3659, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3659', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3660, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3660', '3200', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3661, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3661', '3200', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3662, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3662', '3200', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3663, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3663', '3200', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3664, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3664', '3200', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3665, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3665', '3200', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3666, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3666', '3200', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3667, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3667', '3200', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3668, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3668', '3200', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3669, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3669', '3200', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3700, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3700', '3200', 'Nachlässe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3701, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3701', '3200', 'Nachlässe aus Einkauf Roh-, Hilfsund Betriebsstoffe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3710, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3710', '3200', 'Nachlässe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3711, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3711', '3200', 'Nachlässe 7 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3712, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3712', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3713, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3713', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3714, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3714', '3200', 'Nachlässe aus Einkauf Roh-, Hilfsund Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3715, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3715', '3200', 'Nachlässe aus Einkauf Roh-, Hilfsund Betriebsstoffe 19 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3716, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3716', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3717, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3717', '3200', 'Nachlässe aus Einkauf Roh-, Hilfsund Betriebsstoffe, innergemeinschaftlicher Erwerb 7 % Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3718, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3718', '3200', 'Nachlässe aus Einkauf Roh-, Hilfsund Betriebsstoffe, innergemeinschaftlicher Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3719, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3719', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3720, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3720', '3200', 'Nachlässe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3721, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3721', '3200', 'Nachlässe 19 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3722, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3722', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3723, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3723', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3724, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3724', '3200', 'Nachlässe aus innergemeinschaftlichem Erwerb 7 % Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3725, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3725', '3200', 'Nachlässe aus innergemeinschaftlichem Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3726, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3726', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3727, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3727', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3728, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3728', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3729, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3729', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3730, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3730', '3200', 'Erhaltene Skonti');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3731, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3731', '3200', 'Erhaltene Skonti 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3732, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3732', '3200', 'Erhaltene Skonti 5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3733, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3733', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3734, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3734', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3735, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3735', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe 5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3736, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3736', '3200', 'Erhaltene Skonti 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3737, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3737', '3200', 'Erhaltene Skonti 16 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3738, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3738', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3739, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3739', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe 16 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3740, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3740', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe aus steuerpflichtigem innergemeinschaftlichem Erwerb 16 % Vorsteuer und 16 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3741, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3741', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe aus steuerpflichtigem innergemeinschaftlichem Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3742, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3742', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe aus steuerpflichtigem innergemeinschaftlichem Erwerb 5 % Vorsteuer und 5 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3743, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3743', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe aus steuerpflichtigem innergemeinschaftlichem Erwerb 7 % Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3744, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3744', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe aus steuerpflichtigem innergemeinschaftlichem Erwerb');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3745, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3745', '3200', 'Erhaltene Skonti aus steuerpflichtigem innergemeinschaftlichem Erwerb');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3746, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3746', '3200', 'Erhaltene Skonti aus steuerpflichtigem innergemeinschaftlichem Erwerb 7 % Vorsteuer und 7 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3747, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3747', '3200', 'Erhaltene Skonti aus steuerpflichtigem innergemeinschaftlichem Erwerb 5 % Vorsteuer und 5 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3748, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3748', '3200', 'Erhaltene Skonti aus steuerpflichtigem innergemeinschaftlichem Erwerb 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3749, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3749', '3200', 'Erhaltene Skonti aus steuerpflichtigem innergemeinschaftlichem Erwerb 16 % Vorsteuer und 16 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3750, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3750', '3200', 'Erhaltene Boni 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3751, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3751', '3200', 'Erhaltene Boni 7 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3752, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3752', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3753, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3753', '3200', 'Erhaltene Boni aus Einkauf Roh-, Hilfs- und Betriebsstoffe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3754, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3754', '3200', 'Erhaltene Boni aus Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3755, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3755', '3200', 'Erhaltene Boni aus Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3756, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3756', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3757, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3757', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3758, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3758', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3759, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3759', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3760, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3760', '3200', 'Erhaltene Boni 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3761, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3761', '3200', 'Erhaltene Boni 19 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3762, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3762', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3763, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3763', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3764, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3764', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3765, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3765', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3766, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3766', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3767, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3767', '3200', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3768, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3768', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3769, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3769', '3200', 'Erhaltene Boni');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3770, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3770', '3200', 'Erhaltene Rabatte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3780, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3780', '3200', 'Erhaltene Rabatte 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3781, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3781', '3200', 'Erhaltene Rabatte 7 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3782, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3782', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3783, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3783', '3200', 'Erhaltene Rabatte aus Einkauf Roh-, Hilfs- und Betriebsstoffe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3784, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3784', '3200', 'Erhaltene Rabatte aus Einkauf Roh-, Hilfs- und Betriebsstoffe 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3785, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3785', '3200', 'Erhaltene Rabatte aus Einkauf Roh-, Hilfs- und Betriebsstoffe 19 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3786, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3786', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3787, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3787', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3788, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3788', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe 10,7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3789, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3789', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe 9,5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3790, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3790', '3200', 'Erhaltene Rabatte 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3791, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3791', '3200', 'Erhaltene Rabatte 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3792, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3792', '3200', 'Erhaltene Skonti aus Erwerb Roh-, Hilfs- und Betriebsstoffe als letzter Abnehmer innerhalb Dreiecksgeschäft 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3793, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3793', '3200', 'Erhaltene Skonti aus Erwerb Waren als letzter Abnehmer innerhalb Dreiecksgeschäft 19 % Vorsteuer und 19 % Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3794, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3794', '3200', 'Erhaltene Skonti 5,5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3795, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3795', '3200', 'Erhaltene Skonti 9,0 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3796, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3796', '3200', 'Erhaltene Skonti 10,7 % Vorsteuer ');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3797, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3797', '3200', 'Erhaltene Skonti 9,5 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3798, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3798', '3200', 'Erhaltene Skonti aus Einkauf Roh-, Hilfs- und Betriebsstoffe 5,5 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3799, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3799', '3200', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3800, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3800', '3200', 'Bezugsnebenkosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3830, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3830', '3200', 'Leergut');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3850, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3850', '3200', 'Zölle und Einfuhrabgaben');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3950, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3950', '3200', 'Bestandsveränderungen Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3951, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3951', '3200', 'Bestandsveränderungen Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3952, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3952', '3200', 'Bestandsveränderungen Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3953, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3953', '3200', 'Bestandsveränderungen Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3954, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3954', '3200', 'Bestandsveränderungen Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3955, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3955', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3956, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3956', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3957, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3957', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3958, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3958', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3959, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3959', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3960, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3960', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe sowie bezogene Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3961, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3961', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe sowie bezogene Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3962, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3962', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe sowie bezogene Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3963, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3963', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe sowie bezogene Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3964, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3964', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe sowie bezogene Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3965, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3965', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe sowie bezogene Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3966, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3966', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe sowie bezogene Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3967, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3967', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe sowie bezogene Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3968, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3968', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe sowie bezogene Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3969, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3969', '3200', 'Bestandsveränderungen Roh-, Hilfs- und Betriebsstoffe sowie bezogene Waren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3970, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3970',    '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3971, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3971',    '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3972, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3972',    '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3973, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3973',    '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3974, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3974',    '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3975, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3975',    '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3976, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3976',    '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3977, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3977',    '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3978, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3978',    '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3979, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3979',    '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3980, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3980',    '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3981, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3981',    '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3982, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3982',    '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3983, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3983',    '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3984, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3984',    '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3985, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3985',    '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3986, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3986',    '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3987, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3987',    '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3988, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3988',    '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3989, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3989',    '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3990, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3990',    '0', 'Verrechnete Stoffkosten (Gegenkonto zu 4000-99)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3991, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3991',    '0', 'Verrechnete Stoffkosten (Gegenkonto zu 4000-99)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3992, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3992',    '0', 'Verrechnete Stoffkosten (Gegenkonto zu 4000-99)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3993, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3993',    '0', 'Verrechnete Stoffkosten (Gegenkonto zu 4000-99)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3994, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3994',    '0', 'Verrechnete Stoffkosten (Gegenkonto zu 4000-99)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3995, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3995',    '0', 'Verrechnete Stoffkosten (Gegenkonto zu 4000-99)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3996, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3996',    '0', 'Verrechnete Stoffkosten (Gegenkonto zu 4000-99)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3997, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3997',    '0', 'Verrechnete Stoffkosten (Gegenkonto zu 4000-99)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3998, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3998',    '0', 'Verrechnete Stoffkosten (Gegenkonto zu 4000-99)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 3999, 'SKR03', '3: Wareneingangs- und Bestandskonten',                       '3999',    '0', 'Verrechnete Stoffkosten (Gegenkonto zu 4000-99)');
---- 4: Betriebliche Aufwendungen
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4000, 'SKR03', '4: Betriebliche Aufwendungen',                               '4000',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4001, 'SKR03', '4: Betriebliche Aufwendungen',                               '4001',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4002, 'SKR03', '4: Betriebliche Aufwendungen',                               '4002',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4003, 'SKR03', '4: Betriebliche Aufwendungen',                               '4003',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4004, 'SKR03', '4: Betriebliche Aufwendungen',                               '4004',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4005, 'SKR03', '4: Betriebliche Aufwendungen',                               '4005',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4006, 'SKR03', '4: Betriebliche Aufwendungen',                               '4006',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4007, 'SKR03', '4: Betriebliche Aufwendungen',                               '4007',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4008, 'SKR03', '4: Betriebliche Aufwendungen',                               '4008',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4009, 'SKR03', '4: Betriebliche Aufwendungen',                               '4009',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4010, 'SKR03', '4: Betriebliche Aufwendungen',                               '4010',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4011, 'SKR03', '4: Betriebliche Aufwendungen',                               '4011',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4012, 'SKR03', '4: Betriebliche Aufwendungen',                               '4012',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4013, 'SKR03', '4: Betriebliche Aufwendungen',                               '4013',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4014, 'SKR03', '4: Betriebliche Aufwendungen',                               '4014',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4015, 'SKR03', '4: Betriebliche Aufwendungen',                               '4015',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4016, 'SKR03', '4: Betriebliche Aufwendungen',                               '4016',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4017, 'SKR03', '4: Betriebliche Aufwendungen',                               '4017',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4018, 'SKR03', '4: Betriebliche Aufwendungen',                               '4018',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4019, 'SKR03', '4: Betriebliche Aufwendungen',                               '4019',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4020, 'SKR03', '4: Betriebliche Aufwendungen',                               '4020',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4021, 'SKR03', '4: Betriebliche Aufwendungen',                               '4021',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4022, 'SKR03', '4: Betriebliche Aufwendungen',                               '4022',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4023, 'SKR03', '4: Betriebliche Aufwendungen',                               '4023',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4024, 'SKR03', '4: Betriebliche Aufwendungen',                               '4024',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4025, 'SKR03', '4: Betriebliche Aufwendungen',                               '4025',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4026, 'SKR03', '4: Betriebliche Aufwendungen',                               '4026',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4027, 'SKR03', '4: Betriebliche Aufwendungen',                               '4027',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4028, 'SKR03', '4: Betriebliche Aufwendungen',                               '4028',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4029, 'SKR03', '4: Betriebliche Aufwendungen',                               '4029',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4030, 'SKR03', '4: Betriebliche Aufwendungen',                               '4030',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4031, 'SKR03', '4: Betriebliche Aufwendungen',                               '4031',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4032, 'SKR03', '4: Betriebliche Aufwendungen',                               '4032',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4033, 'SKR03', '4: Betriebliche Aufwendungen',                               '4033',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4034, 'SKR03', '4: Betriebliche Aufwendungen',                               '4034',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4035, 'SKR03', '4: Betriebliche Aufwendungen',                               '4035',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4036, 'SKR03', '4: Betriebliche Aufwendungen',                               '4036',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4037, 'SKR03', '4: Betriebliche Aufwendungen',                               '4037',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4038, 'SKR03', '4: Betriebliche Aufwendungen',                               '4038',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4039, 'SKR03', '4: Betriebliche Aufwendungen',                               '4039',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4040, 'SKR03', '4: Betriebliche Aufwendungen',                               '4040',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4041, 'SKR03', '4: Betriebliche Aufwendungen',                               '4041',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4042, 'SKR03', '4: Betriebliche Aufwendungen',                               '4042',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4043, 'SKR03', '4: Betriebliche Aufwendungen',                               '4043',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4044, 'SKR03', '4: Betriebliche Aufwendungen',                               '4044',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4045, 'SKR03', '4: Betriebliche Aufwendungen',                               '4045',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4046, 'SKR03', '4: Betriebliche Aufwendungen',                               '4046',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4047, 'SKR03', '4: Betriebliche Aufwendungen',                               '4047',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4048, 'SKR03', '4: Betriebliche Aufwendungen',                               '4048',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4049, 'SKR03', '4: Betriebliche Aufwendungen',                               '4049',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4050, 'SKR03', '4: Betriebliche Aufwendungen',                               '4050',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4051, 'SKR03', '4: Betriebliche Aufwendungen',                               '4051',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4052, 'SKR03', '4: Betriebliche Aufwendungen',                               '4052',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4053, 'SKR03', '4: Betriebliche Aufwendungen',                               '4053',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4054, 'SKR03', '4: Betriebliche Aufwendungen',                               '4054',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4055, 'SKR03', '4: Betriebliche Aufwendungen',                               '4055',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4056, 'SKR03', '4: Betriebliche Aufwendungen',                               '4056',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4057, 'SKR03', '4: Betriebliche Aufwendungen',                               '4057',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4058, 'SKR03', '4: Betriebliche Aufwendungen',                               '4058',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4059, 'SKR03', '4: Betriebliche Aufwendungen',                               '4059',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4060, 'SKR03', '4: Betriebliche Aufwendungen',                               '4060',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4061, 'SKR03', '4: Betriebliche Aufwendungen',                               '4061',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4062, 'SKR03', '4: Betriebliche Aufwendungen',                               '4062',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4063, 'SKR03', '4: Betriebliche Aufwendungen',                               '4063',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4064, 'SKR03', '4: Betriebliche Aufwendungen',                               '4064',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4065, 'SKR03', '4: Betriebliche Aufwendungen',                               '4065',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4066, 'SKR03', '4: Betriebliche Aufwendungen',                               '4066',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4067, 'SKR03', '4: Betriebliche Aufwendungen',                               '4067',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4068, 'SKR03', '4: Betriebliche Aufwendungen',                               '4068',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4069, 'SKR03', '4: Betriebliche Aufwendungen',                               '4069',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4070, 'SKR03', '4: Betriebliche Aufwendungen',                               '4070',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4071, 'SKR03', '4: Betriebliche Aufwendungen',                               '4071',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4072, 'SKR03', '4: Betriebliche Aufwendungen',                               '4072',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4073, 'SKR03', '4: Betriebliche Aufwendungen',                               '4073',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4074, 'SKR03', '4: Betriebliche Aufwendungen',                               '4074',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4075, 'SKR03', '4: Betriebliche Aufwendungen',                               '4075',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4076, 'SKR03', '4: Betriebliche Aufwendungen',                               '4076',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4077, 'SKR03', '4: Betriebliche Aufwendungen',                               '4077',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4078, 'SKR03', '4: Betriebliche Aufwendungen',                               '4078',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4079, 'SKR03', '4: Betriebliche Aufwendungen',                               '4079',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4080, 'SKR03', '4: Betriebliche Aufwendungen',                               '4080',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4081, 'SKR03', '4: Betriebliche Aufwendungen',                               '4081',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4082, 'SKR03', '4: Betriebliche Aufwendungen',                               '4082',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4083, 'SKR03', '4: Betriebliche Aufwendungen',                               '4083',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4084, 'SKR03', '4: Betriebliche Aufwendungen',                               '4084',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4085, 'SKR03', '4: Betriebliche Aufwendungen',                               '4085',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4086, 'SKR03', '4: Betriebliche Aufwendungen',                               '4086',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4087, 'SKR03', '4: Betriebliche Aufwendungen',                               '4087',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4088, 'SKR03', '4: Betriebliche Aufwendungen',                               '4088',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4089, 'SKR03', '4: Betriebliche Aufwendungen',                               '4089',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4090, 'SKR03', '4: Betriebliche Aufwendungen',                               '4090',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4091, 'SKR03', '4: Betriebliche Aufwendungen',                               '4091',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4092, 'SKR03', '4: Betriebliche Aufwendungen',                               '4092',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4093, 'SKR03', '4: Betriebliche Aufwendungen',                               '4093',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4094, 'SKR03', '4: Betriebliche Aufwendungen',                               '4094',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4095, 'SKR03', '4: Betriebliche Aufwendungen',                               '4095',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4096, 'SKR03', '4: Betriebliche Aufwendungen',                               '4096',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4097, 'SKR03', '4: Betriebliche Aufwendungen',                               '4097',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4098, 'SKR03', '4: Betriebliche Aufwendungen',                               '4098',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4099, 'SKR03', '4: Betriebliche Aufwendungen',                               '4099',    '0', 'Material- und Stoffverbrauch');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4100, 'SKR03', '4: Betriebliche Aufwendungen',                               '4100',    '0', 'Löhne und Gehälter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4110, 'SKR03', '4: Betriebliche Aufwendungen',                               '4110',    '0', 'Löhne');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4120, 'SKR03', '4: Betriebliche Aufwendungen',                               '4120',    '0', 'Gehälter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4124, 'SKR03', '4: Betriebliche Aufwendungen',                               '4124',    '0', 'Geschäftsführergehälter der GmbH-Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4125, 'SKR03', '4: Betriebliche Aufwendungen',                               '4125',    '0', 'Ehegattengehalt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4126, 'SKR03', '4: Betriebliche Aufwendungen',                               '4126',    '0', 'Tantiemen Gesellschafter-Geschäftsführer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4127, 'SKR03', '4: Betriebliche Aufwendungen',                               '4127',    '0', 'Geschäftsführergehälter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4128, 'SKR03', '4: Betriebliche Aufwendungen',                               '4128',    '0', 'Vergütungen an angestellte Mitunternehmer § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4129, 'SKR03', '4: Betriebliche Aufwendungen',                               '4129',    '0', 'Tantiemen Arbeitnehmer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4130, 'SKR03', '4: Betriebliche Aufwendungen',                               '4130',    '0', 'Gesetzliche soziale Aufwendungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4137, 'SKR03', '4: Betriebliche Aufwendungen',                               '4137',    '0', 'Gesetzliche soziale Aufwendungen für Mitunternehmer § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4138, 'SKR03', '4: Betriebliche Aufwendungen',                               '4138',    '0', 'Beiträge zur Berufsgenossenschaft');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4139, 'SKR03', '4: Betriebliche Aufwendungen',                               '4139',    '0', 'Ausgleichsabgabe nach dem Schwerbehindertengesetz');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4140, 'SKR03', '4: Betriebliche Aufwendungen',                               '4140',    '0', 'Freiwillige soziale Aufwendungen, lohnsteuerfrei');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4141, 'SKR03', '4: Betriebliche Aufwendungen',                               '4141',    '0', 'Sonstige soziale Abgaben');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4144, 'SKR03', '4: Betriebliche Aufwendungen',                               '4144',    '0', 'Soziale Abgaben für Minijobber');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4145, 'SKR03', '4: Betriebliche Aufwendungen',                               '4145',    '0', 'Freiwillige soziale Aufwendungen, lohnsteuerpflichtig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4146, 'SKR03', '4: Betriebliche Aufwendungen',                               '4146',    '0', 'Freiwillige Zuwendungen an Minijobber');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4147, 'SKR03', '4: Betriebliche Aufwendungen',                               '4147',    '0', 'Freiwillige Zuwendungen an Gesellschafter-Geschäftsführer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4148, 'SKR03', '4: Betriebliche Aufwendungen',                               '4148',    '0', 'Freiwillige Zuwendungen an angestellte Mitunternehmer § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4149, 'SKR03', '4: Betriebliche Aufwendungen',                               '4149',    '0', 'Pauschale Steuer auf sonstige Bezüge (z. B. Fahrtkostenzuschüsse)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4150, 'SKR03', '4: Betriebliche Aufwendungen',                               '4150',    '0', 'Krankengeldzuschüsse');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4151, 'SKR03', '4: Betriebliche Aufwendungen',                               '4151',    '0', 'Sachzuwendungen und Dienstleistungen an Minijobber');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4152, 'SKR03', '4: Betriebliche Aufwendungen',                               '4152',    '0', 'Sachzuwendungen und Dienstleistungen an Arbeitnehmer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4153, 'SKR03', '4: Betriebliche Aufwendungen',                               '4153',    '0', 'Sachzuwendungen und Dienstleistungen an Gesellschafter-Geschäftsführer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4154, 'SKR03', '4: Betriebliche Aufwendungen',                               '4154',    '0', 'Sachzuwendungen und Dienstleistungen an angestellte Mitunternehmer § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4155, 'SKR03', '4: Betriebliche Aufwendungen',                               '4155',    '0', 'Zuschüsse der Agenturen für Arbeit (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4156, 'SKR03', '4: Betriebliche Aufwendungen',                               '4156',    '0', 'Aufwendungen aus der Veränderung von Urlaubsrückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4157, 'SKR03', '4: Betriebliche Aufwendungen',                               '4157',    '0', 'Aufwendungen aus der Veränderung von Urlaubsrückstellungen für Gesellschafter-Geschäftsführer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4158, 'SKR03', '4: Betriebliche Aufwendungen',                               '4158',    '0', 'Aufwendungen aus der Veränderung von Urlaubsrückstellungen für angestellte Mitunternehmer § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4159, 'SKR03', '4: Betriebliche Aufwendungen',                               '4159',    '0', 'Aufwendungen aus der Veränderung von Urlaubsrückstellungen für Minijobber');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4160, 'SKR03', '4: Betriebliche Aufwendungen',                               '4160',    '0', 'Versorgungskassen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4165, 'SKR03', '4: Betriebliche Aufwendungen',                               '4165',    '0', 'Aufwendungen für Altersversorgung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4166, 'SKR03', '4: Betriebliche Aufwendungen',                               '4166',    '0', 'Aufwendungen für Altersversorgung für Gesellschafter-Geschäftsführer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4167, 'SKR03', '4: Betriebliche Aufwendungen',                               '4167',    '0', 'Pauschale Steuer auf sonstige Bezüge (z. B. Direktversicherungen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4168, 'SKR03', '4: Betriebliche Aufwendungen',                               '4168',    '0', 'Aufwendungen für Altersversorgung für Mitunternehmer § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4169, 'SKR03', '4: Betriebliche Aufwendungen',                               '4169',    '0', 'Aufwendungen für Unterstützung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4170, 'SKR03', '4: Betriebliche Aufwendungen',                               '4170',    '0', 'Vermögenswirksame Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4175, 'SKR03', '4: Betriebliche Aufwendungen',                               '4175',    '0', 'Fahrtkostenerstattung - Wohnung/Arbeitsstätte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4180, 'SKR03', '4: Betriebliche Aufwendungen',                               '4180',    '0', 'Bedienungsgelder');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4190, 'SKR03', '4: Betriebliche Aufwendungen',                               '4190',    '0', 'Aushilfslöhne');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4194, 'SKR03', '4: Betriebliche Aufwendungen',                               '4194',    '0', 'Pauschale Steuer für Minijobber');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4195, 'SKR03', '4: Betriebliche Aufwendungen',                               '4195',    '0', 'Löhne für Minijobs');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4196, 'SKR03', '4: Betriebliche Aufwendungen',                               '4196',    '0', 'Pauschale Steuer für Gesellschafter-Geschäftsführer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4197, 'SKR03', '4: Betriebliche Aufwendungen',                               '4197',    '0', 'Pauschale Steuer für angestellte Mitunternehmer § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4198, 'SKR03', '4: Betriebliche Aufwendungen',                               '4198',    '0', 'Pauschale Steuer für Arbeitnehmer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4199, 'SKR03', '4: Betriebliche Aufwendungen',                               '4199',    '0', 'Pauschale Steuer für Aushilfen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4200, 'SKR03', '4: Betriebliche Aufwendungen',                               '4200',    '0', 'Raumkosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4210, 'SKR03', '4: Betriebliche Aufwendungen',                               '4210',    '0', 'Miete (unbewegliche Wirtschaftsgüter)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4211, 'SKR03', '4: Betriebliche Aufwendungen',                               '4211',    '0', 'Aufwendungen für gemietete oder gepachtete unbewegliche Wirtschaftsgüter, die gewerbesteuerlich hinzuzurechnen sind');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4212, 'SKR03', '4: Betriebliche Aufwendungen',                               '4212',    '0', 'Miete/Aufwendungen für doppelte Haushaltsführung Unternehmer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4215, 'SKR03', '4: Betriebliche Aufwendungen',                               '4215',    '0', 'Leasing (unbewegliche Wirtschaftsgüter)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4219, 'SKR03', '4: Betriebliche Aufwendungen',                               '4219',    '0', 'Vergütungen an Mitunternehmer für die mietweise Überlassung ihrer unbeweglichen Wirtschaftsgüter § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4220, 'SKR03', '4: Betriebliche Aufwendungen',                               '4220',    '0', 'Pacht (unbewegliche Wirtschaftsgüter)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4222, 'SKR03', '4: Betriebliche Aufwendungen',                               '4222',    '0', 'Vergütungen an Gesellschafter für die miet- oder pachtweise Überlassung ihrer unbeweglichen Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4228, 'SKR03', '4: Betriebliche Aufwendungen',                               '4228',    '0', 'Miet- und Pachtnebenkosten, die gewerbesteuerlich nicht hinzuzurechnen sind');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4229, 'SKR03', '4: Betriebliche Aufwendungen',                               '4229',    '0', 'Vergütungen an Mitunternehmer für die pachtweise Überlassung ihrer unbeweglichen Wirtschaftsgüter § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4230, 'SKR03', '4: Betriebliche Aufwendungen',                               '4230',    '0', 'Heizung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4240, 'SKR03', '4: Betriebliche Aufwendungen',                               '4240',    '0', 'Gas, Strom, Wasser');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4250, 'SKR03', '4: Betriebliche Aufwendungen',                               '4250',    '0', 'Reinigung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4260, 'SKR03', '4: Betriebliche Aufwendungen',                               '4260',    '0', 'Instandhaltung betrieblicher Räume');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4270, 'SKR03', '4: Betriebliche Aufwendungen',                               '4270',    '0', 'Abgaben für betrieblich genutzten Grundbesitz');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4280, 'SKR03', '4: Betriebliche Aufwendungen',                               '4280',    '0', 'Sonstige Raumkosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4288, 'SKR03', '4: Betriebliche Aufwendungen',                               '4288',    '0', 'Aufwendungen für ein häusliches Arbeitszimmer (abziehbarer Anteil)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4289, 'SKR03', '4: Betriebliche Aufwendungen',                               '4289',    '0', 'Aufwendungen für ein häusliches Arbeitszimmer (nicht abziehbarer Anteil)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4290, 'SKR03', '4: Betriebliche Aufwendungen',                               '4290',    '0', 'Grundstücksaufwendungen betrieblich');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4300, 'SKR03', '4: Betriebliche Aufwendungen',                               '4300',    '0', 'Nicht abziehbare Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4301, 'SKR03', '4: Betriebliche Aufwendungen',                               '4301',    '0', 'Nicht abziehbare Vorsteuer 7 %');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4304, 'SKR03', '4: Betriebliche Aufwendungen',                               '4304',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4305, 'SKR03', '4: Betriebliche Aufwendungen',                               '4305',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4306, 'SKR03', '4: Betriebliche Aufwendungen',                               '4306',    '0', 'Nicht abziehbare Vorsteuer 19 %');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4320, 'SKR03', '4: Betriebliche Aufwendungen',                               '4320',    '0', 'Gewerbesteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4340, 'SKR03', '4: Betriebliche Aufwendungen',                               '4340',    '0', 'Sonstige Betriebssteuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4350, 'SKR03', '4: Betriebliche Aufwendungen',                               '4350',    '0', 'Verbrauchsteuer (sonstige Steuern)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4355, 'SKR03', '4: Betriebliche Aufwendungen',                               '4355',    '0', 'Ökosteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4360, 'SKR03', '4: Betriebliche Aufwendungen',                               '4360',    '0', 'Versicherungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4366, 'SKR03', '4: Betriebliche Aufwendungen',                               '4366',    '0', 'Versicherungen für Gebäude');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4370, 'SKR03', '4: Betriebliche Aufwendungen',                               '4370',    '0', 'Netto-Prämie für Rückdeckung künftiger Versorgungsleistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4380, 'SKR03', '4: Betriebliche Aufwendungen',                               '4380',    '0', 'Beiträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4390, 'SKR03', '4: Betriebliche Aufwendungen',                               '4390',    '0', 'Sonstige Abgaben');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4396, 'SKR03', '4: Betriebliche Aufwendungen',                               '4396',    '0', 'Steuerlich abzugsfähige Verspätungszuschläge und Zwangsgelder');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4397, 'SKR03', '4: Betriebliche Aufwendungen',                               '4397',    '0', 'Steuerlich nicht abzugsfähige Verspätungszuschläge und Zwangsgelder');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4400, 'SKR03', '4: Betriebliche Aufwendungen',                               '4400',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4401, 'SKR03', '4: Betriebliche Aufwendungen',                               '4401',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4402, 'SKR03', '4: Betriebliche Aufwendungen',                               '4402',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4403, 'SKR03', '4: Betriebliche Aufwendungen',                               '4403',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4404, 'SKR03', '4: Betriebliche Aufwendungen',                               '4404',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4405, 'SKR03', '4: Betriebliche Aufwendungen',                               '4405',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4406, 'SKR03', '4: Betriebliche Aufwendungen',                               '4406',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4407, 'SKR03', '4: Betriebliche Aufwendungen',                               '4407',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4408, 'SKR03', '4: Betriebliche Aufwendungen',                               '4408',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4409, 'SKR03', '4: Betriebliche Aufwendungen',                               '4409',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4410, 'SKR03', '4: Betriebliche Aufwendungen',                               '4410',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4411, 'SKR03', '4: Betriebliche Aufwendungen',                               '4411',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4412, 'SKR03', '4: Betriebliche Aufwendungen',                               '4412',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4413, 'SKR03', '4: Betriebliche Aufwendungen',                               '4413',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4414, 'SKR03', '4: Betriebliche Aufwendungen',                               '4414',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4415, 'SKR03', '4: Betriebliche Aufwendungen',                               '4415',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4416, 'SKR03', '4: Betriebliche Aufwendungen',                               '4416',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4417, 'SKR03', '4: Betriebliche Aufwendungen',                               '4417',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4418, 'SKR03', '4: Betriebliche Aufwendungen',                               '4418',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4419, 'SKR03', '4: Betriebliche Aufwendungen',                               '4419',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4420, 'SKR03', '4: Betriebliche Aufwendungen',                               '4420',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4421, 'SKR03', '4: Betriebliche Aufwendungen',                               '4421',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4422, 'SKR03', '4: Betriebliche Aufwendungen',                               '4422',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4423, 'SKR03', '4: Betriebliche Aufwendungen',                               '4423',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4424, 'SKR03', '4: Betriebliche Aufwendungen',                               '4424',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4425, 'SKR03', '4: Betriebliche Aufwendungen',                               '4425',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4426, 'SKR03', '4: Betriebliche Aufwendungen',                               '4426',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4427, 'SKR03', '4: Betriebliche Aufwendungen',                               '4427',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4428, 'SKR03', '4: Betriebliche Aufwendungen',                               '4428',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4429, 'SKR03', '4: Betriebliche Aufwendungen',                               '4429',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4430, 'SKR03', '4: Betriebliche Aufwendungen',                               '4430',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4431, 'SKR03', '4: Betriebliche Aufwendungen',                               '4431',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4432, 'SKR03', '4: Betriebliche Aufwendungen',                               '4432',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4433, 'SKR03', '4: Betriebliche Aufwendungen',                               '4433',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4434, 'SKR03', '4: Betriebliche Aufwendungen',                               '4434',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4435, 'SKR03', '4: Betriebliche Aufwendungen',                               '4435',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4436, 'SKR03', '4: Betriebliche Aufwendungen',                               '4436',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4437, 'SKR03', '4: Betriebliche Aufwendungen',                               '4437',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4438, 'SKR03', '4: Betriebliche Aufwendungen',                               '4438',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4439, 'SKR03', '4: Betriebliche Aufwendungen',                               '4439',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4440, 'SKR03', '4: Betriebliche Aufwendungen',                               '4440',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4441, 'SKR03', '4: Betriebliche Aufwendungen',                               '4441',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4442, 'SKR03', '4: Betriebliche Aufwendungen',                               '4442',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4443, 'SKR03', '4: Betriebliche Aufwendungen',                               '4443',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4444, 'SKR03', '4: Betriebliche Aufwendungen',                               '4444',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4445, 'SKR03', '4: Betriebliche Aufwendungen',                               '4445',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4446, 'SKR03', '4: Betriebliche Aufwendungen',                               '4446',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4447, 'SKR03', '4: Betriebliche Aufwendungen',                               '4447',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4448, 'SKR03', '4: Betriebliche Aufwendungen',                               '4448',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4449, 'SKR03', '4: Betriebliche Aufwendungen',                               '4449',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4450, 'SKR03', '4: Betriebliche Aufwendungen',                               '4450',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4451, 'SKR03', '4: Betriebliche Aufwendungen',                               '4451',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4452, 'SKR03', '4: Betriebliche Aufwendungen',                               '4452',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4453, 'SKR03', '4: Betriebliche Aufwendungen',                               '4453',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4454, 'SKR03', '4: Betriebliche Aufwendungen',                               '4454',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4455, 'SKR03', '4: Betriebliche Aufwendungen',                               '4455',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4456, 'SKR03', '4: Betriebliche Aufwendungen',                               '4456',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4457, 'SKR03', '4: Betriebliche Aufwendungen',                               '4457',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4458, 'SKR03', '4: Betriebliche Aufwendungen',                               '4458',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4459, 'SKR03', '4: Betriebliche Aufwendungen',                               '4459',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4460, 'SKR03', '4: Betriebliche Aufwendungen',                               '4460',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4461, 'SKR03', '4: Betriebliche Aufwendungen',                               '4461',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4462, 'SKR03', '4: Betriebliche Aufwendungen',                               '4462',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4463, 'SKR03', '4: Betriebliche Aufwendungen',                               '4463',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4464, 'SKR03', '4: Betriebliche Aufwendungen',                               '4464',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4465, 'SKR03', '4: Betriebliche Aufwendungen',                               '4465',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4466, 'SKR03', '4: Betriebliche Aufwendungen',                               '4466',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4467, 'SKR03', '4: Betriebliche Aufwendungen',                               '4467',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4468, 'SKR03', '4: Betriebliche Aufwendungen',                               '4468',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4469, 'SKR03', '4: Betriebliche Aufwendungen',                               '4469',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4470, 'SKR03', '4: Betriebliche Aufwendungen',                               '4470',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4471, 'SKR03', '4: Betriebliche Aufwendungen',                               '4471',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4472, 'SKR03', '4: Betriebliche Aufwendungen',                               '4472',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4473, 'SKR03', '4: Betriebliche Aufwendungen',                               '4473',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4474, 'SKR03', '4: Betriebliche Aufwendungen',                               '4474',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4475, 'SKR03', '4: Betriebliche Aufwendungen',                               '4475',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4476, 'SKR03', '4: Betriebliche Aufwendungen',                               '4476',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4477, 'SKR03', '4: Betriebliche Aufwendungen',                               '4477',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4478, 'SKR03', '4: Betriebliche Aufwendungen',                               '4478',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4479, 'SKR03', '4: Betriebliche Aufwendungen',                               '4479',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4480, 'SKR03', '4: Betriebliche Aufwendungen',                               '4480',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4481, 'SKR03', '4: Betriebliche Aufwendungen',                               '4481',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4482, 'SKR03', '4: Betriebliche Aufwendungen',                               '4482',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4483, 'SKR03', '4: Betriebliche Aufwendungen',                               '4483',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4484, 'SKR03', '4: Betriebliche Aufwendungen',                               '4484',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4485, 'SKR03', '4: Betriebliche Aufwendungen',                               '4485',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4486, 'SKR03', '4: Betriebliche Aufwendungen',                               '4486',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4487, 'SKR03', '4: Betriebliche Aufwendungen',                               '4487',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4488, 'SKR03', '4: Betriebliche Aufwendungen',                               '4488',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4489, 'SKR03', '4: Betriebliche Aufwendungen',                               '4489',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4490, 'SKR03', '4: Betriebliche Aufwendungen',                               '4490',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4491, 'SKR03', '4: Betriebliche Aufwendungen',                               '4491',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4492, 'SKR03', '4: Betriebliche Aufwendungen',                               '4492',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4493, 'SKR03', '4: Betriebliche Aufwendungen',                               '4493',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4494, 'SKR03', '4: Betriebliche Aufwendungen',                               '4494',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4495, 'SKR03', '4: Betriebliche Aufwendungen',                               '4495',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4496, 'SKR03', '4: Betriebliche Aufwendungen',                               '4496',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4497, 'SKR03', '4: Betriebliche Aufwendungen',                               '4497',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4498, 'SKR03', '4: Betriebliche Aufwendungen',                               '4498',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4499, 'SKR03', '4: Betriebliche Aufwendungen',                               '4499',    '0', '(zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4500, 'SKR03', '4: Betriebliche Aufwendungen',                               '4500',    '0', 'Fahrzeugkosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4510, 'SKR03', '4: Betriebliche Aufwendungen',                               '4510',    '0', 'Kfz-Steuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4520, 'SKR03', '4: Betriebliche Aufwendungen',                               '4520',    '0', 'Fahrzeug-Versicherungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4530, 'SKR03', '4: Betriebliche Aufwendungen',                               '4530',    '0', 'Laufende Fahrzeug-Betriebskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4540, 'SKR03', '4: Betriebliche Aufwendungen',                               '4540',    '0', 'Fahrzeug-Reparaturen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4550, 'SKR03', '4: Betriebliche Aufwendungen',                               '4550',    '0', 'Garagenmiete');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4560, 'SKR03', '4: Betriebliche Aufwendungen',                               '4560',    '0', 'Mautgebühren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4570, 'SKR03', '4: Betriebliche Aufwendungen',                               '4570',    '0', 'Mietleasing Kfz');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4575, 'SKR03', '4: Betriebliche Aufwendungen',                               '4575',    '0', 'Mietleasingaufwendungen für Elektrofahrzeuge und Fahrräder, die gewerbesteuerlich hinzuzurechnen sind');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4580, 'SKR03', '4: Betriebliche Aufwendungen',                               '4580',    '0', 'Sonstige Fahrzeugkosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4590, 'SKR03', '4: Betriebliche Aufwendungen',                               '4590',    '0', 'Kosten für betrieblich genutzte zum Privatvermögen gehörende Fahrzeuge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4595, 'SKR03', '4: Betriebliche Aufwendungen',                               '4595',    '0', 'Fremdfahrzeugkosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4600, 'SKR03', '4: Betriebliche Aufwendungen',                               '4600',    '0', 'Werbekosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4605, 'SKR03', '4: Betriebliche Aufwendungen',                               '4605',    '0', 'Streuartikel');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4630, 'SKR03', '4: Betriebliche Aufwendungen',                               '4630',    '0', 'Geschenke abzugsfähig ohne § 37b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4631, 'SKR03', '4: Betriebliche Aufwendungen',                               '4631',    '0', 'Geschenke abzugsfähig mit § 37b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4632, 'SKR03', '4: Betriebliche Aufwendungen',                               '4632',    '0', 'Pauschale Steuer für Geschenke und Zuwendungen abzugsfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4635, 'SKR03', '4: Betriebliche Aufwendungen',                               '4635',    '0', 'Geschenke nicht abzugsfähig ohne § 37b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4636, 'SKR03', '4: Betriebliche Aufwendungen',                               '4636',    '0', 'Geschenke nicht abzugsfähig mit § 37b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4637, 'SKR03', '4: Betriebliche Aufwendungen',                               '4637',    '0', 'Pauschale Steuer für Geschenke und Zuwendungen nicht abzugsfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4638, 'SKR03', '4: Betriebliche Aufwendungen',                               '4638',    '0', 'Geschenke ausschließlich betrieblich genutzt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4639, 'SKR03', '4: Betriebliche Aufwendungen',                               '4639',    '0', 'Zugaben mit § 37b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4640, 'SKR03', '4: Betriebliche Aufwendungen',                               '4640',    '0', 'Repräsentationskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4650, 'SKR03', '4: Betriebliche Aufwendungen',                               '4650',    '0', 'Bewirtungskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4651, 'SKR03', '4: Betriebliche Aufwendungen',                               '4651',    '0', 'Sonstige eingeschränkt abziehbare Betriebsausgaben (abziehbarer Anteil)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4652, 'SKR03', '4: Betriebliche Aufwendungen',                               '4652',    '0', 'Sonstige eingeschränkt abziehbare Betriebsausgaben (nicht abziehbarer Anteil)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4653, 'SKR03', '4: Betriebliche Aufwendungen',                               '4653',    '0', 'Aufmerksamkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4654, 'SKR03', '4: Betriebliche Aufwendungen',                               '4654',    '0', 'Nicht abzugsfähige Bewirtungskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4655, 'SKR03', '4: Betriebliche Aufwendungen',                               '4655',    '0', 'Nicht abzugsfähige Betriebsausgaben aus Werbe- und Repräsentationskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4660, 'SKR03', '4: Betriebliche Aufwendungen',                               '4660',    '0', 'Reisekosten Arbeitnehmer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4663, 'SKR03', '4: Betriebliche Aufwendungen',                               '4663',    '0', 'Reisekosten Arbeitnehmer Fahrtkosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4664, 'SKR03', '4: Betriebliche Aufwendungen',                               '4664',    '0', 'Reisekosten Arbeitnehmer Verpflegungsmehraufwand');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4666, 'SKR03', '4: Betriebliche Aufwendungen',                               '4666',    '0', 'Reisekosten Arbeitnehmer Übernachtungsaufwand');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4667, 'SKR03', '4: Betriebliche Aufwendungen',                               '4667',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4668, 'SKR03', '4: Betriebliche Aufwendungen',                               '4668',    '0', 'Kilometergelderstattung Arbeitnehmer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4670, 'SKR03', '4: Betriebliche Aufwendungen',                               '4670',    '0', 'Reisekosten Unternehmer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4672, 'SKR03', '4: Betriebliche Aufwendungen',                               '4672',    '0', 'Reisekosten Unternehmer (nicht abziehbarer Anteil)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4673, 'SKR03', '4: Betriebliche Aufwendungen',                               '4673',    '0', 'Reisekosten Unternehmer Fahrtkosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4674, 'SKR03', '4: Betriebliche Aufwendungen',                               '4674',    '0', 'Reisekosten Unternehmer Verpflegungsmehraufwand');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4675, 'SKR03', '4: Betriebliche Aufwendungen',                               '4675',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4676, 'SKR03', '4: Betriebliche Aufwendungen',                               '4676',    '0', 'Reisekosten Unternehmer Übernachtungsaufwand und Reisenebenkosten');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4677, 'SKR03', '4: Betriebliche Aufwendungen',                               '4677',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4678, 'SKR03', '4: Betriebliche Aufwendungen',                               '4678',    '0', 'Fahrten zwischen Wohnung und Betriebsstätte und Familienheimfahrten (abziehbarer Anteil)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4679, 'SKR03', '4: Betriebliche Aufwendungen',                               '4679',    '0', 'Fahrten zwischen Wohnung und Betriebsstätte und Familienheimfahrten (nicht abziehbarer Anteil)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4680, 'SKR03', '4: Betriebliche Aufwendungen',                               '4680',    '0', 'Fahrten zwischen Wohnung und Betriebsstätte und Familienheimfahrten (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4681, 'SKR03', '4: Betriebliche Aufwendungen',                               '4681',    '0', 'Verpflegungsmehraufwendungen im Rahmen der doppelten Haushaltsführung Unternehmer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4685, 'SKR03', '4: Betriebliche Aufwendungen',                               '4685',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4700, 'SKR03', '4: Betriebliche Aufwendungen',                               '4700',    '0', 'Kosten der Warenabgabe');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4710, 'SKR03', '4: Betriebliche Aufwendungen',                               '4710',    '0', 'Verpackungsmaterial');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4730, 'SKR03', '4: Betriebliche Aufwendungen',                               '4730',    '0', 'Ausgangsfrachten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4750, 'SKR03', '4: Betriebliche Aufwendungen',                               '4750',    '0', 'Transportversicherungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4760, 'SKR03', '4: Betriebliche Aufwendungen',                               '4760',    '0', 'Verkaufsprovisionen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4780, 'SKR03', '4: Betriebliche Aufwendungen',                               '4780',    '0', 'Fremdarbeiten (Vertrieb)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4790, 'SKR03', '4: Betriebliche Aufwendungen',                               '4790',    '0', 'Aufwand für Gewährleistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4800, 'SKR03', '4: Betriebliche Aufwendungen',                               '4800',    '0', 'Reparaturen und Instandhaltungen von technischen Anlagen und Maschinen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4801, 'SKR03', '4: Betriebliche Aufwendungen',                               '4801',    '0', 'Reparaturen und Instandhaltung von Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4805, 'SKR03', '4: Betriebliche Aufwendungen',                               '4805',    '0', 'Reparaturen und Instandhaltungen von anderen Anlagen und Betriebsund Geschäftsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4806, 'SKR03', '4: Betriebliche Aufwendungen',                               '4806',    '0', 'Wartungskosten für Hard- und Software');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4808, 'SKR03', '4: Betriebliche Aufwendungen',                               '4808',    '0', 'Zuführung zu Aufwandsrückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4809, 'SKR03', '4: Betriebliche Aufwendungen',                               '4809',    '0', 'Sonstige Reparaturen und Instandhaltungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4810, 'SKR03', '4: Betriebliche Aufwendungen',                               '4810',    '0', 'Mietleasing bewegliche Wirtschaftsgüter für technische Anlagen und Maschinen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4815, 'SKR03', '4: Betriebliche Aufwendungen',                               '4815',    '0', 'Kaufleasing');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4822, 'SKR03', '4: Betriebliche Aufwendungen',                               '4822',    '0', 'Abschreibungen auf immaterielle Vermögensgegenstände');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4823, 'SKR03', '4: Betriebliche Aufwendungen',                               '4823',    '0', 'Abschreibungen auf selbst geschaffene immaterielle Vermögensgegenstände');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4824, 'SKR03', '4: Betriebliche Aufwendungen',                               '4824',    '0', 'Abschreibungen auf den Geschäftsoder Firmenwert');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4825, 'SKR03', '4: Betriebliche Aufwendungen',                               '4825',    '0', 'Außerplanmäßige Abschreibungen auf den Geschäfts- oder Firmenwert');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4826, 'SKR03', '4: Betriebliche Aufwendungen',                               '4826',    '0', 'Außerplanmäßige Abschreibungen auf immaterielle Vermögensgegenstände');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4827, 'SKR03', '4: Betriebliche Aufwendungen',                               '4827',    '0', 'Außerplanmäßige Abschreibungen auf selbst geschaffene immaterielle Vermögensgegenstände');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4830, 'SKR03', '4: Betriebliche Aufwendungen',                               '4830',    '0', 'Abschreibungen auf Sachanlagen (ohne AfA auf Fahrzeuge und Gebäude)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4831, 'SKR03', '4: Betriebliche Aufwendungen',                               '4831',    '0', 'Abschreibungen auf Gebäude');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4832, 'SKR03', '4: Betriebliche Aufwendungen',                               '4832',    '0', 'Abschreibungen auf Fahrzeuge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4833, 'SKR03', '4: Betriebliche Aufwendungen',                               '4833',    '0', 'Abschreibungen auf Gebäudeanteil des häuslichen Arbeitszimmers');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4840, 'SKR03', '4: Betriebliche Aufwendungen',                               '4840',    '0', 'Außerplanmäßige Abschreibungen auf Sachanlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4841, 'SKR03', '4: Betriebliche Aufwendungen',                               '4841',    '0', 'Absetzung für außergewöhnliche technische und wirtschaftliche Abnutzung der Gebäude');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4842, 'SKR03', '4: Betriebliche Aufwendungen',                               '4842',    '0', 'Absetzung für außergewöhnliche technische und wirtschaftliche Abnutzung der Fahrzeuge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4843, 'SKR03', '4: Betriebliche Aufwendungen',                               '4843',    '0', 'Absetzung für außergewöhnliche technische und wirtschaftliche Abnutzung sonstiger Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4850, 'SKR03', '4: Betriebliche Aufwendungen',                               '4850',    '0', 'Abschreibungen auf Sachanlagen auf Grund steuerlicher Sondervorschriften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4851, 'SKR03', '4: Betriebliche Aufwendungen',                               '4851',    '0', 'Sonderabschreibungen nach § 7g Abs. 5 EStG (ohne Fahrzeuge)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4852, 'SKR03', '4: Betriebliche Aufwendungen',                               '4852',    '0', 'Sonderabschreibungen nach § 7g Abs. 5 EStG (für Fahrzeuge)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4853, 'SKR03', '4: Betriebliche Aufwendungen',                               '4853',    '0', 'Kürzung der Anschaffungs- oder Herstellungskosten nach § 7g Abs. 2 EStG (ohne Fahrzeuge)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4854, 'SKR03', '4: Betriebliche Aufwendungen',                               '4854',    '0', 'Kürzung der Anschaffungs- oder Herstellungskosten nach § 7g Abs. 2 EStG (für Fahrzeuge)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4855, 'SKR03', '4: Betriebliche Aufwendungen',                               '4855',    '0', 'Sofortabschreibung geringwertiger Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4856, 'SKR03', '4: Betriebliche Aufwendungen',                               '4856',    '0', 'Sonderabschreibungen nach § 7b EStG (Mietwohnungsneubau)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4859, 'SKR03', '4: Betriebliche Aufwendungen',                               '4859',    '0', 'Abzugsbetrag nach § 6b EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4860, 'SKR03', '4: Betriebliche Aufwendungen',                               '4860',    '0', 'Abschreibungen auf aktivierte, geringwertige Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4862, 'SKR03', '4: Betriebliche Aufwendungen',                               '4862',    '0', 'Abschreibungen auf den Sammelposten Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4865, 'SKR03', '4: Betriebliche Aufwendungen',                               '4865',    '0', 'Außerplanmäßige Abschreibungen auf aktivierte, geringwertige Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4866, 'SKR03', '4: Betriebliche Aufwendungen',                               '4866',    '0', 'Abschreibungen auf Finanzanlagen (nicht dauerhaft)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4870, 'SKR03', '4: Betriebliche Aufwendungen',                               '4870',    '0', 'Abschreibungen auf Finanzanlagen (dauerhaft)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4871, 'SKR03', '4: Betriebliche Aufwendungen',                               '4871',    '0', 'Abschreibungen auf Finanzanlagen § 3 Nr. 40 EStG bzw. § 8b Abs. 3 KStG (dauerhaft)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4872, 'SKR03', '4: Betriebliche Aufwendungen',                               '4872',    '0', 'Aufwendungen auf Grund von Verlustanteilen an gewerblichen und selbständigen Mitunternehmerschaften, § 8 GewStG bzw. § 18 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4873, 'SKR03', '4: Betriebliche Aufwendungen',                               '4873',    '0', 'Abschreibungen auf Finanzanlagen auf Grund § 6b EStG-Rücklage, § 3 Nr. 40 EStG bzw. § 8b Abs. 3 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4874, 'SKR03', '4: Betriebliche Aufwendungen',                               '4874',    '0', 'Abschreibungen auf Finanzanlagen auf Grund § 6b EStG-Rücklage');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4875, 'SKR03', '4: Betriebliche Aufwendungen',                               '4875',    '0', 'Abschreibungen auf Wertpapiere des Umlaufvermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4876, 'SKR03', '4: Betriebliche Aufwendungen',                               '4876',    '0', 'Abschreibungen auf Wertpapiere des Umlaufvermögens § 3 Nr. 40 EStG bzw. § 8b Abs. 3 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4877, 'SKR03', '4: Betriebliche Aufwendungen',                               '4877',    '0', 'Abschreibungen auf Finanzanlagen - verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4878, 'SKR03', '4: Betriebliche Aufwendungen',                               '4878',    '0', 'Abschreibungen auf Wertpapiere des Umlaufvermögens - verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4880, 'SKR03', '4: Betriebliche Aufwendungen',                               '4880',    '0', 'Abschreibungen auf sonstige Vermögensgegenstände des Umlaufvermögens (soweit unüblich hoch)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4882, 'SKR03', '4: Betriebliche Aufwendungen',                               '4882',    '0', 'Abschreibungen auf Umlaufvermögen, steuerrechtlich bedingt (soweit unüblich hoch)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4886, 'SKR03', '4: Betriebliche Aufwendungen',                               '4886',    '0', 'Abschreibungen auf Umlaufvermögen außer Vorräte und Wertpapiere des Umlaufvermögens (übliche Höhe)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4887, 'SKR03', '4: Betriebliche Aufwendungen',                               '4887',    '0', 'Abschreibungen auf Umlaufvermögen außer Vorräte und Wertpapiere des Umlaufvermögens, steuerrechtlich bedingt (übliche Höhe)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4892, 'SKR03', '4: Betriebliche Aufwendungen',                               '4892',    '0', 'Abschreibungen auf Roh-, Hilfs- und Betriebsstoffe/Waren (soweit unübliche Höhe)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4893, 'SKR03', '4: Betriebliche Aufwendungen',                               '4893',    '0', 'Abschreibungen auf fertige und unfertige Erzeugnisse (soweit unübliche Höhe)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4900, 'SKR03', '4: Betriebliche Aufwendungen',                               '4900',    '0', 'Sonstige betriebliche Aufwendungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4902, 'SKR03', '4: Betriebliche Aufwendungen',                               '4902',    '0', 'Interimskonto für Aufwendungen in einem anderen Land, bei denen eine Vorsteuervergütung möglich ist');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4905, 'SKR03', '4: Betriebliche Aufwendungen',                               '4905',    '0', 'Sonstige Aufwendungen betrieblich und regelmäßig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4909, 'SKR03', '4: Betriebliche Aufwendungen',                               '4909',    '0', 'Fremdleistungen/Fremdarbeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4910, 'SKR03', '4: Betriebliche Aufwendungen',                               '4910',    '0', 'Porto');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4920, 'SKR03', '4: Betriebliche Aufwendungen',                               '4920',    '0', 'Telefon');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4925, 'SKR03', '4: Betriebliche Aufwendungen',                               '4925',    '0', 'Telefax und Internetkosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4930, 'SKR03', '4: Betriebliche Aufwendungen',                               '4930',    '0', 'Bürobedarf');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4940, 'SKR03', '4: Betriebliche Aufwendungen',                               '4940',    '0', 'Zeitschriften, Bücher (Fachliteratur)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4945, 'SKR03', '4: Betriebliche Aufwendungen',                               '4945',    '0', 'Fortbildungskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4946, 'SKR03', '4: Betriebliche Aufwendungen',                               '4946',    '0', 'Freiwillige Sozialleistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4948, 'SKR03', '4: Betriebliche Aufwendungen',                               '4948',    '0', 'Vergütungen an Mitunternehmer § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4949, 'SKR03', '4: Betriebliche Aufwendungen',                               '4949',    '0', 'Haftungsvergütung an Mitunternehmer § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4950, 'SKR03', '4: Betriebliche Aufwendungen',                               '4950',    '0', 'Rechts- und Beratungskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4955, 'SKR03', '4: Betriebliche Aufwendungen',                               '4955',    '0', 'Buchführungskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4957, 'SKR03', '4: Betriebliche Aufwendungen',                               '4957',    '0', 'Abschluss- und Prüfungskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4958, 'SKR03', '4: Betriebliche Aufwendungen',                               '4958',    '0', 'Vergütungen an Gesellschafter für die miet- oder pachtweise Überlassung ihrer beweglichen Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4959, 'SKR03', '4: Betriebliche Aufwendungen',                               '4959',    '0', 'Vergütungen an Mitunternehmer für die miet- oder pachtweise Überlassung ihrer beweglichen Wirtschaftsgüter § 15 EStG (mit Sonderbetriebseinnahme korrespondierend)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4960, 'SKR03', '4: Betriebliche Aufwendungen',                               '4960',    '0', 'Mieten für Einrichtungen (bewegliche Wirtschaftsgüter)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4961, 'SKR03', '4: Betriebliche Aufwendungen',                               '4961',    '0', 'Pacht (bewegliche Wirtschaftsgüter)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4963, 'SKR03', '4: Betriebliche Aufwendungen',                               '4963',    '0', 'Aufwendungen für gemietete oder gepachtete bewegliche Wirtschaftsgüter, die gewerbesteuerlich hinzuzurechnen sind');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4964, 'SKR03', '4: Betriebliche Aufwendungen',                               '4964',    '0', 'Aufwendungen für die zeitlich befristete Überlassung von Rechten (Lizenzen, Konzessionen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4965, 'SKR03', '4: Betriebliche Aufwendungen',                               '4965',    '0', 'Mietleasing bewegliche Wirtschaftsgüter für Betriebs- und Geschäftsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4969, 'SKR03', '4: Betriebliche Aufwendungen',                               '4969',    '0', 'Aufwendungen für Abraum- und Abfallbeseitigung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4970, 'SKR03', '4: Betriebliche Aufwendungen',                               '4970',    '0', 'Nebenkosten des Geldverkehrs');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4971, 'SKR03', '4: Betriebliche Aufwendungen',                               '4971',    '0', 'Verwahrentgelt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4975, 'SKR03', '4: Betriebliche Aufwendungen',                               '4975',    '0', 'Aufwendungen aus Anteilen an Kapitalgesellschaften §§ 3 Nr. 40 und 3c EStG bzw. § 8b Abs. 1 und 4 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4976, 'SKR03', '4: Betriebliche Aufwendungen',                               '4976',    '0', 'Veräußerungskosten § 3 Nr. 40 EStG bzw. § 8b Abs. 2 KStG (bei Veräußerungsgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4977, 'SKR03', '4: Betriebliche Aufwendungen',                               '4977',    '0', 'Veräußerungskosten § 3 Nr. 40 EStG bzw. § 8b Abs. 3 KStG (bei Veräußerungsverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4980, 'SKR03', '4: Betriebliche Aufwendungen',                               '4980',    '0', 'Sonstiger Betriebsbedarf');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4984, 'SKR03', '4: Betriebliche Aufwendungen',                               '4984',    '0', 'Genossenschaftliche Rückvergütung an Mitglieder');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4985, 'SKR03', '4: Betriebliche Aufwendungen',                               '4985',    '0', 'Werkzeuge und Kleingeräte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4990, 'SKR03', '4: Betriebliche Aufwendungen',                               '4990',    '0', 'Kalkulatorischer Unternehmerlohn');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4991, 'SKR03', '4: Betriebliche Aufwendungen',                               '4991',    '0', 'Kalkulatorische Miete und Pacht');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4992, 'SKR03', '4: Betriebliche Aufwendungen',                               '4992',    '0', 'Kalkulatorische Zinsen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4993, 'SKR03', '4: Betriebliche Aufwendungen',                               '4993',    '0', 'Kalkulatorische Abschreibungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4994, 'SKR03', '4: Betriebliche Aufwendungen',                               '4994',    '0', 'Kalkulatorische Wagnisse');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4995, 'SKR03', '4: Betriebliche Aufwendungen',                               '4995',    '0', 'Kalkulatorischer Lohn für unentgeltliche Mitarbeiter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4996, 'SKR03', '4: Betriebliche Aufwendungen',                               '4996',    '0', 'Herstellungskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4997, 'SKR03', '4: Betriebliche Aufwendungen',                               '4997',    '0', 'Verwaltungskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4998, 'SKR03', '4: Betriebliche Aufwendungen',                               '4998',    '0', 'Vertriebskosten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 4999, 'SKR03', '4: Betriebliche Aufwendungen',                               '4999',    '0', 'Gegenkonto 4996-4998');
---- 5:
---- 6:
---- 7: Bestände an Erzeugnissen
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 7000, 'SKR03', '7: Bestände an Erzeugnissen',                                '7000',    '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 7050, 'SKR03', '7: Bestände an Erzeugnissen',                                '7050', '7000', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 7080, 'SKR03', '7: Bestände an Erzeugnissen',                                '7080', '7000', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 7090, 'SKR03', '7: Bestände an Erzeugnissen',                                '7090', '7000', 'In Ausführung befindliche Bauaufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 7095, 'SKR03', '7: Bestände an Erzeugnissen',                                '7095', '7000', 'In Arbeit befindliche Aufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 7100, 'SKR03', '7: Bestände an Erzeugnissen',                                '7100',    '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 7110, 'SKR03', '7: Bestände an Erzeugnissen',                                '7110', '7100', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 7140, 'SKR03', '7: Bestände an Erzeugnissen',                                '7140', '7100', 'Waren (Bestand)');
---- 8: Erlöskonten
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8000, 'SKR03', '8: Erlöskonten',                                             '8000',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8001, 'SKR03', '8: Erlöskonten',                                             '8001',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8002, 'SKR03', '8: Erlöskonten',                                             '8002',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8003, 'SKR03', '8: Erlöskonten',                                             '8003',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8004, 'SKR03', '8: Erlöskonten',                                             '8004',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8005, 'SKR03', '8: Erlöskonten',                                             '8005',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8006, 'SKR03', '8: Erlöskonten',                                             '8006',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8007, 'SKR03', '8: Erlöskonten',                                             '8007',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8008, 'SKR03', '8: Erlöskonten',                                             '8008',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8009, 'SKR03', '8: Erlöskonten',                                             '8009',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8010, 'SKR03', '8: Erlöskonten',                                             '8010',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8011, 'SKR03', '8: Erlöskonten',                                             '8011',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8012, 'SKR03', '8: Erlöskonten',                                             '8012',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8013, 'SKR03', '8: Erlöskonten',                                             '8013',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8014, 'SKR03', '8: Erlöskonten',                                             '8014',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8015, 'SKR03', '8: Erlöskonten',                                             '8015',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8016, 'SKR03', '8: Erlöskonten',                                             '8016',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8017, 'SKR03', '8: Erlöskonten',                                             '8017',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8018, 'SKR03', '8: Erlöskonten',                                             '8018',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8019, 'SKR03', '8: Erlöskonten',                                             '8019',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8020, 'SKR03', '8: Erlöskonten',                                             '8020',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8021, 'SKR03', '8: Erlöskonten',                                             '8021',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8022, 'SKR03', '8: Erlöskonten',                                             '8022',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8023, 'SKR03', '8: Erlöskonten',                                             '8023',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8024, 'SKR03', '8: Erlöskonten',                                             '8024',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8025, 'SKR03', '8: Erlöskonten',                                             '8025',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8026, 'SKR03', '8: Erlöskonten',                                             '8026',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8027, 'SKR03', '8: Erlöskonten',                                             '8027',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8028, 'SKR03', '8: Erlöskonten',                                             '8028',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8029, 'SKR03', '8: Erlöskonten',                                             '8029',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8030, 'SKR03', '8: Erlöskonten',                                             '8030',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8031, 'SKR03', '8: Erlöskonten',                                             '8031',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8032, 'SKR03', '8: Erlöskonten',                                             '8032',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8033, 'SKR03', '8: Erlöskonten',                                             '8033',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8034, 'SKR03', '8: Erlöskonten',                                             '8034',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8035, 'SKR03', '8: Erlöskonten',                                             '8035',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8036, 'SKR03', '8: Erlöskonten',                                             '8036',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8037, 'SKR03', '8: Erlöskonten',                                             '8037',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8038, 'SKR03', '8: Erlöskonten',                                             '8038',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8039, 'SKR03', '8: Erlöskonten',                                             '8039',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8040, 'SKR03', '8: Erlöskonten',                                             '8040',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8041, 'SKR03', '8: Erlöskonten',                                             '8041',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8042, 'SKR03', '8: Erlöskonten',                                             '8042',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8043, 'SKR03', '8: Erlöskonten',                                             '8043',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8044, 'SKR03', '8: Erlöskonten',                                             '8044',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8045, 'SKR03', '8: Erlöskonten',                                             '8045',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8046, 'SKR03', '8: Erlöskonten',                                             '8046',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8047, 'SKR03', '8: Erlöskonten',                                             '8047',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8048, 'SKR03', '8: Erlöskonten',                                             '8048',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8049, 'SKR03', '8: Erlöskonten',                                             '8049',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8050, 'SKR03', '8: Erlöskonten',                                             '8050',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8051, 'SKR03', '8: Erlöskonten',                                             '8051',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8052, 'SKR03', '8: Erlöskonten',                                             '8052',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8053, 'SKR03', '8: Erlöskonten',                                             '8053',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8054, 'SKR03', '8: Erlöskonten',                                             '8054',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8055, 'SKR03', '8: Erlöskonten',                                             '8055',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8056, 'SKR03', '8: Erlöskonten',                                             '8056',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8057, 'SKR03', '8: Erlöskonten',                                             '8057',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8058, 'SKR03', '8: Erlöskonten',                                             '8058',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8059, 'SKR03', '8: Erlöskonten',                                             '8059',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8060, 'SKR03', '8: Erlöskonten',                                             '8060',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8061, 'SKR03', '8: Erlöskonten',                                             '8061',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8062, 'SKR03', '8: Erlöskonten',                                             '8062',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8063, 'SKR03', '8: Erlöskonten',                                             '8063',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8064, 'SKR03', '8: Erlöskonten',                                             '8064',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8065, 'SKR03', '8: Erlöskonten',                                             '8065',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8066, 'SKR03', '8: Erlöskonten',                                             '8066',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8067, 'SKR03', '8: Erlöskonten',                                             '8067',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8068, 'SKR03', '8: Erlöskonten',                                             '8068',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8069, 'SKR03', '8: Erlöskonten',                                             '8069',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8070, 'SKR03', '8: Erlöskonten',                                             '8070',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8071, 'SKR03', '8: Erlöskonten',                                             '8071',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8072, 'SKR03', '8: Erlöskonten',                                             '8072',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8073, 'SKR03', '8: Erlöskonten',                                             '8073',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8074, 'SKR03', '8: Erlöskonten',                                             '8074',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8075, 'SKR03', '8: Erlöskonten',                                             '8075',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8076, 'SKR03', '8: Erlöskonten',                                             '8076',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8077, 'SKR03', '8: Erlöskonten',                                             '8077',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8078, 'SKR03', '8: Erlöskonten',                                             '8078',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8079, 'SKR03', '8: Erlöskonten',                                             '8079',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8080, 'SKR03', '8: Erlöskonten',                                             '8080',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8081, 'SKR03', '8: Erlöskonten',                                             '8081',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8082, 'SKR03', '8: Erlöskonten',                                             '8082',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8083, 'SKR03', '8: Erlöskonten',                                             '8083',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8084, 'SKR03', '8: Erlöskonten',                                             '8084',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8085, 'SKR03', '8: Erlöskonten',                                             '8085',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8086, 'SKR03', '8: Erlöskonten',                                             '8086',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8087, 'SKR03', '8: Erlöskonten',                                             '8087',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8088, 'SKR03', '8: Erlöskonten',                                             '8088',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8089, 'SKR03', '8: Erlöskonten',                                             '8089',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8090, 'SKR03', '8: Erlöskonten',                                             '8090',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8091, 'SKR03', '8: Erlöskonten',                                             '8091',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8092, 'SKR03', '8: Erlöskonten',                                             '8092',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8093, 'SKR03', '8: Erlöskonten',                                             '8093',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8094, 'SKR03', '8: Erlöskonten',                                             '8094',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8095, 'SKR03', '8: Erlöskonten',                                             '8095',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8096, 'SKR03', '8: Erlöskonten',                                             '8096',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8097, 'SKR03', '8: Erlöskonten',                                             '8097',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8098, 'SKR03', '8: Erlöskonten',                                             '8098',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8099, 'SKR03', '8: Erlöskonten',                                             '8099',    '0', 'Umsatzerlöse (Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8100, 'SKR03', '8: Erlöskonten',                                             '8100',    '0', 'Steuerfreie Umsätze § 4 Nr. 8 ff. UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8101, 'SKR03', '8: Erlöskonten',                                             '8101',    '0', 'Steuerfreie Umsätze § 4 Nr. 8 ff. UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8102, 'SKR03', '8: Erlöskonten',                                             '8102',    '0', 'Steuerfreie Umsätze § 4 Nr. 8 ff. UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8103, 'SKR03', '8: Erlöskonten',                                             '8103',    '0', 'Steuerfreie Umsätze § 4 Nr. 8 ff. UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8104, 'SKR03', '8: Erlöskonten',                                             '8104',    '0', 'Steuerfreie Umsätze § 4 Nr. 8 ff. UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8105, 'SKR03', '8: Erlöskonten',                                             '8105',    '0', 'Steuerfreie Umsätze nach § 4 Nr. 12 UStG (Vermietung und Verpachtung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8110, 'SKR03', '8: Erlöskonten',                                             '8110',    '0', 'Sonstige steuerfreie Umsätze Inland');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8120, 'SKR03', '8: Erlöskonten',                                             '8120',    '0', 'Steuerfreie Umsätze nach § 4 Nr. 1a UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8125, 'SKR03', '8: Erlöskonten',                                             '8125',    '0', 'Steuerfreie innergemeinschaftliche Lieferungen nach § 4 Nr. 1b UStG');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8128, 'SKR03', '8: Erlöskonten',                                             '8128',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8130, 'SKR03', '8: Erlöskonten',                                             '8130',    '0', 'Lieferungen des ersten Abnehmers bei innergemeinschaftlichen Dreiecksgeschäften § 25b Abs. 2 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8135, 'SKR03', '8: Erlöskonten',                                             '8135',    '0', 'Steuerfreie innergemeinschaftliche Lieferungen von Neufahrzeugen an Abnehmer ohne USt-Id-Nr.');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8140, 'SKR03', '8: Erlöskonten',                                             '8140',    '0', 'Steuerfreie Umsätze Offshore usw.');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8150, 'SKR03', '8: Erlöskonten',                                             '8150',    '0', 'Sonstige steuerfreie Umsätze (z. B. § 4 Nr. 2 bis 7 UStG)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8160, 'SKR03', '8: Erlöskonten',                                             '8160',    '0', 'Steuerfreie Umsätze ohne Vorsteuerabzug zum Gesamtumsatz gehörend, § 4 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8165, 'SKR03', '8: Erlöskonten',                                             '8165',    '0', 'Steuerfreie Umsätze ohne Vorsteuerabzug zum Gesamtumsatz gehörend');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8190, 'SKR03', '8: Erlöskonten',                                             '8190',    '0', 'Erlöse, die mit den Durchschnittssätzen des § 24 UStG versteuert werden');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8191, 'SKR03', '8: Erlöskonten',                                             '8191',    '0', 'Umsatzerlöse nach §§ 25 und 25a UStG 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8192, 'SKR03', '8: Erlöskonten',                                             '8192',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8193, 'SKR03', '8: Erlöskonten',                                             '8193',    '0', 'Umsatzerlöse nach §§ 25 und 25a UStG ohne USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8194, 'SKR03', '8: Erlöskonten',                                             '8194',    '0', 'Umsatzerlöse aus Reiseleistungen § 25 Abs. 2 UStG, steuerfrei');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8195, 'SKR03', '8: Erlöskonten',                                             '8195',    '0', 'Erlöse als Kleinunternehmer nach § 19 Abs. 1 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8196, 'SKR03', '8: Erlöskonten',                                             '8196',    '0', 'Erlöse aus Geldspielautomaten 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8197, 'SKR03', '8: Erlöskonten',                                             '8197',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8198, 'SKR03', '8: Erlöskonten',                                             '8198',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8200, 'SKR03', '8: Erlöskonten',                                             '8200',    '0', 'Erlöse');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8290, 'SKR03', '8: Erlöskonten',                                             '8290',    '0', 'Erlöse 0 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8300, 'SKR03', '8: Erlöskonten',                                             '8300',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8301, 'SKR03', '8: Erlöskonten',                                             '8301',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8302, 'SKR03', '8: Erlöskonten',                                             '8302',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8303, 'SKR03', '8: Erlöskonten',                                             '8303',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8304, 'SKR03', '8: Erlöskonten',                                             '8304',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8305, 'SKR03', '8: Erlöskonten',                                             '8305',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8306, 'SKR03', '8: Erlöskonten',                                             '8306',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8307, 'SKR03', '8: Erlöskonten',                                             '8307',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8308, 'SKR03', '8: Erlöskonten',                                             '8308',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8309, 'SKR03', '8: Erlöskonten',                                             '8309',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8310, 'SKR03', '8: Erlöskonten',                                             '8310',    '0', 'Erlöse aus im Inland steuerpflichtigen EU-Lieferungen 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8311, 'SKR03', '8: Erlöskonten',                                             '8311',    '0', 'Erlöse aus im Inland steuerpflichtigen EU-Lieferungen 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8312, 'SKR03', '8: Erlöskonten',                                             '8312',    '0', 'Erlöse aus im Inland steuerpflichtigen EU-Lieferungen 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8313, 'SKR03', '8: Erlöskonten',                                             '8313',    '0', 'Erlöse aus im Inland steuerpflichtigen EU-Lieferungen 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8314, 'SKR03', '8: Erlöskonten',                                             '8314',    '0', 'Erlöse aus im Inland steuerpflichtigen EU-Lieferungen 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8315, 'SKR03', '8: Erlöskonten',                                             '8315',    '0', 'Erlöse aus im Inland steuerpflichtigen EU-Lieferungen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8316, 'SKR03', '8: Erlöskonten',                                             '8316',    '0', 'Erlöse aus im Inland steuerpflichtigen EU-Lieferungen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8317, 'SKR03', '8: Erlöskonten',                                             '8317',    '0', 'Erlöse aus im Inland steuerpflichtigen EU-Lieferungen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8318, 'SKR03', '8: Erlöskonten',                                             '8318',    '0', 'Erlöse aus im Inland steuerpflichtigen EU-Lieferungen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8319, 'SKR03', '8: Erlöskonten',                                             '8319',    '0', 'Erlöse aus im Inland steuerpflichtigen EU-Lieferungen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8320, 'SKR03', '8: Erlöskonten',                                             '8320',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen Lieferungen, im Inland nicht steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8321, 'SKR03', '8: Erlöskonten',                                             '8321',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen Lieferungen, im Inland nicht steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8322, 'SKR03', '8: Erlöskonten',                                             '8322',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen Lieferungen, im Inland nicht steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8323, 'SKR03', '8: Erlöskonten',                                             '8323',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen Lieferungen, im Inland nicht steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8324, 'SKR03', '8: Erlöskonten',                                             '8324',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen Lieferungen, im Inland nicht steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8325, 'SKR03', '8: Erlöskonten',                                             '8325',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen Lieferungen, im Inland nicht steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8326, 'SKR03', '8: Erlöskonten',                                             '8326',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen Lieferungen, im Inland nicht steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8327, 'SKR03', '8: Erlöskonten',                                             '8327',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen Lieferungen, im Inland nicht steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8328, 'SKR03', '8: Erlöskonten',                                             '8328',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen Lieferungen, im Inland nicht steuerbar');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8329, 'SKR03', '8: Erlöskonten',                                             '8329',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen Lieferungen, im Inland nicht steuerbar');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8330, 'SKR03', '8: Erlöskonten',                                             '8330',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8331, 'SKR03', '8: Erlöskonten',                                             '8331',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen elektronischen Dienstleistungen');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8332, 'SKR03', '8: Erlöskonten',                                             '8332',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8333, 'SKR03', '8: Erlöskonten',                                             '8333',    '0', 'Erlöse 5 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8334, 'SKR03', '8: Erlöskonten',                                             '8334',    '0', 'Erlöse 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8335, 'SKR03', '8: Erlöskonten',                                             '8335',    '0', 'Erlöse aus Lieferungen von Mobilfunkgeräten, Tablet-Computern, Spielekonsolen und integrierten Schaltkreisen, für die der Leistungsempfänger die Umsatzsteuer nach § 13b UStG schuldet');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8336, 'SKR03', '8: Erlöskonten',                                             '8336',    '0', 'Erlöse aus im anderen EU-Land steuerpflichtigen sonstigen Leistungen, für die der Leistungsempfänger die Umsatzsteuer schuldet');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8337, 'SKR03', '8: Erlöskonten',                                             '8337',    '0', 'Erlöse aus Leistungen, für die der Leistungsempfänger die Umsatzsteuer nach § 13b UStG schuldet');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8338, 'SKR03', '8: Erlöskonten',                                             '8338',    '0', 'Erlöse aus im Drittland steuerbaren Leistungen, im Inland nicht steuerbare Umsätze');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8339, 'SKR03', '8: Erlöskonten',                                             '8339',    '0', 'Erlöse aus im anderen EU-Land steuerbaren Leistungen, im Inland nicht steuerbare Umsätze');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8340, 'SKR03', '8: Erlöskonten',                                             '8340',    '0', 'Erlöse 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8341, 'SKR03', '8: Erlöskonten',                                             '8341',    '0', 'Erlöse 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8342, 'SKR03', '8: Erlöskonten',                                             '8342',    '0', 'Erlöse 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8343, 'SKR03', '8: Erlöskonten',                                             '8343',    '0', 'Erlöse 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8344, 'SKR03', '8: Erlöskonten',                                             '8344',    '0', 'Erlöse 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8345, 'SKR03', '8: Erlöskonten',                                             '8345',    '0', 'Erlöse 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8346, 'SKR03', '8: Erlöskonten',                                             '8346',    '0', 'Erlöse 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8347, 'SKR03', '8: Erlöskonten',                                             '8347',    '0', 'Erlöse 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8348, 'SKR03', '8: Erlöskonten',                                             '8348',    '0', 'Erlöse 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8349, 'SKR03', '8: Erlöskonten',                                             '8349',    '0', 'Erlöse 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8400, 'SKR03', '8: Erlöskonten',                                             '8400',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8401, 'SKR03', '8: Erlöskonten',                                             '8401',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8402, 'SKR03', '8: Erlöskonten',                                             '8402',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8403, 'SKR03', '8: Erlöskonten',                                             '8403',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8404, 'SKR03', '8: Erlöskonten',                                             '8404',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8405, 'SKR03', '8: Erlöskonten',                                             '8405',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8406, 'SKR03', '8: Erlöskonten',                                             '8406',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8407, 'SKR03', '8: Erlöskonten',                                             '8407',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8408, 'SKR03', '8: Erlöskonten',                                             '8408',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8409, 'SKR03', '8: Erlöskonten',                                             '8409',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8410, 'SKR03', '8: Erlöskonten',                                             '8410',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8411, 'SKR03', '8: Erlöskonten',                                             '8411',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8412, 'SKR03', '8: Erlöskonten',                                             '8412',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8413, 'SKR03', '8: Erlöskonten',                                             '8413',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8414, 'SKR03', '8: Erlöskonten',                                             '8414',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8415, 'SKR03', '8: Erlöskonten',                                             '8415',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8416, 'SKR03', '8: Erlöskonten',                                             '8416',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8417, 'SKR03', '8: Erlöskonten',                                             '8417',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8418, 'SKR03', '8: Erlöskonten',                                             '8418',    '0', 'Erlöse 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8419, 'SKR03', '8: Erlöskonten',                                             '8419',    '0', 'Erlöse 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8420, 'SKR03', '8: Erlöskonten',                                             '8420',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8421, 'SKR03', '8: Erlöskonten',                                             '8421',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8422, 'SKR03', '8: Erlöskonten',                                             '8422',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8423, 'SKR03', '8: Erlöskonten',                                             '8423',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8424, 'SKR03', '8: Erlöskonten',                                             '8424',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8425, 'SKR03', '8: Erlöskonten',                                             '8425',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8426, 'SKR03', '8: Erlöskonten',                                             '8426',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8427, 'SKR03', '8: Erlöskonten',                                             '8427',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8428, 'SKR03', '8: Erlöskonten',                                             '8428',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8429, 'SKR03', '8: Erlöskonten',                                             '8429',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8430, 'SKR03', '8: Erlöskonten',                                             '8430',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8431, 'SKR03', '8: Erlöskonten',                                             '8431',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8432, 'SKR03', '8: Erlöskonten',                                             '8432',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8433, 'SKR03', '8: Erlöskonten',                                             '8433',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8434, 'SKR03', '8: Erlöskonten',                                             '8434',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8435, 'SKR03', '8: Erlöskonten',                                             '8435',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8436, 'SKR03', '8: Erlöskonten',                                             '8436',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8437, 'SKR03', '8: Erlöskonten',                                             '8437',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8438, 'SKR03', '8: Erlöskonten',                                             '8438',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8439, 'SKR03', '8: Erlöskonten',                                             '8439',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8440, 'SKR03', '8: Erlöskonten',                                             '8440',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8441, 'SKR03', '8: Erlöskonten',                                             '8441',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8442, 'SKR03', '8: Erlöskonten',                                             '8442',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8443, 'SKR03', '8: Erlöskonten',                                             '8443',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8444, 'SKR03', '8: Erlöskonten',                                             '8444',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8445, 'SKR03', '8: Erlöskonten',                                             '8445',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8446, 'SKR03', '8: Erlöskonten',                                             '8446',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8447, 'SKR03', '8: Erlöskonten',                                             '8447',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8448, 'SKR03', '8: Erlöskonten',                                             '8448',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8449, 'SKR03', '8: Erlöskonten',                                             '8449',    '0', 'Erlöse aus im Inland steuerpflichtigen elektronischen Dienstleistungen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8499, 'SKR03', '8: Erlöskonten',                                             '8499',    '0', 'Nebenerlöse (Bezug zu Materialaufwand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8500, 'SKR03', '8: Erlöskonten',                                             '8500',    '0', 'Sonderbetriebseinnahmen, Tätigkeitsvergütung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8501, 'SKR03', '8: Erlöskonten',                                             '8501',    '0', 'Sonderbetriebseinnahmen, Miet-/Pachteinnahmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8502, 'SKR03', '8: Erlöskonten',                                             '8502',    '0', 'Sonderbetriebseinnahmen, Zinseinnahmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8503, 'SKR03', '8: Erlöskonten',                                             '8503',    '0', 'Sonderbetriebseinnahmen, Haftungsvergütung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8504, 'SKR03', '8: Erlöskonten',                                             '8504',    '0', 'Sonderbetriebseinnahmen, Pensionszahlungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8505, 'SKR03', '8: Erlöskonten',                                             '8505',    '0', 'Sonderbetriebseinnahmen, sonstige Sonderbetriebseinnahmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8510, 'SKR03', '8: Erlöskonten',                                             '8510',    '0', 'Provisionsumsätze');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8511, 'SKR03', '8: Erlöskonten',                                             '8511',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8512, 'SKR03', '8: Erlöskonten',                                             '8512',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8513, 'SKR03', '8: Erlöskonten',                                             '8513',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8514, 'SKR03', '8: Erlöskonten',                                             '8514',    '0', 'Provisionsumsätze, steuerfrei § 4 Nr. 8 ff. UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8515, 'SKR03', '8: Erlöskonten',                                             '8515',    '0', 'Provisionsumsätze, steuerfrei § 4 Nr. 5 UStG');
---INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8516, 'SKR03', '8: Erlöskonten',                                             '8516',    '0', '');
---INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8517, 'SKR03', '8: Erlöskonten',                                             '8517',    '0', '');
---INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8518, 'SKR03', '8: Erlöskonten',                                             '8518',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8519, 'SKR03', '8: Erlöskonten',                                             '8519',    '0', 'Provisionsumsätze 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8520, 'SKR03', '8: Erlöskonten',                                             '8520',    '0', 'Erlöse Abfallverwertung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8540, 'SKR03', '8: Erlöskonten',                                             '8540',    '0', 'Erlöse Leergut');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8570, 'SKR03', '8: Erlöskonten',                                             '8570',    '0', 'Sonstige Erträge aus Provisionen, Lizenzen und Patenten');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8571, 'SKR03', '8: Erlöskonten',                                             '8571',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8572, 'SKR03', '8: Erlöskonten',                                             '8572',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8573, 'SKR03', '8: Erlöskonten',                                             '8573',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8574, 'SKR03', '8: Erlöskonten',                                             '8574',    '0', 'Sonstige Erträge aus Provisionen, Lizenzen und Patenten, steuerfrei § 4 Nr. 8 ff. UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8575, 'SKR03', '8: Erlöskonten',                                             '8575',    '0', 'Sonstige Erträge aus Provisionen, Lizenzen und Patenten, steuerfrei § 4 Nr. 5 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8576, 'SKR03', '8: Erlöskonten',                                             '8576',    '0', 'Sonstige Erträge aus Provisionen, Lizenzen und Patenten 7 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8577, 'SKR03', '8: Erlöskonten',                                             '8577',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8578, 'SKR03', '8: Erlöskonten',                                             '8578',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8579, 'SKR03', '8: Erlöskonten',                                             '8579',    '0', 'Sonstige Erträge aus Provisionen, Lizenzen und Patenten 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8580, 'SKR03', '8: Erlöskonten',                                             '8580',    '0', 'Statistisches Konto Erlöse zum allgemeinen Umsatzsteuersatz (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8581, 'SKR03', '8: Erlöskonten',                                             '8581',    '0', 'Statistisches Konto Erlöse zum ermäßigten Umsatzsteuersatz (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8582, 'SKR03', '8: Erlöskonten',                                             '8582',    '0', 'Statistisches Konto Erlöse steuerfrei und nicht steuerbar (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8589, 'SKR03', '8: Erlöskonten',                                             '8589',    '0', 'Gegenkonto 8580-8582 bei Aufteilung der Erlöse nach Steuersätzen (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8590, 'SKR03', '8: Erlöskonten',                                             '8590',    '0', 'Verrechnete sonstige Sachbezüge (keine Waren)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8591, 'SKR03', '8: Erlöskonten',                                             '8591',    '0', 'Sachbezüge 7 % USt (Waren)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8594, 'SKR03', '8: Erlöskonten',                                             '8594',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8595, 'SKR03', '8: Erlöskonten',                                             '8595',    '0', 'Sachbezüge 19 % USt (Waren)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8596, 'SKR03', '8: Erlöskonten',                                             '8596',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8597, 'SKR03', '8: Erlöskonten',                                             '8597',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8600, 'SKR03', '8: Erlöskonten',                                             '8600',    '0', 'Sonstige Erlöse betrieblich und regelmäßig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8603, 'SKR03', '8: Erlöskonten',                                             '8603',    '0', 'Sonstige betriebliche Erträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8604, 'SKR03', '8: Erlöskonten',                                             '8604',    '0', 'Erstattete Vorsteuer anderer Länder');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8605, 'SKR03', '8: Erlöskonten',                                             '8605',    '0', 'Sonstige Erträge betrieblich und regelmäßig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8606, 'SKR03', '8: Erlöskonten',                                             '8606',    '0', 'Sonstige betriebliche Erträge von verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8607, 'SKR03', '8: Erlöskonten',                                             '8607',    '0', 'Andere Nebenerlöse');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8609, 'SKR03', '8: Erlöskonten',                                             '8609',    '0', 'Sonstige Erträge betrieblich und regelmäßig, steuerfrei § 4 Nr. 8 ff. UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8610, 'SKR03', '8: Erlöskonten',                                             '8610',    '0', 'Verrechnete sonstige Sachbezüge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8611, 'SKR03', '8: Erlöskonten',                                             '8611',    '0', 'Verrechnete sonstige Sachbezüge aus Fahrzeug-Gestellung 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8612, 'SKR03', '8: Erlöskonten',                                             '8612',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8613, 'SKR03', '8: Erlöskonten',                                             '8613',    '0', 'Verrechnete sonstige Sachbezüge 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8614, 'SKR03', '8: Erlöskonten',                                             '8614',    '0', 'Verrechnete sonstige Sachbezüge ohne Umsatzsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8625, 'SKR03', '8: Erlöskonten',                                             '8625',    '0', 'Sonstige betriebliche Erträge, steuerfrei z. B. § 4 Nr. 2 bis 7 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8626, 'SKR03', '8: Erlöskonten',                                             '8626',    '0', 'Sonstige betriebliche Erträge, steuerfrei z. B. § 4 Nr. 2 bis 7 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8627, 'SKR03', '8: Erlöskonten',                                             '8627',    '0', 'Sonstige betriebliche Erträge, steuerfrei z. B. § 4 Nr. 2 bis 7 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8628, 'SKR03', '8: Erlöskonten',                                             '8628',    '0', 'Sonstige betriebliche Erträge, steuerfrei z. B. § 4 Nr. 2 bis 7 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8629, 'SKR03', '8: Erlöskonten',                                             '8629',    '0', 'Sonstige betriebliche Erträge, steuerfrei z. B. § 4 Nr. 2 bis 7 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8630, 'SKR03', '8: Erlöskonten',                                             '8630',    '0', 'Sonstige Erträge betrieblich und regelmäßig 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8631, 'SKR03', '8: Erlöskonten',                                             '8631',    '0', 'Sonstige Erträge betrieblich und regelmäßig 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8632, 'SKR03', '8: Erlöskonten',                                             '8632',    '0', 'Sonstige Erträge betrieblich und regelmäßig 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8633, 'SKR03', '8: Erlöskonten',                                             '8633',    '0', 'Sonstige Erträge betrieblich und regelmäßig 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8634, 'SKR03', '8: Erlöskonten',                                             '8634',    '0', 'Sonstige Erträge betrieblich und regelmäßig 7 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8635, 'SKR03', '8: Erlöskonten',                                             '8635',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8636, 'SKR03', '8: Erlöskonten',                                             '8636',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8637, 'SKR03', '8: Erlöskonten',                                             '8637',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8638, 'SKR03', '8: Erlöskonten',                                             '8638',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8639, 'SKR03', '8: Erlöskonten',                                             '8639',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8640, 'SKR03', '8: Erlöskonten',                                             '8640',    '0', 'Sonstige Erträge betrieblich und regelmäßig 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8641, 'SKR03', '8: Erlöskonten',                                             '8641',    '0', 'Sonstige Erträge betrieblich und regelmäßig 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8642, 'SKR03', '8: Erlöskonten',                                             '8642',    '0', 'Sonstige Erträge betrieblich und regelmäßig 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8643, 'SKR03', '8: Erlöskonten',                                             '8643',    '0', 'Sonstige Erträge betrieblich und regelmäßig 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8644, 'SKR03', '8: Erlöskonten',                                             '8644',    '0', 'Sonstige Erträge betrieblich und regelmäßig 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8645, 'SKR03', '8: Erlöskonten',                                             '8645',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8646, 'SKR03', '8: Erlöskonten',                                             '8646',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8647, 'SKR03', '8: Erlöskonten',                                             '8647',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8648, 'SKR03', '8: Erlöskonten',                                             '8648',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8649, 'SKR03', '8: Erlöskonten',                                             '8649',    '0', 'Sonstige Erträge betrieblich und regelmäßig 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8650, 'SKR03', '8: Erlöskonten',                                             '8650',    '0', 'Erlöse Zinsen und Diskontspesen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8660, 'SKR03', '8: Erlöskonten',                                             '8660',    '0', 'Erlöse Zinsen und Diskontspesen aus verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8700, 'SKR03', '8: Erlöskonten',                                             '8700',    '0', 'Erlösschmälerungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8701, 'SKR03', '8: Erlöskonten',                                             '8701',    '0', 'Erlösschmälerungen für steuerfreie Umsätze nach § 4 Nr. 8 ff. UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8702, 'SKR03', '8: Erlöskonten',                                             '8702',    '0', 'Erlösschmälerungen für steuerfreie Umsätze nach § 4 Nr. 2 bis 7 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8703, 'SKR03', '8: Erlöskonten',                                             '8703',    '0', 'Erlösschmälerungen für sonstige steuerfreie Umsätze ohne Vorsteuerabzug');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8704, 'SKR03', '8: Erlöskonten',                                             '8704',    '0', 'Erlösschmälerungen für sonstige steuerfreie Umsätze mit Vorsteuerabzug');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8705, 'SKR03', '8: Erlöskonten',                                             '8705',    '0', 'Erlösschmälerungen aus steuerfreien Umsätzen § 4 Nr. 1a UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8706, 'SKR03', '8: Erlöskonten',                                             '8706',    '0', 'Erlösschmälerungen für steuerfreie innergemeinschaftliche Dreiecksgeschäfte nach § 25b Abs. 2 und 4 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8710, 'SKR03', '8: Erlöskonten',                                             '8710',    '0', 'Erlösschmälerungen 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8711, 'SKR03', '8: Erlöskonten',                                             '8711',    '0', 'Erlösschmälerungen 7 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8712, 'SKR03', '8: Erlöskonten',                                             '8712',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8713, 'SKR03', '8: Erlöskonten',                                             '8713',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8714, 'SKR03', '8: Erlöskonten',                                             '8714',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8715, 'SKR03', '8: Erlöskonten',                                             '8715',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8716, 'SKR03', '8: Erlöskonten',                                             '8716',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8717, 'SKR03', '8: Erlöskonten',                                             '8717',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8718, 'SKR03', '8: Erlöskonten',                                             '8718',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8719, 'SKR03', '8: Erlöskonten',                                             '8719',    '0', 'Erlösschmälerungen 0 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8720, 'SKR03', '8: Erlöskonten',                                             '8720',    '0', 'Erlösschmälerungen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8721, 'SKR03', '8: Erlöskonten',                                             '8721',    '0', 'Erlösschmälerungen 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8722, 'SKR03', '8: Erlöskonten',                                             '8722',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8723, 'SKR03', '8: Erlöskonten',                                             '8723',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8724, 'SKR03', '8: Erlöskonten',                                             '8724',    '0', 'Erlösschmälerungen aus steuerfreien innergemeinschaftlichen Lieferungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8725, 'SKR03', '8: Erlöskonten',                                             '8725',    '0', 'Erlösschmälerungen aus im Inland steuerpflichtigen EU-Lieferungen 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8726, 'SKR03', '8: Erlöskonten',                                             '8726',    '0', 'Erlösschmälerungen aus im Inland steuerpflichtigen EU-Lieferungen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8727, 'SKR03', '8: Erlöskonten',                                             '8727',    '0', 'Erlösschmälerungen aus im anderen EU-Land steuerpflichtigen Lieferungen');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8728, 'SKR03', '8: Erlöskonten',                                             '8728',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8729, 'SKR03', '8: Erlöskonten',                                             '8729',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8730, 'SKR03', '8: Erlöskonten',                                             '8730',    '0', 'Gewährte Skonti');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8731, 'SKR03', '8: Erlöskonten',                                             '8731',    '0', 'Gewährte Skonti 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8732, 'SKR03', '8: Erlöskonten',                                             '8732',    '0', 'Gewährte Skonti 5 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8733, 'SKR03', '8: Erlöskonten',                                             '8733',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8734, 'SKR03', '8: Erlöskonten',                                             '8734',    '0', 'Gewährte Skonti 0 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8735, 'SKR03', '8: Erlöskonten',                                             '8735',    '0', 'Gewährte Skonti 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8736, 'SKR03', '8: Erlöskonten',                                             '8736',    '0', 'Gewährte Skonti 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8737, 'SKR03', '8: Erlöskonten',                                             '8737',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8738, 'SKR03', '8: Erlöskonten',                                             '8738',    '0', 'Gewährte Skonti aus Lieferungen von Mobilfunkgeräten etc., für die der Leistungsempfänger die Umsatzsteuer nach § 13b Abs. 2 Nr. 10 UStG schuldet');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8741, 'SKR03', '8: Erlöskonten',                                             '8741',    '0', 'Gewährte Skonti aus Leistungen, für die der Leistungsempfänger die Umsatzsteuer nach § 13b UStG schuldet');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8742, 'SKR03', '8: Erlöskonten',                                             '8742',    '0', 'Gewährte Skonti aus Erlösen aus im anderen EU-Land steuerpflichtigen sonstigen Leistungen, für die der Leistungsempfänger die Umsatzsteuer schuldet');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8743, 'SKR03', '8: Erlöskonten',                                             '8743',    '0', 'Gewährte Skonti aus steuerfreien innergemeinschaftlichen Lieferungen § 4 Nr. 1b UStG');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8744, 'SKR03', '8: Erlöskonten',                                             '8744',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8745, 'SKR03', '8: Erlöskonten',                                             '8745',    '0', 'Gewährte Skonti aus im Inland steuerpflichtigen EU-Lieferungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8746, 'SKR03', '8: Erlöskonten',                                             '8746',    '0', 'Gewährte Skonti aus im Inland steuerpflichtigen EU-Lieferungen 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8747, 'SKR03', '8: Erlöskonten',                                             '8747',    '0', 'Gewährte Skonti aus im Inland steuerpflichtigen EU-Lieferungen 5 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8748, 'SKR03', '8: Erlöskonten',                                             '8748',    '0', 'Gewährte Skonti aus im Inland steuerpflichtigen EU-Lieferungen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8749, 'SKR03', '8: Erlöskonten',                                             '8749',    '0', 'Gewährte Skonti aus im Inland steuerpflichtigen EU-Lieferungen 16 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8750, 'SKR03', '8: Erlöskonten',                                             '8750',    '0', 'Gewährte Boni 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8751, 'SKR03', '8: Erlöskonten',                                             '8751',    '0', 'Gewährte Boni 7 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8752, 'SKR03', '8: Erlöskonten',                                             '8752',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8753, 'SKR03', '8: Erlöskonten',                                             '8753',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8754, 'SKR03', '8: Erlöskonten',                                             '8754',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8755, 'SKR03', '8: Erlöskonten',                                             '8755',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8756, 'SKR03', '8: Erlöskonten',                                             '8756',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8757, 'SKR03', '8: Erlöskonten',                                             '8757',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8758, 'SKR03', '8: Erlöskonten',                                             '8758',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8759, 'SKR03', '8: Erlöskonten',                                             '8759',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8760, 'SKR03', '8: Erlöskonten',                                             '8760',    '0', 'Gewährte Boni 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8761, 'SKR03', '8: Erlöskonten',                                             '8761',    '0', 'Gewährte Boni 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8762, 'SKR03', '8: Erlöskonten',                                             '8762',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8763, 'SKR03', '8: Erlöskonten',                                             '8763',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8764, 'SKR03', '8: Erlöskonten',                                             '8764',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8765, 'SKR03', '8: Erlöskonten',                                             '8765',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8766, 'SKR03', '8: Erlöskonten',                                             '8766',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8767, 'SKR03', '8: Erlöskonten',                                             '8767',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8768, 'SKR03', '8: Erlöskonten',                                             '8768',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8769, 'SKR03', '8: Erlöskonten',                                             '8769',    '0', 'Gewährte Boni');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8770, 'SKR03', '8: Erlöskonten',                                             '8770',    '0', 'Gewährte Rabatte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8780, 'SKR03', '8: Erlöskonten',                                             '8780',    '0', 'Gewährte Rabatte 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8781, 'SKR03', '8: Erlöskonten',                                             '8781',    '0', 'Gewährte Rabatte 7 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8782, 'SKR03', '8: Erlöskonten',                                             '8782',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8783, 'SKR03', '8: Erlöskonten',                                             '8783',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8784, 'SKR03', '8: Erlöskonten',                                             '8784',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8785, 'SKR03', '8: Erlöskonten',                                             '8785',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8786, 'SKR03', '8: Erlöskonten',                                             '8786',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8787, 'SKR03', '8: Erlöskonten',                                             '8787',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8788, 'SKR03', '8: Erlöskonten',                                             '8788',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8789, 'SKR03', '8: Erlöskonten',                                             '8789',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8790, 'SKR03', '8: Erlöskonten',                                             '8790',    '0', 'Gewährte Rabatte 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8791, 'SKR03', '8: Erlöskonten',                                             '8791',    '0', 'Gewährte Rabatte 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8792, 'SKR03', '8: Erlöskonten',                                             '8792',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8793, 'SKR03', '8: Erlöskonten',                                             '8793',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8794, 'SKR03', '8: Erlöskonten',                                             '8794',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8795, 'SKR03', '8: Erlöskonten',                                             '8795',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8796, 'SKR03', '8: Erlöskonten',                                             '8796',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8797, 'SKR03', '8: Erlöskonten',                                             '8797',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8798, 'SKR03', '8: Erlöskonten',                                             '8798',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8799, 'SKR03', '8: Erlöskonten',                                             '8799',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8800, 'SKR03', '8: Erlöskonten',                                             '8800',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8801, 'SKR03', '8: Erlöskonten',                                             '8801',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8802, 'SKR03', '8: Erlöskonten',                                             '8802',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8803, 'SKR03', '8: Erlöskonten',                                             '8803',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8804, 'SKR03', '8: Erlöskonten',                                             '8804',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8805, 'SKR03', '8: Erlöskonten',                                             '8805',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8806, 'SKR03', '8: Erlöskonten',                                             '8806',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8807, 'SKR03', '8: Erlöskonten',                                             '8807',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen steuerfrei § 4 Nr. 1a UStG (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8808, 'SKR03', '8: Erlöskonten',                                             '8808',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen steuerfrei § 4 Nr. 1b UStG (bei Buchverlust)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8809, 'SKR03', '8: Erlöskonten',                                             '8809',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8810, 'SKR03', '8: Erlöskonten',                                             '8810',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8811, 'SKR03', '8: Erlöskonten',                                             '8811',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8812, 'SKR03', '8: Erlöskonten',                                             '8812',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8813, 'SKR03', '8: Erlöskonten',                                             '8813',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8814, 'SKR03', '8: Erlöskonten',                                             '8814',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8815, 'SKR03', '8: Erlöskonten',                                             '8815',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8816, 'SKR03', '8: Erlöskonten',                                             '8816',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8817, 'SKR03', '8: Erlöskonten',                                             '8817',    '0', 'Erlöse aus Verkäufen immaterieller Vermögensgegenstände (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8818, 'SKR03', '8: Erlöskonten',                                             '8818',    '0', 'Erlöse aus Verkäufen Finanzanlagen (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8819, 'SKR03', '8: Erlöskonten',                                             '8819',    '0', 'Erlöse aus Verkäufen Finanzanlagen § 3 Nr. 40 EStG bzw. § 8b Abs. 3 KStG (bei Buchverlust)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8820, 'SKR03', '8: Erlöskonten',                                             '8820',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8821, 'SKR03', '8: Erlöskonten',                                             '8821',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8822, 'SKR03', '8: Erlöskonten',                                             '8822',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8823, 'SKR03', '8: Erlöskonten',                                             '8823',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8824, 'SKR03', '8: Erlöskonten',                                             '8824',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8825, 'SKR03', '8: Erlöskonten',                                             '8825',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen 19 % USt (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8826, 'SKR03', '8: Erlöskonten',                                             '8826',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8827, 'SKR03', '8: Erlöskonten',                                             '8827',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen steuerfrei § 4 Nr. 1a UStG (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8828, 'SKR03', '8: Erlöskonten',                                             '8828',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen steuerfrei § 4 Nr. 1b UStG (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8829, 'SKR03', '8: Erlöskonten',                                             '8829',    '0', 'Erlöse aus Verkäufen Sachanlagevermögen (bei Buchgewinn)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8830, 'SKR03', '8: Erlöskonten',                                             '8830',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8831, 'SKR03', '8: Erlöskonten',                                             '8831',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8832, 'SKR03', '8: Erlöskonten',                                             '8832',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8833, 'SKR03', '8: Erlöskonten',                                             '8833',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8834, 'SKR03', '8: Erlöskonten',                                             '8834',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8835, 'SKR03', '8: Erlöskonten',                                             '8835',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8836, 'SKR03', '8: Erlöskonten',                                             '8836',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8837, 'SKR03', '8: Erlöskonten',                                             '8837',    '0', 'Erlöse aus Verkäufen immaterieller Vermögensgegenstände (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8838, 'SKR03', '8: Erlöskonten',                                             '8838',    '0', 'Erlöse aus Verkäufen Finanzanlagen (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8839, 'SKR03', '8: Erlöskonten',                                             '8839',    '0', 'Erlöse aus Verkäufen Finanzanlagen § 3 Nr. 40 EStG bzw. § 8b Abs. 2 KStG (bei Buchgewinn)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8850, 'SKR03', '8: Erlöskonten',                                             '8850',    '0', 'Erlöse aus Verkäufen von Wirtschaftsgütern des Umlaufvermögens 19 % USt für § 4 Abs. 3 Satz 4 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8851, 'SKR03', '8: Erlöskonten',                                             '8851',    '0', 'Erlöse aus Verkäufen von Wirtschaftsgütern des Umlaufvermögens, umsatzsteuerfrei § 4 Nr. 8 ff. UStG i. V. m. § 4 Abs. 3 Satz 4 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8852, 'SKR03', '8: Erlöskonten',                                             '8852',    '0', 'Erlöse aus Verkäufen von Wirtschaftsgütern des Umlaufvermögens, umsatzsteuerfrei § 4 Nr. 8 ff. UStG i. V. m. § 4 Abs. 3 Satz 4 EStG und § 3 Nr. 40 EStG bzw. § 8b Abs. 2 KStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8853, 'SKR03', '8: Erlöskonten',                                             '8853',    '0', 'Erlöse aus Verkäufen von Wirtschaftsgütern des Umlaufvermögens nach § 4 Abs 3 Satz 4 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8900, 'SKR03', '8: Erlöskonten',                                             '8900',    '0', 'Unentgeltliche Wertabgaben');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8905, 'SKR03', '8: Erlöskonten',                                             '8905',    '0', 'Entnahme von Gegenständen ohne USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8906, 'SKR03', '8: Erlöskonten',                                             '8906',    '0', 'Verwendung von Gegenständen für Zwecke außerhalb des Unternehmens ohne USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8908, 'SKR03', '8: Erlöskonten',                                             '8908',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8909, 'SKR03', '8: Erlöskonten',                                             '8909',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8910, 'SKR03', '8: Erlöskonten',                                             '8910',    '0', 'Entnahme durch den Unternehmer für Zwecke außerhalb des Unternehmens (Waren) 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8911, 'SKR03', '8: Erlöskonten',                                             '8911',    '0', 'Entnahme durch den Unternehmer für Zwecke außerhalb des Unternehmens (Waren) 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8912, 'SKR03', '8: Erlöskonten',                                             '8912',    '0', 'Entnahme durch den Unternehmer für Zwecke außerhalb des Unternehmens (Waren) 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8913, 'SKR03', '8: Erlöskonten',                                             '8913',    '0', 'Entnahme durch den Unternehmer für Zwecke außerhalb des Unternehmens (Waren) 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8914, 'SKR03', '8: Erlöskonten',                                             '8914',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8915, 'SKR03', '8: Erlöskonten',                                             '8915',    '0', 'Entnahme durch den Unternehmer für Zwecke außerhalb des Unternehmens (Waren) 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8916, 'SKR03', '8: Erlöskonten',                                             '8916',    '0', 'Entnahme durch den Unternehmer für Zwecke außerhalb des Unternehmens (Waren) 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8917, 'SKR03', '8: Erlöskonten',                                             '8917',    '0', 'Entnahme durch den Unternehmer für Zwecke außerhalb des Unternehmens (Waren) 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8918, 'SKR03', '8: Erlöskonten',                                             '8918',    '0', 'Verwendung von Gegenständen für Zwecke außerhalb des Unternehmens ohne USt (Telefon-Nutzung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8919, 'SKR03', '8: Erlöskonten',                                             '8919',    '0', 'Entnahme durch den Unternehmer für Zwecke außerhalb des Unternehmens (Waren) ohne USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8920, 'SKR03', '8: Erlöskonten',                                             '8920',    '0', 'Verwendung von Gegenständen für Zwecke außerhalb des Unternehmens 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8921, 'SKR03', '8: Erlöskonten',                                             '8921',    '0', 'Verwendung von Gegenständen für Zwecke außerhalb des Unternehmens 19 % USt (Fahrzeug-Nutzung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8922, 'SKR03', '8: Erlöskonten',                                             '8922',    '0', 'Verwendung von Gegenständen für Zwecke außerhalb des Unternehmens 19 % USt (Telefon-Nutzung)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8923, 'SKR03', '8: Erlöskonten',                                             '8923',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8924, 'SKR03', '8: Erlöskonten',                                             '8924',    '0', 'Verwendung von Gegenständen für Zwecke außerhalb des Unternehmens ohne USt (Fahrzeug-Nutzung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8925, 'SKR03', '8: Erlöskonten',                                             '8925',    '0', 'Unentgeltliche Erbringung einer sonstigen Leistung 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8926, 'SKR03', '8: Erlöskonten',                                             '8926',    '0', 'Unentgeltliche Erbringung einer sonstigen Leistung 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8927, 'SKR03', '8: Erlöskonten',                                             '8927',    '0', 'Unentgeltliche Erbringung einer sonstigen Leistung 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8928, 'SKR03', '8: Erlöskonten',                                             '8928',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8929, 'SKR03', '8: Erlöskonten',                                             '8929',    '0', 'Unentgeltliche Erbringung einer sonstigen Leistung ohne USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8930, 'SKR03', '8: Erlöskonten',                                             '8930',    '0', 'Verwendung von Gegenständen für Zwecke außerhalb des Unternehmens 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8931, 'SKR03', '8: Erlöskonten',                                             '8931',    '0', 'Verwendung von Gegenständen für Zwecke außerhalb des Unternehmens 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8932, 'SKR03', '8: Erlöskonten',                                             '8932',    '0', 'Unentgeltliche Erbringung einer sonstigen Leistung 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8933, 'SKR03', '8: Erlöskonten',                                             '8933',    '0', 'Unentgeltliche Erbringung einer sonstigen Leistung 7 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8934, 'SKR03', '8: Erlöskonten',                                             '8934',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8935, 'SKR03', '8: Erlöskonten',                                             '8935',    '0', 'Unentgeltliche Zuwendung von Gegenständen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8936, 'SKR03', '8: Erlöskonten',                                             '8936',    '0', 'Unentgeltliche Zuwendung von Gegenständen 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8937, 'SKR03', '8: Erlöskonten',                                             '8937',    '0', 'Unentgeltliche Zuwendung von Gegenständen 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8938, 'SKR03', '8: Erlöskonten',                                             '8938',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8939, 'SKR03', '8: Erlöskonten',                                             '8939',    '0', 'Unentgeltliche Zuwendung von Gegenständen ohne USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8940, 'SKR03', '8: Erlöskonten',                                             '8940',    '0', 'Unentgeltliche Zuwendung von Waren 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8941, 'SKR03', '8: Erlöskonten',                                             '8941',    '0', 'Unentgeltliche Zuwendung von Waren 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8942, 'SKR03', '8: Erlöskonten',                                             '8942',    '0', 'Unentgeltliche Zuwendung von Waren 19 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8943, 'SKR03', '8: Erlöskonten',                                             '8943',    '0', 'Unentgeltliche Zuwendung von Waren 19 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8944, 'SKR03', '8: Erlöskonten',                                             '8944',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8945, 'SKR03', '8: Erlöskonten',                                             '8945',    '0', 'Unentgeltliche Zuwendung von Waren 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8946, 'SKR03', '8: Erlöskonten',                                             '8946',    '0', 'Unentgeltliche Zuwendung von Waren 7 % USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8947, 'SKR03', '8: Erlöskonten',                                             '8947',    '0', 'Unentgeltliche Zuwendung von Waren 7 % USt');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8948, 'SKR03', '8: Erlöskonten',                                             '8948',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8949, 'SKR03', '8: Erlöskonten',                                             '8949',    '0', 'Unentgeltliche Zuwendung von Waren ohne USt');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8950, 'SKR03', '8: Erlöskonten',                                             '8950',    '0', 'Nicht steuerbare Umsätze (Innenumsätze)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8955, 'SKR03', '8: Erlöskonten',                                             '8955',    '0', 'Umsatzsteuervergütungen, z. B. nach § 24 UStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8959, 'SKR03', '8: Erlöskonten',                                             '8959',    '0', 'Direkt mit dem Umsatz verbundene Steuern');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8960, 'SKR03', '8: Erlöskonten',                                             '8960',    '0', 'Bestandsveränderungen - unfertige Erzeugnisse');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8970, 'SKR03', '8: Erlöskonten',                                             '8970',    '0', 'Bestandsveränderungen - unfertige Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8975, 'SKR03', '8: Erlöskonten',                                             '8975',    '0', 'Bestandsveränderungen - in Ausführung befindliche Bauaufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8977, 'SKR03', '8: Erlöskonten',                                             '8977',    '0', 'Bestandsveränderungen - in Arbeit befindliche Aufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8980, 'SKR03', '8: Erlöskonten',                                             '8980',    '0', 'Bestandsveränderungen - fertige Erzeugnisse');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8990, 'SKR03', '8: Erlöskonten',                                             '8990',    '0', 'Andere aktivierte Eigenleistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8994, 'SKR03', '8: Erlöskonten',                                             '8994', '8990', 'Aktivierte Eigenleistungen (den Herstellungskosten zurechenbare Fremdkapitalzinsen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 8995, 'SKR03', '8: Erlöskonten',                                             '8995', '8990', 'Aktivierte Eigenleistungen zur Erstellung von selbst geschaffenen immateriellen Vermögensgegenständen');
---- 9: Vortrags-, Kapital-, Korrektur- und statistische Konten
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9000, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9000',    '0', 'Saldenvorträge, Sachkonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9001, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9001',    '0', 'Saldenvorträge, Sachkonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9002, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9002',    '0', 'Saldenvorträge, Sachkonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9003, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9003',    '0', 'Saldenvorträge, Sachkonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9004, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9004',    '0', 'Saldenvorträge, Sachkonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9005, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9005',    '0', 'Saldenvorträge, Sachkonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9006, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9006',    '0', 'Saldenvorträge, Sachkonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9007, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9007',    '0', 'Saldenvorträge, Sachkonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9008, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9008',    '0', 'Saldenvorträge, Debitoren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9009, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9009',    '0', 'Saldenvorträge, Kreditoren');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9050, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9050',    '0', 'Offene Posten aus 2020');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9051, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9051',    '0', 'Offene Posten aus 2021');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9052, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9052',    '0', 'Offene Posten aus 2022');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9053, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9053',    '0', 'Offene Posten aus 2023');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9054, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9054',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9055, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9055',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9056, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9056',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9057, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9057',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9058, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9058',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9059, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9059',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9060, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9060',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9061, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9061',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9062, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9062',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9063, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9063',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9064, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9064',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9065, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9065',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9066, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9066',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9067, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9067',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9068, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9068',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9069, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9069',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9070, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9070',    '0', 'Offene Posten aus 2000');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9071, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9071',    '0', 'Offene Posten aus 2001');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9072, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9072',    '0', 'Offene Posten aus 2002');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9073, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9073',    '0', 'Offene Posten aus 2003');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9074, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9074',    '0', 'Offene Posten aus 2004');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9075, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9075',    '0', 'Offene Posten aus 2005');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9076, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9076',    '0', 'Offene Posten aus 2006');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9077, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9077',    '0', 'Offene Posten aus 2007');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9078, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9078',    '0', 'Offene Posten aus 2008');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9079, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9079',    '0', 'Offene Posten aus 2009');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9080, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9080',    '0', 'Offene Posten aus 2010');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9081, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9081',    '0', 'Offene Posten aus 2011');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9082, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9082',    '0', 'Offene Posten aus 2012');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9083, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9083',    '0', 'Offene Posten aus 2013');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9084, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9084',    '0', 'Offene Posten aus 2014');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9085, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9085',    '0', 'Offene Posten aus 2015');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9086, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9086',    '0', 'Offene Posten aus 2016');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9087, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9087',    '0', 'Offene Posten aus 2017');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9088, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9088',    '0', 'Offene Posten aus 2018');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9089, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9089',    '0', 'Offene Posten aus 2019');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9090, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9090',    '0', 'Summenvortragskonto');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9091, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9091', '9090', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9092, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9092', '9090', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9093, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9093', '9090', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9094, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9094', '9090', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9095, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9095', '9090', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9096, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9096', '9090', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9097, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9097', '9090', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9098, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9098', '9090', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9099, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9099', '9090', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9100, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9100', '9090', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9101, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9101',    '0', 'Verkaufstage');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9102, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9102',    '0', 'Anzahl der Barkunden');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9103, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9103',    '0', 'Beschäftigte Personen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9104, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9104',    '0', 'Unbezahlte Personen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9105, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9105',    '0', 'Verkaufskräfte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9106, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9106',    '0', 'Geschäftsraum qm');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9107, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9107',    '0', 'Verkaufsraum qm');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9116, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9116',    '0', 'Anzahl Rechnungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9117, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9117',    '0', 'Anzahl Kreditkunden monatlich');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9118, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9118',    '0', 'Anzahl Kreditkunden aufgelaufen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9120, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9120',    '0', 'Erweiterungsinvestitionen');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9130, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9130',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9131, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9131',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9135, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9135',    '0', 'Auftragseingang im Geschäftsjahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9140, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9140',    '0', 'Auftragsbestand');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9141, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9141',    '0', 'Variables Kapital TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9142, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9142',    '0', 'Variables Kapital - Anteil Teilhafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9143, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9143',    '0', 'Privatsteuern Kapitalertragsteuer (Sammelposten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9144, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9144',    '0', 'Privatsteuern Solidaritätszuschlag (Sammelposten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9145, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9145',    '0', 'Privatsteuern Kirchensteuer (Sammelposten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9146, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9146',    '0', 'Variables Kapital Vollhafter - Übertragung einer § 6b EStG-Rücklage');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9147, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9147',    '0', 'Variables Kapital Teilhafter - Übertragung einer § 6b EStG-Rücklage');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9148, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9148',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9149, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9149',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9150, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9150',    '0', 'Festkapital - andere Kapitalkontenanpassungen VH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9151, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9151',    '0', 'Variables Kapital - andere Kapitalkontenanpassungen VH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9152, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9152',    '0', 'Verlust-/Vortragskonto - andere Kapitalkontenanpassungen VH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9153, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9153',    '0', 'Kapitalkonto III - andere Kapitalkontenanpassungen VH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9154, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9154',    '0', 'Ausstehende Einlagen auf das Komplementär-Kapital, nicht eingefordert - andere Kapitalkontenanpassungen VH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9155, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9155',    '0', 'Verrechnungskonto für Einzahlungsverpflichtungen - andere Kapitalkontenanpassungen VH');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9156, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9156',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9157, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9157',    '0', 'Privatsteuern Kapitalertragsteuer (VH)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9158, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9158',    '0', 'Privatsteuern Solidaritätszuschlag (VH)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9159, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9159',    '0', 'Privatsteuern Kirchensteuer (VH)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9160, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9160',    '0', 'Kommandit-Kapital - andere Kapitalkontenanpassungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9161, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9161',    '0', 'Variables Kapital - andere Kapitalkontenanpassungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9162, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9162',    '0', 'Verlustausgleichskonto - andere Kapitalkontenanpassungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9163, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9163',    '0', 'Kapitalkonto III - andere Kapitalkontenanpassungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9164, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9164',    '0', 'Ausstehende Einlagen auf das Kommandit-Kapital, nicht eingefordert - andere Kapitalkontenanpassungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9165, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9165',    '0', 'Verrechnungskonto für Einzahlungsverpflichtungen - andere Kapitalkontenanpassungen TH');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9166, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9166',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9167, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9167',    '0', 'Privatsteuern Kapitalertragsteuer (TH), EK');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9168, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9168',    '0', 'Privatsteuern Solidaritätszuschlag (TH), EK');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9169, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9169',    '0', 'Privatsteuern Kirchensteuer (TH), EK');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9170, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9170',    '0', 'Festkapital - Umbuchungen VH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9171, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9171',    '0', 'Variables Kapital - Umbuchungen VH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9172, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9172',    '0', 'Verlust-/Vortragskonto - Umbuchungen VH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9173, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9173',    '0', 'Kapitalkonto III - Umbuchungen VH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9174, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9174',    '0', 'Ausstehende Einlagen auf das Komplementär-Kapital, nicht eingefordert - Umbuchungen VH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9175, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9175',    '0', 'Verrechnungskonto für Einzahlungsverpflichtungen - Umbuchungen VH');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9176, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9176',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9177, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9177',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9178, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9178',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9179, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9179',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9180, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9180',    '0', 'Kommandit-Kapital - Umbuchungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9181, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9181',    '0', 'Variables Kapital - Umbuchungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9182, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9182',    '0', 'Verlustausgleichskonto - Umbuchungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9183, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9183',    '0', 'Kapitalkonto III - Umbuchungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9184, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9184',    '0', 'Ausstehende Einlagen auf das Kommandit-Kapital, nicht eingefordert - Umbuchungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9185, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9185',    '0', 'Verrechnungskonto für Einzahlungsverpflichtungen - Umbuchungen TH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9186, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9186',    '0', 'Privatsteuern Kapitalertragsteuer (TH), FK');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9187, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9187',    '0', 'Privatsteuern Solidaritätszuschlag (TH), FK');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9188, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9188',    '0', 'Privatsteuern Kirchensteuer (TH), FK');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9189, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9189',    '0', 'Verrechnungskonto für Umbuchungen zwischen Gesellschafter-Eigenkapitalkonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9190, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9190',    '0', 'Gegenkonto für statistische Mengeneinheiten Konten 9101-9107 und Konten 9116-9118');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9199, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9199',    '0', 'Gegenkonto zu Konten 9120, 9135-9140');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9200, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9200',    '0', 'Beschäftigte Personen');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9201, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9201',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9202, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9202',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9203, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9203',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9204, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9204',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9205, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9205',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9206, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9206',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9207, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9207',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9208, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9208',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9209, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9209',    '0', 'Gegenkonto zu 9200');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9210, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9210',    '0', 'Produktive Löhne');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9219, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9219',    '0', 'Gegenkonto zu 9210');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9220, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9220',    '0', 'Gezeichnetes Kapital in DM (Art. 42 Abs. 3 Satz 1 EGHGB)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9221, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9221',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9229, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9229',    '0', 'Gegenkonto zu 9220');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9240, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9240',    '0', 'Investitionsverbindlichkeiten bei den Leistungsverbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9241, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9241',    '0', 'Investitionsverbindlichkeiten aus Sachanlagekäufen bei Leistungsverbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9242, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9242',    '0', 'Investitionsverbindlichkeiten aus Käufen von immateriellen Vermögensgegenständen bei Leistungsverbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9243, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9243',    '0', 'Investitionsverbindlichkeiten aus Käufen von Finanzanlagen bei Leistungsverbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9244, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9244',    '0', 'Gegenkonto zu Konten 9240-9243');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9245, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9245',    '0', 'Forderungen aus Sachanlageverkäufen bei sonstigen Vermögensgegenständen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9246, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9246',    '0', 'Forderungen aus Verkäufen immaterieller Vermögensgegenstände bei sonstigen Vermögensgegenständen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9247, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9247',    '0', 'Forderungen aus Verkäufen von Finanzanlagen bei sonstigen Vermögensgegenständen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9249, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9249',    '0', 'Gegenkonto zu Konten 9245-9247');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9258, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9258',    '0', 'Änderung steuerlicher Ausgleichsposten (ohne Ergebnisverwendung – Körperschaften)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9259, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9259',    '0', 'Änderung steuerlicher Ausgleichsposten (ohne Ergebnisverwendung - Personengesellschaften, Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9260, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9260',    '0', 'Kurzfristige Rückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9262, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9262',    '0', 'Mittelfristige Rückstellungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9264, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9264',    '0', 'Langfristige Rückstellungen, außer Pensionen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9269, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9269',    '0', 'Gegenkonto zu Konten 9260-9268');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9270, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9270',    '0', 'Gegenkonto zu 9271-9279 (Soll-Buchung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9271, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9271',    '0', 'Verbindlichkeiten aus der Begebung und Übertragung von Wechseln');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9272, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9272',    '0', 'Verbindlichkeiten aus der Begebung und Übertragung von Wechseln gegenüber verbundenen/assoziierten Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9273, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9273',    '0', 'Verbindlichkeiten aus Bürgschaften, Wechsel- und Scheckbürgschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9274, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9274',    '0', 'Verbindlichkeiten aus Bürgschaften, Wechsel- und Scheckbürgschaften gegenüber verbundenen/assoziierten Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9275, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9275',    '0', 'Verbindlichkeiten aus Gewährleistungsverträgen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9276, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9276',    '0', 'Verbindlichkeiten aus Gewährleistungsverträgen gegenüber verbundenen/assoziierten Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9277, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9277',    '0', 'Haftung aus der Bestellung von Sicherheiten für fremde Verbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9278, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9278',    '0', 'Haftung aus der Bestellung von Sicherheiten für fremde Verbindlichkeiten gegenüber verbundenen/assoziierten Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9279, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9279',    '0', 'Verpflichtungen aus Treuhandvermögen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9280, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9280',    '0', 'Gegenkonto zu 9281-9284');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9281, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9281',    '0', 'Verpflichtungen aus Miet- und Leasingverträgen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9282, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9282',    '0', 'Verpflichtungen aus Miet- und Leasingverträgen gegenüber verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9283, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9283',    '0', 'Andere Verpflichtungen nach § 285 Nr. 3a HGB');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9284, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9284',    '0', 'Andere Verpflichtungen nach § 285 Nr. 3a HGB gegenüber verbundenen Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9285, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9285',    '0', 'Unterschiedsbetrag aus der Abzinsung von Altersversorgungsverpflichtungen nach § 253 Abs. 6 HGB (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9286, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9286',    '0', 'Gegenkonto zu 9285');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9287, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9287',    '0', 'Zinsen bei Buchungen über Debitoren bei § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9288, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9288',    '0', 'Mahngebühren bei Buchungen über Debitoren bei § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9289, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9289',    '0', 'Gegenkonto zu 9287 und 9288');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9290, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9290',    '0', 'Statistisches Konto steuerfreie Auslagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9291, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9291',    '0', 'Gegenkonto zu 9290');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9292, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9292',    '0', 'Statistisches Konto Fremdgeld');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9293, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9293',    '0', 'Gegenkonto zu 9292');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9295, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9295',    '0', 'Einlagen atypisch stiller Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9297, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9297',    '0', 'Steuerlicher Ausgleichsposten (Körperschaften)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9298, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9298',    '0', 'Steuerlicher Ausgleichsposten VH (Personengesellschaften, Einzelunternehmen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9299, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9299',    '0', 'Steuerlicher Ausgleichsposten TH (Personengesellschaften)');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9300, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9300',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9301, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9301',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9302, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9302',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9303, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9303',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9304, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9304',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9305, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9305',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9306, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9306',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9307, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9307',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9308, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9308',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9309, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9309',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9310, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9310',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9311, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9311',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9312, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9312',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9313, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9313',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9314, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9314',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9315, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9315',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9316, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9316',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9317, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9317',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9318, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9318',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9319, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9319',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9320, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9320',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9326, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9326',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9327, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9327',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9328, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9328',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9329, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9329',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9330, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9330',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9331, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9331',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9332, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9332',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9333, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9333',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9334, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9334',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9335, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9335',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9336, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9336',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9337, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9337',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9338, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9338',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9339, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9339',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9340, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9340',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9341, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9341',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9342, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9342',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9343, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9343',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9346, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9346',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9347, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9347',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9348, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9348',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9349, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9349',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9357, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9357',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9358, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9358',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9359, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9359',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9360, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9360',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9365, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9365',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9366, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9366',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9367, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9367',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9371, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9371',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9372, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9372',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9390, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9390',    '0', '(Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9391, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9391',    '0', '(Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9392, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9392',    '0', '(Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9393, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9393',    '0', '(Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9394, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9394',    '0', '(Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9395, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9395',    '0', '(Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9396, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9396',    '0', '(Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9397, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9397',    '0', '(Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9398, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9398',    '0', '(Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9399, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9399',    '0', '(Zur freien Verfügung)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9400, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9400',    '0', 'Privatentnahmen allgemein (TH), EK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9401, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9401',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9402, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9402',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9403, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9403',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9404, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9404',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9405, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9405',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9406, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9406',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9407, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9407',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9408, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9408',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9409, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9409',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9410, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9410',    '0', 'Privatsteuern (TH), EK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9411, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9411',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9412, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9412',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9413, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9413',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9414, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9414',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9415, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9415',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9416, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9416',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9417, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9417',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9418, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9418',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9419, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9419',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9420, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9420',    '0', 'Sonderausgaben beschränkt abzugsfähig (TH), EK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9421, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9421',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9422, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9422',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9423, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9423',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9424, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9424',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9425, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9425',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9426, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9426',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9427, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9427',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9428, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9428',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9429, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9429',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9430, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9430',    '0', 'Sonderausgaben unbeschränkt abzugsfähig (TH), EK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9431, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9431',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9432, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9432',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9433, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9433',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9434, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9434',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9435, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9435',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9436, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9436',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9437, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9437',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9438, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9438',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9439, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9439',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9440, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9440',    '0', 'Zuwendungen, Spenden (TH), EK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9441, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9441',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9442, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9442',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9443, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9443',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9444, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9444',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9445, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9445',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9446, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9446',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9447, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9447',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9448, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9448',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9449, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9449',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9450, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9450',    '0', 'Außergewöhnliche Belastungen (TH), EK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9451, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9451',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9452, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9452',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9453, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9453',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9454, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9454',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9455, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9455',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9456, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9456',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9457, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9457',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9458, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9458',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9459, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9459',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9460, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9460',    '0', 'Grundstücksaufwand (TH), EK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9461, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9461',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9462, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9462',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9463, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9463',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9464, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9464',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9465, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9465',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9466, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9466',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9467, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9467',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9468, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9468',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9469, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9469',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9470, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9470',    '0', 'Grundstücksertrag (TH), EK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9471, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9471',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9472, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9472',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9473, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9473',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9474, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9474',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9475, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9475',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9476, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9476',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9477, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9477',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9478, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9478',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9479, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9479',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9480, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9480',    '0', 'Unentgeltliche Wertabgaben (TH), EK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9481, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9481',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9482, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9482',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9483, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9483',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9484, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9484',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9485, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9485',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9486, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9486',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9487, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9487',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9488, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9488',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9489, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9489',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9490, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9490',    '0', 'Privateinlagen (TH), EK');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9491, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9491',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9492, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9492',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9493, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9493',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9494, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9494',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9495, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9495',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9496, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9496',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9497, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9497',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9498, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9498',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9499, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9499',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9500, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9500',    '0', 'Anteil für Konto 0900 Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9501, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9501',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9502, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9502',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9503, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9503',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9504, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9504',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9505, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9505',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9506, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9506',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9507, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9507',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9508, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9508',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9509, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9509',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9510, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9510',    '0', 'Anteil für Konto 0910 Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9511, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9511',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9512, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9512',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9513, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9513',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9514, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9514',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9515, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9515',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9516, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9516',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9517, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9517',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9518, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9518',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9519, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9519',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9520, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9520',    '0', 'Anteil für Konto 0920 Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9521, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9521',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9522, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9522',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9523, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9523',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9524, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9524',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9525, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9525',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9526, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9526',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9527, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9527',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9528, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9528',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9529, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9529',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9530, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9530',    '0', 'Anteil für Konto 9950 Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9531, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9531',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9532, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9532',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9533, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9533',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9534, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9534',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9535, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9535',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9536, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9536',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9537, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9537',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9538, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9538',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9539, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9539',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9540, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9540',    '0', 'Anteil für Konto 9930 Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9541, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9541',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9542, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9542',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9543, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9543',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9544, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9544',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9545, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9545',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9546, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9546',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9547, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9547',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9548, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9548',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9549, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9549',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9550, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9550',    '0', 'Anteil für Konto 9810 Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9551, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9551',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9552, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9552',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9553, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9553',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9554, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9554',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9555, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9555',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9556, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9556',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9557, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9557',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9558, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9558',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9559, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9559',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9560, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9560',    '0', 'Anteil für Konto 9820 Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9561, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9561',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9562, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9562',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9563, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9563',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9564, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9564',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9565, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9565',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9566, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9566',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9567, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9567',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9568, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9568',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9569, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9569',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9570, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9570',    '0', 'Anteil für Konto 0870 Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9571, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9571',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9572, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9572',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9573, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9573',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9574, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9574',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9575, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9575',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9576, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9576',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9577, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9577',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9578, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9578',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9579, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9579',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9580, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9580',    '0', 'Anteil für Konto 0880 Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9581, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9581',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9582, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9582',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9583, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9583',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9584, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9584',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9585, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9585',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9586, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9586',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9587, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9587',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9588, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9588',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9589, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9589',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9590, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9590',    '0', 'Anteil für Konto 0890 Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9591, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9591',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9592, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9592',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9593, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9593',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9594, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9594',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9595, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9595',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9596, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9596',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9597, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9597',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9598, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9598',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9599, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9599',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9600, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9600',    '0', 'Name des Gesellschafters Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9601, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9601',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9602, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9602',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9603, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9603',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9604, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9604',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9605, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9605',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9606, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9606',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9607, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9607',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9608, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9608',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9609, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9609',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9610, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9610',    '0', 'Tätigkeitsvergütung Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9611, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9611',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9612, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9612',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9613, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9613',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9614, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9614',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9615, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9615',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9616, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9616',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9617, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9617',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9618, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9618',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9619, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9619',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9620, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9620',    '0', 'Tantieme Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9621, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9621',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9622, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9622',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9623, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9623',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9624, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9624',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9625, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9625',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9626, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9626',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9627, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9627',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9628, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9628',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9629, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9629',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9630, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9630',    '0', 'Darlehensverzinsung Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9631, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9631',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9632, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9632',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9633, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9633',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9634, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9634',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9635, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9635',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9636, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9636',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9637, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9637',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9638, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9638',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9639, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9639',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9640, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9640',    '0', 'Gebrauchsüberlassung Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9641, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9641',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9642, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9642',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9643, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9643',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9644, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9644',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9645, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9645',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9646, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9646',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9647, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9647',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9648, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9648',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9649, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9649',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9650, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9650',    '0', 'Sonstige Vergütungen Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9651, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9651',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9652, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9652',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9653, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9653',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9654, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9654',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9655, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9655',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9656, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9656',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9657, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9657',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9658, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9658',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9659, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9659',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9660, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9660',    '0', 'Sonstige Vergütungen Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9661, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9661',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9662, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9662',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9663, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9663',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9664, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9664',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9665, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9665',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9666, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9666',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9667, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9667',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9668, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9668',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9669, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9669',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9670, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9670',    '0', 'Sonstige Vergütungen Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9671, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9671',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9672, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9672',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9673, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9673',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9674, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9674',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9675, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9675',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9676, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9676',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9677, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9677',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9678, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9678',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9679, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9679',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9680, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9680',    '0', 'Sonstige Vergütungen Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9681, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9681',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9682, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9682',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9683, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9683',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9684, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9684',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9685, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9685',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9686, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9686',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9687, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9687',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9688, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9688',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9689, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9689',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9690, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9690',    '0', 'Restanteil Vollhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9691, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9691',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9692, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9692',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9693, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9693',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9694, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9694',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9695, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9695',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9696, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9696',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9697, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9697',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9698, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9698',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9699, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9699',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9700, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9700',    '0', 'Name des Gesellschafters Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9701, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9701',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9702, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9702',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9703, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9703',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9704, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9704',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9705, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9705',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9706, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9706',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9707, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9707',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9708, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9708',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9709, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9709',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9710, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9710',    '0', 'Tätigkeitsvergütung Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9711, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9711',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9712, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9712',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9713, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9713',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9714, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9714',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9715, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9715',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9716, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9716',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9717, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9717',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9718, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9718',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9719, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9719',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9720, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9720',    '0', 'Tantieme Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9721, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9721',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9722, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9722',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9723, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9723',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9724, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9724',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9725, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9725',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9726, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9726',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9727, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9727',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9728, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9728',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9729, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9729',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9730, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9730',    '0', 'Darlehensverzinsung Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9731, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9731',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9732, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9732',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9733, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9733',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9734, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9734',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9735, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9735',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9736, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9736',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9737, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9737',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9738, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9738',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9739, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9739',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9740, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9740',    '0', 'Gebrauchsüberlassung Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9741, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9741',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9742, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9742',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9743, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9743',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9744, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9744',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9745, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9745',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9746, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9746',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9747, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9747',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9748, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9748',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9749, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9749',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9750, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9750',    '0', 'Sonstige Vergütungen Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9751, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9751',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9752, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9752',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9753, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9753',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9754, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9754',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9755, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9755',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9756, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9756',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9757, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9757',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9758, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9758',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9759, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9759',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9760, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9760',    '0', 'Sonstige Vergütungen Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9761, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9761',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9762, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9762',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9763, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9763',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9764, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9764',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9765, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9765',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9766, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9766',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9767, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9767',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9768, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9768',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9769, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9769',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9770, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9770',    '0', 'Sonstige Vergütungen Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9771, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9771',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9772, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9772',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9773, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9773',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9774, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9774',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9775, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9775',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9776, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9776',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9777, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9777',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9778, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9778',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9779, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9779',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9780, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9780',    '0', 'Anteil für Konto 9840 Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9781, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9781',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9782, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9782',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9783, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9783',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9784, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9784',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9785, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9785',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9786, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9786',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9787, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9787',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9788, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9788',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9789, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9789',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9790, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9790',    '0', 'Restanteil Teilhafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9791, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9791',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9792, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9792',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9793, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9793',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9794, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9794',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9795, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9795',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9796, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9796',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9797, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9797',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9798, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9798',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9799, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9799',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9800, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9800',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9802, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9802',    '0', 'Gesamthänderisch gebundene Rücklagen - andere Kapitalkontenanpassungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9803, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9803',    '0', 'Gewinnvortrag/Verlustvortrag - andere Kapitalkontenanpassungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9804, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9804',    '0', 'Gesamthänderisch gebundene Rücklagen - Umbuchungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9805, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9805',    '0', 'Gewinnvortrag/Verlustvortrag – Umbuchungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9806, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9806',    '0', 'Zuzurechnender Anteil am Jahresüberschuss/Jahresfehlbetrag - je Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9807, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9807',    '0', 'Zuzurechnender Anteil am Bilanzgewinn/Bilanzverlust - je Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9808, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9808',    '0', 'Gegenkonto für zuzurechnenden Anteil am Jahresüberschuss/Jahresfehlbetrag');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9809, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9809',    '0', 'Gegenkonto für zuzurechnenden Anteil am Bilanzgewinn/Bilanzverlust');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9810, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9810',    '0', 'Kapitalkonto III');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9811, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9811',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9812, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9812',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9813, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9813',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9814, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9814',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9815, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9815',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9816, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9816',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9817, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9817',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9818, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9818',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9819, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9819',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9820, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9820',    '0', 'Verlust-/Vortragskonto');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9821, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9821',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9822, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9822',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9823, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9823',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9824, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9824',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9825, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9825',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9826, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9826',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9827, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9827',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9828, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9828',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9829, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9829',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9830, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9830',    '0', 'Verrechnungskonto für Einzahlungsverpflichtungen');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9831, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9831',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9832, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9832',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9833, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9833',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9834, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9834',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9835, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9835',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9836, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9836',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9837, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9837',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9838, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9838',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9839, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9839',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9840, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9840',    '0', 'Kapitalkonto III');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9841, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9841',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9842, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9842',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9843, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9843',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9844, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9844',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9845, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9845',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9846, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9846',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9847, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9847',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9848, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9848',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9849, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9849',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9850, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9850',    '0', 'Verrechnungskonto für Einzahlungsverpflichtungen');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9851, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9851',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9852, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9852',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9853, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9853',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9854, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9854',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9855, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9855',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9856, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9856',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9857, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9857',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9858, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9858',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9859, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9859',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9860, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9860',    '0', 'Einzahlungsverpflichtungen persönlich haftender Gesellschafter');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9861, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9861',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9862, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9862',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9863, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9863',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9864, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9864',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9865, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9865',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9866, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9866',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9867, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9867',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9868, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9868',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9869, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9869',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9870, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9870',    '0', 'Einzahlungsverpflichtungen Kommanditisten');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9871, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9871',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9872, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9872',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9873, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9873',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9874, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9874',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9875, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9875',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9876, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9876',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9877, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9877',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9878, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9878',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9879, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9879',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9880, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9880',    '0', 'Ausgleichsposten für aktivierte eigene Anteile');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9883, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9883',    '0', 'Nicht durch Vermögenseinlagen gedeckte Entnahmen persönlich haftender Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9884, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9884',    '0', 'Nicht durch Vermögenseinlagen gedeckte Entnahmen Kommanditisten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9885, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9885',    '0', 'Verrechnungskonto für nicht durch Vermögenseinlagen gedeckte Entnahmen persönlich haftender Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9886, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9886',    '0', 'Verrechnungskonto für nicht durch Vermögenseinlagen gedeckte Entnahmen Kommanditisten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9887, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9887',    '0', 'Steueraufwand der Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9889, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9889',    '0', 'Gegenkonto zu 9887');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9890, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9890',    '0', 'Statistisches Konto für den Gewinnzuschlag nach §§ 6b und 6c EStG (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9891, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9891',    '0', 'Statistisches Konto für den Gewinnzuschlag nach §§ 6b und 6c EStG (Soll) - Gegenkonto zu 9890');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9892, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9892',    '0', 'Veränderung der gesamthänderisch gebundenen Rücklagen (Einlagen/Entnahmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9893, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9893',    '0', 'Umsatzsteuer in den Forderungen zum allgemeinen Umsatzsteuersatz (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9894, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9894',    '0', 'Umsatzsteuer in den Forderungen zum ermäßigten Umsatzsteuersatz (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9895, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9895',    '0', 'Gegenkonto 9893-9894 für die Aufteilung der Umsatzsteuer (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9896, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9896',    '0', 'Vorsteuer in den Verbindlichkeiten zum allgemeinen Umsatzsteuersatz (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9897, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9897',    '0', 'Vorsteuer in den Verbindlichkeiten zum ermäßigten Umsatzsteuersatz (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9898, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9898',    '0', 'Vorsteuer in den Verbindlichkeiten aus verschiedenen Kosten (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9899, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9899',    '0', 'Gegenkonto 9896-9897 für die Aufteilung der Vorsteuer (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9900, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9900',    '0', 'Umsatzsteuer nicht fällig - sonstige Erlöse (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9901, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9901',    '0', 'Gegenkonto zu 9900');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9902, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9902',    '0', 'Umsatzsteuer in den Forderungen aus sonstigen Erlösen (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9910, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9910',    '0', 'Gegenkonto zur Minderung der Entnahmen § 4 Abs. 4a EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9911, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9911',    '0', 'Minderung der Entnahmen § 4 Abs. 4a EStG (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9912, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9912',    '0', 'Erhöhung der Entnahmen § 4 Abs. 4a EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9913, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9913',    '0', 'Gegenkonto zur Erhöhung der Entnahmen § 4 Abs. 4a EStG (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9914, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9914',    '0', 'Hinzurechnung Investitionsabzugsbetrag § 7g Abs. 2 EStG aus dem 4. vorangegangenen Wirtschaftsjahr, außerbilanziell (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9915, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9915',    '0', 'Rückgängigmachung Investitionsabzugsbetrag § 7g Abs. 3 und 4 EStG im 4. vorangegangenen Wirtschaftsjahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9916, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9916',    '0', 'Hinzurechnung Investitionsabzugsbetrag § 7g Abs. 2 EStG aus dem 2. vorangegangenen Wirtschaftsjahr, außerbilanziell (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9917, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9917',    '0', 'Hinzurechnung Investitionsabzugsbetrag § 7g Abs. 2 EStG aus dem 3. vorangegangenen Wirtschaftsjahr, außerbilanziell (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9918, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9918',    '0', 'Rückgängigmachung Investitionsabzugsbetrag § 7g Abs. 3 und 4 EStG im 2. vorangegangenen Wirtschaftsjahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9919, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9919',    '0', 'Rückgängigmachung Investitionsabzugsbetrag § 7g Abs. 3 und 4 EStG im 3. vorangegangenen Wirtschaftsjahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9920, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9920',    '0', 'Ausstehende Einlagen auf das Komplementär-Kapital, nicht eingefordert');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9921, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9921',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9922, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9922',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9923, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9923',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9924, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9924',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9925, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9925',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9926, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9926',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9927, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9927',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9928, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9928',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9929, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9929',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9930, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9930',    '0', 'Ausstehende Einlagen auf das Komplementär-Kapital, eingefordert');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9931, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9931',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9932, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9932',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9933, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9933',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9934, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9934',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9935, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9935',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9936, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9936',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9937, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9937',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9938, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9938',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9939, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9939',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9940, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9940',    '0', 'Ausstehende Einlagen auf das Kommandit-Kapital, nicht eingefordert');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9941, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9941',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9942, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9942',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9943, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9943',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9944, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9944',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9945, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9945',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9946, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9946',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9947, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9947',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9948, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9948',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9949, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9949',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9950, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9950',    '0', 'Ausstehende Einlagen auf das Kommandit-Kapital, eingefordert');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9951, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9951',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9952, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9952',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9953, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9953',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9954, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9954',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9955, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9955',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9956, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9956',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9957, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9957',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9958, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9958',    '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9959, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9959',    '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9960, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9960',    '0', 'Bewertungskorrektur zu Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9961, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9961',    '0', 'Bewertungskorrektur zu sonstigen Verbindlichkeiten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9962, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9962',    '0', 'Bewertungskorrektur zu Guthaben bei Kreditinstituten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9963, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9963',    '0', 'Bewertungskorrektur zu Verbindlichkeiten gegenüber Kreditinstituten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9964, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9964',    '0', 'Bewertungskorrektur zu Verbindlichkeiten aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9965, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9965',    '0', 'Bewertungskorrektur zu sonstigen Vermögensgegenständen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9966, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9966',    '0', 'Hinzurechnung Investitionsabzugsbetrag § 7g Abs. 2 EStG aus dem 6. vorangegangenen Wirtschaftsjahr, außerbilanziell (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9967, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9967',    '0', 'Rückgängigmachung Investitionsabzugsbetrag § 7g Abs. 3 und 4 EStG im 6. vorangegangenen Wirtschaftsjahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9968, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9968',    '0', 'Hinzurechnung Investitionsabzugsbetrag § 7g Abs. 2 EStG aus dem 5. vorangegangenen Wirtschaftsjahr, außerbilanziell (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9969, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9969',    '0', 'Rückgängigmachung Investitionsabzugsbetrag § 7g Abs. 3 und 4 EStG im 5. vorangegangenen Wirtschaftsjahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9970, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9970',    '0', 'Investitionsabzugsbetrag § 7g Abs. 1 EStG, außerbilanziell (Soll)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9971, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9971',    '0', 'Investitionsabzugsbetrag § 7g Abs. 1 EStG, außerbilanziell (Haben) - Gegenkonto zu 9970');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9972, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9972',    '0', 'Hinzurechnung Investitionsabzugsbetrag § 7g Abs. 2 EStG aus dem vorangegangenen Wirtschaftsjahr, außerbilanziell (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9973, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9973',    '0', 'Hinzurechnung Investitionsabzugsbetrag § 7g Abs. 2 EStG aus den vorangegangenen Wirtschaftsjahren, außerbilanziell (Soll) - Gegenkonto zu 9972, 9914, 9916, 9917, 9968, 9966');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9974, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9974',    '0', 'Rückgängigmachung Investitionsabzugsbetrag § 7g Abs. 3 und 4 EStG im vorangegangenen Wirtschaftsjahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9975, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9975',    '0', 'Rückgängigmachung Investitionsabzugsbetrag § 7g Abs. 3 und 4 EStG in den vorangegangenen Wirtschaftsjahren - Gegenkonto zu 9974, 9915, 9918, 9919, 9969, 9967');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9976, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9976',    '0', 'Nicht abzugsfähige Zinsaufwendungen nach § 4h EStG (Haben)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9977, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9977',    '0', 'Nicht abzugsfähige Zinsaufwendungen nach § 4h EStG (Soll) - Gegenkonto zu 9976');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9978, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9978',    '0', 'Abziehbare Zinsaufwendungen aus Vorjahren nach § 4h EStG (Soll)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9979, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9979',    '0', 'Abziehbare Zinsaufwendungen aus Vorjahren nach § 4h EStG (Haben) - Gegenkonto zu 9978');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9980, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9980',    '0', 'Anteil Belastung auf Verbindlichkeitskonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9981, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9981',    '0', 'Verrechnungskonto für Anteil Belastung auf Verbindlichkeitskonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9982, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9982',    '0', 'Anteil Gutschrift auf Verbindlichkeitskonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9983, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9983',    '0', 'Verrechnungskonto für Anteil Gutschrift auf Verbindlichkeitskonten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9984, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9984',    '0', 'Gewinnkorrektur nach § 60 Abs. 2 EStDV - Erhöhung handelsrechtliches Ergebnis durch Habenbuchung - Minderung handelsrechtliches Ergebnis durch Sollbuchung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9985, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9985',    '0', 'Gegenkonto zu 9984');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9986, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9986',    '0', 'Ergebnisverteilung auf Fremdkapital');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9987, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9987',    '0', 'Korrekturkonto für die Überleitungsrechnung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9989, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9989',    '0', 'Gegenkonto zu 9986-9988');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9990, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9990',    '0', 'Erträge von außergewöhnlicher Größenordnung oder Bedeutung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9991, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9991',    '0', 'Erträge (aperiodisch)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9992, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9992',    '0', 'Erträge von außergewöhnlicher Größenordnung oder Bedeutung (aperiodisch)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9993, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9993',    '0', 'Aufwendungen von außergewöhnlicher Größenordnung oder Bedeutung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9994, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9994',    '0', 'Aufwendungen (aperiodisch)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9995, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9995',    '0', 'Aufwendungen von außergewöhnlicher Größenordnung oder Bedeutung (aperiodisch)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 9998, 'SKR03', '9: Vortrags-, Kapital-, Korrektur- und statistische Konten', '9998',    '0', 'Gegenkonto zu 9990-9997');
---- 10-99: Personenkonten
----for x in {10000..69999}; do echo "INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, $x, 'SKR03', '10-99: Personenkonten', '$x', '0', 'Debitoren');"; done
----for x in {70000..99999}; do echo "INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, $x, 'SKR03', '10-99: Personenkonten', '$x', '0', 'Kreditoren');"; done

---- WARNING: SKR03 range ends at 99999 -> there must be a 100000 offset for all skr04 rowid's !!! WARNING

-- SKR04 (based on DATEV Art.-Nr. 11175 2023-01-03)
-- https://www.datev.de/web/de/datev-shop/material/kontenrahmen-datev-skr-04/
---- 0: Anlagevermögenskonten
--for x in {0050..0999};do echo "INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, $((10#$x + 100000)), 'SKR04', '0: Anlagevermögenskonten',                                   '$x',      '0', '');"; done
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100050, 'SKR04', '0: Anlagevermögenskonten',                                   '0050',      '0', 'Ausstehende Einlagen auf das Komplementär-Kapital, nicht eingefordert');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100051, 'SKR04', '0: Anlagevermögenskonten',                                   '0051',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100052, 'SKR04', '0: Anlagevermögenskonten',                                   '0052',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100053, 'SKR04', '0: Anlagevermögenskonten',                                   '0053',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100054, 'SKR04', '0: Anlagevermögenskonten',                                   '0054',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100055, 'SKR04', '0: Anlagevermögenskonten',                                   '0055',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100056, 'SKR04', '0: Anlagevermögenskonten',                                   '0056',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100057, 'SKR04', '0: Anlagevermögenskonten',                                   '0057',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100058, 'SKR04', '0: Anlagevermögenskonten',                                   '0058',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100059, 'SKR04', '0: Anlagevermögenskonten',                                   '0059',      '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100060, 'SKR04', '0: Anlagevermögenskonten',                                   '0060',      '0', 'Ausstehende Einlagen auf das Komplementär-Kapital, eingefordert');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100061, 'SKR04', '0: Anlagevermögenskonten',                                   '0061',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100062, 'SKR04', '0: Anlagevermögenskonten',                                   '0062',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100063, 'SKR04', '0: Anlagevermögenskonten',                                   '0063',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100064, 'SKR04', '0: Anlagevermögenskonten',                                   '0064',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100065, 'SKR04', '0: Anlagevermögenskonten',                                   '0065',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100066, 'SKR04', '0: Anlagevermögenskonten',                                   '0066',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100067, 'SKR04', '0: Anlagevermögenskonten',                                   '0067',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100068, 'SKR04', '0: Anlagevermögenskonten',                                   '0068',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100069, 'SKR04', '0: Anlagevermögenskonten',                                   '0069',      '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100070, 'SKR04', '0: Anlagevermögenskonten',                                   '0070',      '0', 'Ausstehende Einlagen auf das Kommandit-Kapital, nicht eingefordert');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100071, 'SKR04', '0: Anlagevermögenskonten',                                   '0071',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100072, 'SKR04', '0: Anlagevermögenskonten',                                   '0072',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100073, 'SKR04', '0: Anlagevermögenskonten',                                   '0073',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100074, 'SKR04', '0: Anlagevermögenskonten',                                   '0074',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100075, 'SKR04', '0: Anlagevermögenskonten',                                   '0075',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100076, 'SKR04', '0: Anlagevermögenskonten',                                   '0076',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100077, 'SKR04', '0: Anlagevermögenskonten',                                   '0077',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100078, 'SKR04', '0: Anlagevermögenskonten',                                   '0078',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100079, 'SKR04', '0: Anlagevermögenskonten',                                   '0079',      '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100080, 'SKR04', '0: Anlagevermögenskonten',                                   '0080',      '0', 'Ausstehende Einlagen auf das Kommandit-Kapital, eingefordert');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100081, 'SKR04', '0: Anlagevermögenskonten',                                   '0081',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100082, 'SKR04', '0: Anlagevermögenskonten',                                   '0082',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100083, 'SKR04', '0: Anlagevermögenskonten',                                   '0083',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100084, 'SKR04', '0: Anlagevermögenskonten',                                   '0084',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100085, 'SKR04', '0: Anlagevermögenskonten',                                   '0085',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100086, 'SKR04', '0: Anlagevermögenskonten',                                   '0086',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100087, 'SKR04', '0: Anlagevermögenskonten',                                   '0087',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100088, 'SKR04', '0: Anlagevermögenskonten',                                   '0088',      '0', '');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100089, 'SKR04', '0: Anlagevermögenskonten',                                   '0089',      '0', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100090, 'SKR04', '0: Anlagevermögenskonten',                                   '0090',      '0', 'Rückständige fällige Einzahlungen auf Geschäftsanteile');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100100, 'SKR04', '0: Anlagevermögenskonten',                                   '0100',      '0', 'Entgeltlich erworbene Konzessionen, gewerbliche Schutzrechte und ähnliche Rechte und Werte sowie Lizenzen an solchen Rechten und Werten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100110, 'SKR04', '0: Anlagevermögenskonten',                                   '0110', '100100', 'Konzessionen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100120, 'SKR04', '0: Anlagevermögenskonten',                                   '0120', '100100', 'Gewerbliche Schutzrechte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100130, 'SKR04', '0: Anlagevermögenskonten',                                   '0130', '100100', 'Ähnliche Rechte und Werte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100135, 'SKR04', '0: Anlagevermögenskonten',                                   '0135', '100100', 'EDV-Software');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100140, 'SKR04', '0: Anlagevermögenskonten',                                   '0140', '100100', 'Lizenzen an gewerblichen Schutzrechten und ähnlichen Rechten und Werten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100143, 'SKR04', '0: Anlagevermögenskonten',                                   '0143',      '0', 'Selbst geschaffene immaterielle Vermögensgegenstände');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100144, 'SKR04', '0: Anlagevermögenskonten',                                   '0144', '100143', 'EDV-Software');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100145, 'SKR04', '0: Anlagevermögenskonten',                                   '0145', '100143', 'Lizenzen und Franchiseverträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100146, 'SKR04', '0: Anlagevermögenskonten',                                   '0146', '100143', 'Konzessionen und gewerbliche Schutzrechte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100147, 'SKR04', '0: Anlagevermögenskonten',                                   '0147', '100143', 'Rezepte, Verfahren, Prototypen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100148, 'SKR04', '0: Anlagevermögenskonten',                                   '0148', '100143', 'Immaterielle Vermögensgegenstände in Entwicklung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100150, 'SKR04', '0: Anlagevermögenskonten',                                   '0150',      '0', 'Geschäfts- oder Firmenwert');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100160, 'SKR04', '0: Anlagevermögenskonten',                                   '0160', '100150', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100170, 'SKR04', '0: Anlagevermögenskonten',                                   '0170',      '0', 'Geleistete Anzahlungen auf immaterielle Vermögensgegenstände');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100179, 'SKR04', '0: Anlagevermögenskonten',                                   '0179',      '0', 'Anzahlungen auf Geschäfts- oder Firmenwert');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100200, 'SKR04', '0: Anlagevermögenskonten',                                   '0200',      '0', 'Grundstücke, grundstücksgleiche Rechte und Bauten einschließlich der Bauten auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100210, 'SKR04', '0: Anlagevermögenskonten',                                   '0210', '100200', 'Grundstücksgleiche Rechte ohne Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100215, 'SKR04', '0: Anlagevermögenskonten',                                   '0215', '100200', 'Unbebaute Grundstücke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100220, 'SKR04', '0: Anlagevermögenskonten',                                   '0220', '100200', 'Grundstücksgleiche Rechte (Erbbaurecht, Dauerwohnrecht, unbebaute Grundstücke)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100225, 'SKR04', '0: Anlagevermögenskonten',                                   '0225', '100200', 'Grundstücke mit Substanzverzehr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100229, 'SKR04', '0: Anlagevermögenskonten',                                   '0229', '100200', 'Grundstücksanteil des häuslichen Arbeitszimmers');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100230, 'SKR04', '0: Anlagevermögenskonten',                                   '0230', '100200', 'Bauten auf eigenen Grundstücken und grundstücksgleichen Rechten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100235, 'SKR04', '0: Anlagevermögenskonten',                                   '0235', '100200', 'Grundstückswerte eigener bebauter Grundstücke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100240, 'SKR04', '0: Anlagevermögenskonten',                                   '0240', '100200', 'Geschäftsbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100250, 'SKR04', '0: Anlagevermögenskonten',                                   '0250', '100200', 'Fabrikbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100260, 'SKR04', '0: Anlagevermögenskonten',                                   '0260', '100200', 'Andere Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100270, 'SKR04', '0: Anlagevermögenskonten',                                   '0270', '100200', 'Garagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100280, 'SKR04', '0: Anlagevermögenskonten',                                   '0280', '100200', 'Außenanlagen für Geschäfts-, Fabrik- und andere Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100285, 'SKR04', '0: Anlagevermögenskonten',                                   '0285', '100200', 'Hof- und Wegebefestigungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100290, 'SKR04', '0: Anlagevermögenskonten',                                   '0290', '100200', 'Einrichtungen für Geschäfts-, Fabrik- und andere Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100300, 'SKR04', '0: Anlagevermögenskonten',                                   '0300', '100200', 'Wohnbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100305, 'SKR04', '0: Anlagevermögenskonten',                                   '0305', '100200', 'Garagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100310, 'SKR04', '0: Anlagevermögenskonten',                                   '0310', '100200', 'Außenanlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100315, 'SKR04', '0: Anlagevermögenskonten',                                   '0315', '100200', 'Hof- und Wegebefestigungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100320, 'SKR04', '0: Anlagevermögenskonten',                                   '0320', '100200', 'Einrichtungen für Wohnbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100329, 'SKR04', '0: Anlagevermögenskonten',                                   '0329', '100200', 'Gebäudeteil des häuslichen Arbeitszimmers');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100330, 'SKR04', '0: Anlagevermögenskonten',                                   '0330', '100200', 'Bauten auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100340, 'SKR04', '0: Anlagevermögenskonten',                                   '0340', '100200', 'Geschäftsbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100350, 'SKR04', '0: Anlagevermögenskonten',                                   '0350', '100200', 'Fabrikbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100360, 'SKR04', '0: Anlagevermögenskonten',                                   '0360', '100200', 'Wohnbauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100370, 'SKR04', '0: Anlagevermögenskonten',                                   '0370', '100200', 'Andere Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100380, 'SKR04', '0: Anlagevermögenskonten',                                   '0380', '100200', 'Garagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100390, 'SKR04', '0: Anlagevermögenskonten',                                   '0390', '100200', 'Außenanlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100395, 'SKR04', '0: Anlagevermögenskonten',                                   '0395', '100200', 'Hof- und Wegebefestigungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100398, 'SKR04', '0: Anlagevermögenskonten',                                   '0398', '100200', 'Einrichtungen für Geschäfts-, Fabrik-, Wohn- und andere Bauten');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100400, 'SKR04', '0: Anlagevermögenskonten',                                   '0400',      '0', 'Technische Anlagen und Maschinen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100420, 'SKR04', '0: Anlagevermögenskonten',                                   '0420', '100400', 'Technische Anlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100440, 'SKR04', '0: Anlagevermögenskonten',                                   '0440', '100400', 'Maschinen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100450, 'SKR04', '0: Anlagevermögenskonten',                                   '0450', '100400', 'Transportanlagen und Ähnliches');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100460, 'SKR04', '0: Anlagevermögenskonten',                                   '0460', '100400', 'Maschinengebundene Werkzeuge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100470, 'SKR04', '0: Anlagevermögenskonten',                                   '0470', '100400', 'Betriebsvorrichtungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100500, 'SKR04', '0: Anlagevermögenskonten',                                   '0500',      '0', 'Andere Anlagen, Betriebs- und Geschäftsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100510, 'SKR04', '0: Anlagevermögenskonten',                                   '0510', '100500', 'Andere Anlagen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100520, 'SKR04', '0: Anlagevermögenskonten',                                   '0520', '100500', 'Pkw');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100540, 'SKR04', '0: Anlagevermögenskonten',                                   '0540', '100500', 'Lkw');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100560, 'SKR04', '0: Anlagevermögenskonten',                                   '0560', '100500', 'Sonstige Transportmittel');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100620, 'SKR04', '0: Anlagevermögenskonten',                                   '0620', '100500', 'Werkzeuge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100630, 'SKR04', '0: Anlagevermögenskonten',                                   '0630', '100500', 'Betriebsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100635, 'SKR04', '0: Anlagevermögenskonten',                                   '0635', '100500', 'Geschäftsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100640, 'SKR04', '0: Anlagevermögenskonten',                                   '0640', '100500', 'Ladeneinrichtung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100650, 'SKR04', '0: Anlagevermögenskonten',                                   '0650', '100500', 'Büroeinrichtung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100660, 'SKR04', '0: Anlagevermögenskonten',                                   '0660', '100500', 'Gerüst- und Schalungsmaterial');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100670, 'SKR04', '0: Anlagevermögenskonten',                                   '0670', '100500', 'Geringwertige Wirtschaftsgüter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100675, 'SKR04', '0: Anlagevermögenskonten',                                   '0675', '100500', 'Wirtschaftsgüter (Sammelposten)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100680, 'SKR04', '0: Anlagevermögenskonten',                                   '0680', '100500', 'Einbauten in fremde Grundstücke');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100690, 'SKR04', '0: Anlagevermögenskonten',                                   '0690', '100500', 'Sonstige Betriebs- und Geschäftsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100700, 'SKR04', '0: Anlagevermögenskonten',                                   '0700',      '0', 'Geleistete Anzahlungen und Anlagen im Bau');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100705, 'SKR04', '0: Anlagevermögenskonten',                                   '0705', '100700', 'Anzahlungen auf Grund und Boden');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100710, 'SKR04', '0: Anlagevermögenskonten',                                   '0710', '100700', 'Geschäfts-, Fabrik- und andere Bauten im Bau auf eigenen Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100720, 'SKR04', '0: Anlagevermögenskonten',                                   '0720', '100700', 'Anzahlungen auf Geschäfts-, Fabrik- und andere Bauten auf eigenen Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100725, 'SKR04', '0: Anlagevermögenskonten',                                   '0725', '100700', 'Wohnbauten im Bau auf eigenen Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100735, 'SKR04', '0: Anlagevermögenskonten',                                   '0735', '100700', 'Anzahlungen auf Wohnbauten auf eigenen Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100740, 'SKR04', '0: Anlagevermögenskonten',                                   '0740', '100700', 'Geschäfts-, Fabrik- und andere Bauten im Bau auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100750, 'SKR04', '0: Anlagevermögenskonten',                                   '0750', '100700', 'Anzahlungen auf Geschäfts-, Fabrik- und andere Bauten auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100755, 'SKR04', '0: Anlagevermögenskonten',                                   '0755', '100700', 'Wohnbauten im Bau auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100765, 'SKR04', '0: Anlagevermögenskonten',                                   '0765', '100700', 'Anzahlungen auf Wohnbauten auf fremden Grundstücken');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100770, 'SKR04', '0: Anlagevermögenskonten',                                   '0770', '100700', 'Technische Anlagen und Maschinen im Bau');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100780, 'SKR04', '0: Anlagevermögenskonten',                                   '0780', '100700', 'Anzahlungen auf technische Anlagen und Maschinen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100785, 'SKR04', '0: Anlagevermögenskonten',                                   '0785', '100700', 'Andere Anlagen, Betriebs- und Geschäftsausstattung im Bau');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100795, 'SKR04', '0: Anlagevermögenskonten',                                   '0795', '100700', 'Anzahlungen auf andere Anlagen, Betriebs- und Geschäftsausstattung');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100800, 'SKR04', '0: Anlagevermögenskonten',                                   '0800',      '0', 'Anteile an verbundenen Unternehmen (Anlagevermögen)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100803, 'SKR04', '0: Anlagevermögenskonten',                                   '0803',      '0', 'Anteile an verbundenen Unternehmen, Personengesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100804, 'SKR04', '0: Anlagevermögenskonten',                                   '0804',      '0', 'Anteile an verbundenen Unternehmen, Kapitalgesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100805, 'SKR04', '0: Anlagevermögenskonten',                                   '0805',      '0', 'Anteile an herrschender oder mehrheitlich beteiligter Gesellschaft, Personengesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100806, 'SKR04', '0: Anlagevermögenskonten',                                   '0806',      '0', 'Anteile einer GmbH & Co. KG an einer Komplementär-GmbH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100808, 'SKR04', '0: Anlagevermögenskonten',                                   '0808',      '0', 'Anteile an herrschender oder mehrheitlich beteiligter Gesellschaft, Kapitalgesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100809, 'SKR04', '0: Anlagevermögenskonten',                                   '0809',      '0', 'Anteile an herrschender oder mehrheitlich beteiligter Gesellschaft');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100810, 'SKR04', '0: Anlagevermögenskonten',                                   '0810',      '0', 'Ausleihungen an verbundene Unternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100813, 'SKR04', '0: Anlagevermögenskonten',                                   '0813',      '0', 'Ausleihungen an verbundene Unternehmen, Personengesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100814, 'SKR04', '0: Anlagevermögenskonten',                                   '0814',      '0', 'Ausleihungen an verbundene Unternehmen, Kapitalgesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100815, 'SKR04', '0: Anlagevermögenskonten',                                   '0815',      '0', 'Ausleihungen an verbundene Unternehmen, Einzelunternehmen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100820, 'SKR04', '0: Anlagevermögenskonten',                                   '0820',      '0', 'Beteiligungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100829, 'SKR04', '0: Anlagevermögenskonten',                                   '0829',      '0', 'Beteiligung einer GmbH & Co. KG an einer Komplementär-GmbH');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100830, 'SKR04', '0: Anlagevermögenskonten',                                   '0830',      '0', 'Typisch stille Beteiligungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100840, 'SKR04', '0: Anlagevermögenskonten',                                   '0840',      '0', 'Atypisch stille Beteiligungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100850, 'SKR04', '0: Anlagevermögenskonten',                                   '0850',      '0', 'Beteiligungen an Kapitalgesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100860, 'SKR04', '0: Anlagevermögenskonten',                                   '0860',      '0', 'Beteiligungen an Personengesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100880, 'SKR04', '0: Anlagevermögenskonten',                                   '0880',      '0', 'Ausleihungen an Unternehmen, mit denen ein Beteiligungsverhältnis besteht');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100883, 'SKR04', '0: Anlagevermögenskonten',                                   '0883',      '0', 'Ausleihungen an Unternehmen, mit denen ein Beteiligungsverhältnis besteht, Personengesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100885, 'SKR04', '0: Anlagevermögenskonten',                                   '0885',      '0', 'Ausleihungen an Unternehmen, mit denen ein Beteiligungsverhältnis besteht, Kapitalgesellschaften');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100900, 'SKR04', '0: Anlagevermögenskonten',                                   '0900',      '0', 'Wertpapiere des Anlagevermögens');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100910, 'SKR04', '0: Anlagevermögenskonten',                                   '0910', '100900', 'Wertpapiere mit Gewinnbeteiligungsansprüchen, die dem Teileinkünfteverfahren unterliegen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100920, 'SKR04', '0: Anlagevermögenskonten',                                   '0920', '100900', 'Festverzinsliche Wertpapiere');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100930, 'SKR04', '0: Anlagevermögenskonten',                                   '0930',      '0', 'Übrige sonstige Ausleihungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100940, 'SKR04', '0: Anlagevermögenskonten',                                   '0940', '100930', 'Darlehen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100960, 'SKR04', '0: Anlagevermögenskonten',                                   '0960', '100930', 'Ausleihungen an Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100961, 'SKR04', '0: Anlagevermögenskonten',                                   '0961', '100930', 'Ausleihungen an GmbH-Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100962, 'SKR04', '0: Anlagevermögenskonten',                                   '0962', '100930', 'Ausleihungen an persönlich haftende Gesellschafter');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100963, 'SKR04', '0: Anlagevermögenskonten',                                   '0963', '100930', 'Ausleihungen an Kommanditisten');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100964, 'SKR04', '0: Anlagevermögenskonten',                                   '0964', '100930', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100970, 'SKR04', '0: Anlagevermögenskonten',                                   '0970', '100930', 'Ausleihungen an nahe stehende Personen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100980, 'SKR04', '0: Anlagevermögenskonten',                                   '0980',      '0', 'Genossenschaftsanteile zum langfristigen Verbleib');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 100990, 'SKR04', '0: Anlagevermögenskonten',                                   '0990',      '0', 'Rückdeckungsansprüche aus Lebensversicherungen zum langfristigen Verbleib');
---- 1: Umlaufvermögenskonten
--for x in {1000..1999};do echo "INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, $((10#$x + 100000)), 'SKR04', '1: Umlaufvermögenskonten',                                   '$x',      '0', '');"; done
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101000, 'SKR04', '1: Umlaufvermögenskonten',                                   '1000',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101001, 'SKR04', '1: Umlaufvermögenskonten',                                   '1001',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101002, 'SKR04', '1: Umlaufvermögenskonten',                                   '1002',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101003, 'SKR04', '1: Umlaufvermögenskonten',                                   '1003',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101004, 'SKR04', '1: Umlaufvermögenskonten',                                   '1004',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101005, 'SKR04', '1: Umlaufvermögenskonten',                                   '1005',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101006, 'SKR04', '1: Umlaufvermögenskonten',                                   '1006',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101007, 'SKR04', '1: Umlaufvermögenskonten',                                   '1007',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101008, 'SKR04', '1: Umlaufvermögenskonten',                                   '1008',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101009, 'SKR04', '1: Umlaufvermögenskonten',                                   '1009',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101010, 'SKR04', '1: Umlaufvermögenskonten',                                   '1010',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101011, 'SKR04', '1: Umlaufvermögenskonten',                                   '1011',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101012, 'SKR04', '1: Umlaufvermögenskonten',                                   '1012',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101013, 'SKR04', '1: Umlaufvermögenskonten',                                   '1013',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101014, 'SKR04', '1: Umlaufvermögenskonten',                                   '1014',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101015, 'SKR04', '1: Umlaufvermögenskonten',                                   '1015',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101016, 'SKR04', '1: Umlaufvermögenskonten',                                   '1016',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101017, 'SKR04', '1: Umlaufvermögenskonten',                                   '1017',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101018, 'SKR04', '1: Umlaufvermögenskonten',                                   '1018',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101019, 'SKR04', '1: Umlaufvermögenskonten',                                   '1019',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101020, 'SKR04', '1: Umlaufvermögenskonten',                                   '1020',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101021, 'SKR04', '1: Umlaufvermögenskonten',                                   '1021',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101022, 'SKR04', '1: Umlaufvermögenskonten',                                   '1022',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101023, 'SKR04', '1: Umlaufvermögenskonten',                                   '1023',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101024, 'SKR04', '1: Umlaufvermögenskonten',                                   '1024',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101025, 'SKR04', '1: Umlaufvermögenskonten',                                   '1025',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101026, 'SKR04', '1: Umlaufvermögenskonten',                                   '1026',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101027, 'SKR04', '1: Umlaufvermögenskonten',                                   '1027',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101028, 'SKR04', '1: Umlaufvermögenskonten',                                   '1028',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101029, 'SKR04', '1: Umlaufvermögenskonten',                                   '1029',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101030, 'SKR04', '1: Umlaufvermögenskonten',                                   '1030',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101031, 'SKR04', '1: Umlaufvermögenskonten',                                   '1031',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101032, 'SKR04', '1: Umlaufvermögenskonten',                                   '1032',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101033, 'SKR04', '1: Umlaufvermögenskonten',                                   '1033',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101034, 'SKR04', '1: Umlaufvermögenskonten',                                   '1034',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101035, 'SKR04', '1: Umlaufvermögenskonten',                                   '1035',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101036, 'SKR04', '1: Umlaufvermögenskonten',                                   '1036',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101037, 'SKR04', '1: Umlaufvermögenskonten',                                   '1037',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101038, 'SKR04', '1: Umlaufvermögenskonten',                                   '1038',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101039, 'SKR04', '1: Umlaufvermögenskonten',                                   '1039',      '0', 'Roh-, Hilfs- und Betriebsstoffe (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101040, 'SKR04', '1: Umlaufvermögenskonten',                                   '1040',      '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101041, 'SKR04', '1: Umlaufvermögenskonten',                                   '1041',      '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101042, 'SKR04', '1: Umlaufvermögenskonten',                                   '1042',      '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101043, 'SKR04', '1: Umlaufvermögenskonten',                                   '1043',      '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101044, 'SKR04', '1: Umlaufvermögenskonten',                                   '1044',      '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101045, 'SKR04', '1: Umlaufvermögenskonten',                                   '1045',      '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101046, 'SKR04', '1: Umlaufvermögenskonten',                                   '1046',      '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101047, 'SKR04', '1: Umlaufvermögenskonten',                                   '1047',      '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101048, 'SKR04', '1: Umlaufvermögenskonten',                                   '1048',      '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101049, 'SKR04', '1: Umlaufvermögenskonten',                                   '1049',      '0', 'Unfertige Erzeugnisse, unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101050, 'SKR04', '1: Umlaufvermögenskonten',                                   '1050',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101051, 'SKR04', '1: Umlaufvermögenskonten',                                   '1051',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101052, 'SKR04', '1: Umlaufvermögenskonten',                                   '1052',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101053, 'SKR04', '1: Umlaufvermögenskonten',                                   '1053',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101054, 'SKR04', '1: Umlaufvermögenskonten',                                   '1054',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101055, 'SKR04', '1: Umlaufvermögenskonten',                                   '1055',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101056, 'SKR04', '1: Umlaufvermögenskonten',                                   '1056',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101057, 'SKR04', '1: Umlaufvermögenskonten',                                   '1057',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101058, 'SKR04', '1: Umlaufvermögenskonten',                                   '1058',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101059, 'SKR04', '1: Umlaufvermögenskonten',                                   '1059',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101060, 'SKR04', '1: Umlaufvermögenskonten',                                   '1060',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101061, 'SKR04', '1: Umlaufvermögenskonten',                                   '1061',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101062, 'SKR04', '1: Umlaufvermögenskonten',                                   '1062',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101063, 'SKR04', '1: Umlaufvermögenskonten',                                   '1063',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101064, 'SKR04', '1: Umlaufvermögenskonten',                                   '1064',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101065, 'SKR04', '1: Umlaufvermögenskonten',                                   '1065',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101066, 'SKR04', '1: Umlaufvermögenskonten',                                   '1066',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101067, 'SKR04', '1: Umlaufvermögenskonten',                                   '1067',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101068, 'SKR04', '1: Umlaufvermögenskonten',                                   '1068',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101069, 'SKR04', '1: Umlaufvermögenskonten',                                   '1069',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101070, 'SKR04', '1: Umlaufvermögenskonten',                                   '1070',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101071, 'SKR04', '1: Umlaufvermögenskonten',                                   '1071',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101072, 'SKR04', '1: Umlaufvermögenskonten',                                   '1072',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101073, 'SKR04', '1: Umlaufvermögenskonten',                                   '1073',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101074, 'SKR04', '1: Umlaufvermögenskonten',                                   '1074',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101075, 'SKR04', '1: Umlaufvermögenskonten',                                   '1075',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101076, 'SKR04', '1: Umlaufvermögenskonten',                                   '1076',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101077, 'SKR04', '1: Umlaufvermögenskonten',                                   '1077',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101078, 'SKR04', '1: Umlaufvermögenskonten',                                   '1078',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101079, 'SKR04', '1: Umlaufvermögenskonten',                                   '1079',      '0', 'Unfertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101080, 'SKR04', '1: Umlaufvermögenskonten',                                   '1080',      '0', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101081, 'SKR04', '1: Umlaufvermögenskonten',                                   '1081',      '0', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101082, 'SKR04', '1: Umlaufvermögenskonten',                                   '1082',      '0', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101083, 'SKR04', '1: Umlaufvermögenskonten',                                   '1083',      '0', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101084, 'SKR04', '1: Umlaufvermögenskonten',                                   '1084',      '0', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101085, 'SKR04', '1: Umlaufvermögenskonten',                                   '1085',      '0', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101086, 'SKR04', '1: Umlaufvermögenskonten',                                   '1086',      '0', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101087, 'SKR04', '1: Umlaufvermögenskonten',                                   '1087',      '0', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101088, 'SKR04', '1: Umlaufvermögenskonten',                                   '1088',      '0', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101089, 'SKR04', '1: Umlaufvermögenskonten',                                   '1089',      '0', 'Unfertige Leistungen (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101090, 'SKR04', '1: Umlaufvermögenskonten',                                   '1090',      '0', 'In Ausführung befindliche Bauaufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101091, 'SKR04', '1: Umlaufvermögenskonten',                                   '1091',      '0', 'In Ausführung befindliche Bauaufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101092, 'SKR04', '1: Umlaufvermögenskonten',                                   '1092',      '0', 'In Ausführung befindliche Bauaufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101093, 'SKR04', '1: Umlaufvermögenskonten',                                   '1093',      '0', 'In Ausführung befindliche Bauaufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101094, 'SKR04', '1: Umlaufvermögenskonten',                                   '1094',      '0', 'In Ausführung befindliche Bauaufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101095, 'SKR04', '1: Umlaufvermögenskonten',                                   '1095',      '0', 'In Arbeit befindliche Aufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101096, 'SKR04', '1: Umlaufvermögenskonten',                                   '1096',      '0', 'In Arbeit befindliche Aufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101097, 'SKR04', '1: Umlaufvermögenskonten',                                   '1097',      '0', 'In Arbeit befindliche Aufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101098, 'SKR04', '1: Umlaufvermögenskonten',                                   '1098',      '0', 'In Arbeit befindliche Aufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101099, 'SKR04', '1: Umlaufvermögenskonten',                                   '1099',      '0', 'In Arbeit befindliche Aufträge');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101100, 'SKR04', '1: Umlaufvermögenskonten',                                   '1100',      '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101101, 'SKR04', '1: Umlaufvermögenskonten',                                   '1101',      '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101102, 'SKR04', '1: Umlaufvermögenskonten',                                   '1102',      '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101103, 'SKR04', '1: Umlaufvermögenskonten',                                   '1103',      '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101104, 'SKR04', '1: Umlaufvermögenskonten',                                   '1104',      '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101105, 'SKR04', '1: Umlaufvermögenskonten',                                   '1105',      '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101106, 'SKR04', '1: Umlaufvermögenskonten',                                   '1106',      '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101107, 'SKR04', '1: Umlaufvermögenskonten',                                   '1107',      '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101108, 'SKR04', '1: Umlaufvermögenskonten',                                   '1108',      '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101109, 'SKR04', '1: Umlaufvermögenskonten',                                   '1109',      '0', 'Fertige Erzeugnisse und Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101110, 'SKR04', '1: Umlaufvermögenskonten',                                   '1110',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101111, 'SKR04', '1: Umlaufvermögenskonten',                                   '1111',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101112, 'SKR04', '1: Umlaufvermögenskonten',                                   '1112',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101113, 'SKR04', '1: Umlaufvermögenskonten',                                   '1113',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101114, 'SKR04', '1: Umlaufvermögenskonten',                                   '1114',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101115, 'SKR04', '1: Umlaufvermögenskonten',                                   '1115',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101116, 'SKR04', '1: Umlaufvermögenskonten',                                   '1116',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101117, 'SKR04', '1: Umlaufvermögenskonten',                                   '1117',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101118, 'SKR04', '1: Umlaufvermögenskonten',                                   '1118',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101119, 'SKR04', '1: Umlaufvermögenskonten',                                   '1119',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101120, 'SKR04', '1: Umlaufvermögenskonten',                                   '1120',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101121, 'SKR04', '1: Umlaufvermögenskonten',                                   '1121',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101122, 'SKR04', '1: Umlaufvermögenskonten',                                   '1122',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101123, 'SKR04', '1: Umlaufvermögenskonten',                                   '1123',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101124, 'SKR04', '1: Umlaufvermögenskonten',                                   '1124',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101125, 'SKR04', '1: Umlaufvermögenskonten',                                   '1125',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101126, 'SKR04', '1: Umlaufvermögenskonten',                                   '1126',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101127, 'SKR04', '1: Umlaufvermögenskonten',                                   '1127',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101128, 'SKR04', '1: Umlaufvermögenskonten',                                   '1128',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101129, 'SKR04', '1: Umlaufvermögenskonten',                                   '1129',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101130, 'SKR04', '1: Umlaufvermögenskonten',                                   '1130',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101131, 'SKR04', '1: Umlaufvermögenskonten',                                   '1131',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101132, 'SKR04', '1: Umlaufvermögenskonten',                                   '1132',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101133, 'SKR04', '1: Umlaufvermögenskonten',                                   '1133',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101134, 'SKR04', '1: Umlaufvermögenskonten',                                   '1134',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101135, 'SKR04', '1: Umlaufvermögenskonten',                                   '1135',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101136, 'SKR04', '1: Umlaufvermögenskonten',                                   '1136',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101137, 'SKR04', '1: Umlaufvermögenskonten',                                   '1137',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101138, 'SKR04', '1: Umlaufvermögenskonten',                                   '1138',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101139, 'SKR04', '1: Umlaufvermögenskonten',                                   '1139',      '0', 'Fertige Erzeugnisse (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101140, 'SKR04', '1: Umlaufvermögenskonten',                                   '1140',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101141, 'SKR04', '1: Umlaufvermögenskonten',                                   '1141',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101142, 'SKR04', '1: Umlaufvermögenskonten',                                   '1142',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101143, 'SKR04', '1: Umlaufvermögenskonten',                                   '1143',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101144, 'SKR04', '1: Umlaufvermögenskonten',                                   '1144',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101145, 'SKR04', '1: Umlaufvermögenskonten',                                   '1145',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101146, 'SKR04', '1: Umlaufvermögenskonten',                                   '1146',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101147, 'SKR04', '1: Umlaufvermögenskonten',                                   '1147',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101148, 'SKR04', '1: Umlaufvermögenskonten',                                   '1148',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101149, 'SKR04', '1: Umlaufvermögenskonten',                                   '1149',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101150, 'SKR04', '1: Umlaufvermögenskonten',                                   '1150',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101151, 'SKR04', '1: Umlaufvermögenskonten',                                   '1151',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101152, 'SKR04', '1: Umlaufvermögenskonten',                                   '1152',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101153, 'SKR04', '1: Umlaufvermögenskonten',                                   '1153',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101154, 'SKR04', '1: Umlaufvermögenskonten',                                   '1154',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101155, 'SKR04', '1: Umlaufvermögenskonten',                                   '1155',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101156, 'SKR04', '1: Umlaufvermögenskonten',                                   '1156',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101157, 'SKR04', '1: Umlaufvermögenskonten',                                   '1157',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101158, 'SKR04', '1: Umlaufvermögenskonten',                                   '1158',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101159, 'SKR04', '1: Umlaufvermögenskonten',                                   '1159',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101160, 'SKR04', '1: Umlaufvermögenskonten',                                   '1160',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101161, 'SKR04', '1: Umlaufvermögenskonten',                                   '1161',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101162, 'SKR04', '1: Umlaufvermögenskonten',                                   '1162',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101163, 'SKR04', '1: Umlaufvermögenskonten',                                   '1163',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101164, 'SKR04', '1: Umlaufvermögenskonten',                                   '1164',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101165, 'SKR04', '1: Umlaufvermögenskonten',                                   '1165',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101166, 'SKR04', '1: Umlaufvermögenskonten',                                   '1166',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101167, 'SKR04', '1: Umlaufvermögenskonten',                                   '1167',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101168, 'SKR04', '1: Umlaufvermögenskonten',                                   '1168',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101169, 'SKR04', '1: Umlaufvermögenskonten',                                   '1169',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101170, 'SKR04', '1: Umlaufvermögenskonten',                                   '1170',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101171, 'SKR04', '1: Umlaufvermögenskonten',                                   '1171',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101172, 'SKR04', '1: Umlaufvermögenskonten',                                   '1172',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101173, 'SKR04', '1: Umlaufvermögenskonten',                                   '1173',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101174, 'SKR04', '1: Umlaufvermögenskonten',                                   '1174',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101175, 'SKR04', '1: Umlaufvermögenskonten',                                   '1175',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101176, 'SKR04', '1: Umlaufvermögenskonten',                                   '1176',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101177, 'SKR04', '1: Umlaufvermögenskonten',                                   '1177',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101178, 'SKR04', '1: Umlaufvermögenskonten',                                   '1178',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101179, 'SKR04', '1: Umlaufvermögenskonten',                                   '1179',      '0', 'Waren (Bestand)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101180, 'SKR04', '1: Umlaufvermögenskonten',                                   '1180',      '0', 'Geleistete Anzahlungen auf Vorräte');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101181, 'SKR04', '1: Umlaufvermögenskonten',                                   '1181', '101180', 'Geleistete Anzahlungen 7 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101182, 'SKR04', '1: Umlaufvermögenskonten',                                   '1182', '101180', 'Geleistete Anzahlungen, 5 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101183, 'SKR04', '1: Umlaufvermögenskonten',                                   '1183', '101180', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101184, 'SKR04', '1: Umlaufvermögenskonten',                                   '1184', '101180', 'Geleistete Anzahlungen, 16 % Vorsteuer');
--INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101185, 'SKR04', '1: Umlaufvermögenskonten',                                   '1185', '101180', '');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101186, 'SKR04', '1: Umlaufvermögenskonten',                                   '1186', '101180', 'Geleistete Anzahlungen 19 % Vorsteuer');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101190, 'SKR04', '1: Umlaufvermögenskonten',                                   '1190', '101180', 'Erhaltene Anzahlungen auf Bestellungen (von Vorräten offen abgesetzt)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101200, 'SKR04', '1: Umlaufvermögenskonten',                                   '1200',      '0', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101201, 'SKR04', '1: Umlaufvermögenskonten',                                   '1201', '101200', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101202, 'SKR04', '1: Umlaufvermögenskonten',                                   '1202', '101200', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101203, 'SKR04', '1: Umlaufvermögenskonten',                                   '1203', '101200', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101204, 'SKR04', '1: Umlaufvermögenskonten',                                   '1204', '101200', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101205, 'SKR04', '1: Umlaufvermögenskonten',                                   '1205', '101200', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101206, 'SKR04', '1: Umlaufvermögenskonten',                                   '1206', '101200', 'Forderungen aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101210, 'SKR04', '1: Umlaufvermögenskonten',                                   '1210', '101200', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101211, 'SKR04', '1: Umlaufvermögenskonten',                                   '1211', '101200', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101212, 'SKR04', '1: Umlaufvermögenskonten',                                   '1212', '101200', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101213, 'SKR04', '1: Umlaufvermögenskonten',                                   '1213', '101200', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101214, 'SKR04', '1: Umlaufvermögenskonten',                                   '1214', '101200', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101215, 'SKR04', '1: Umlaufvermögenskonten',                                   '1215', '101200', 'Forderungen aus Lieferungen und Leistungen zum allgemeinen Umsatzsteuersatz oder eines Kleinunternehmers (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101216, 'SKR04', '1: Umlaufvermögenskonten',                                   '1216', '101200', 'Forderungen aus Lieferungen und Leistungen zum ermäßigten Umsatzsteuersatz (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101217, 'SKR04', '1: Umlaufvermögenskonten',                                   '1217', '101200', 'Forderungen aus steuerfreien oder nicht steuerbaren Lieferungen und Leistungen (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101218, 'SKR04', '1: Umlaufvermögenskonten',                                   '1218', '101200', 'Forderungen aus Lieferungen und Leistungen nach Durchschnittssätzen nach § 24 UStG (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101219, 'SKR04', '1: Umlaufvermögenskonten',                                   '1219', '101200', 'Gegenkonto 1215-1218 bei Aufteilung der Forderungen nach Steuersätzen (EÜR)');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101220, 'SKR04', '1: Umlaufvermögenskonten',                                   '1220', '101200', 'Forderungen nach § 11 Abs. 1 Satz 2 EStG für § 4 Abs. 3 EStG');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101221, 'SKR04', '1: Umlaufvermögenskonten',                                   '1221', '101200', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent – Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101225, 'SKR04', '1: Umlaufvermögenskonten',                                   '1225', '101200', 'Forderungen aus Lieferungen und Leistungen ohne Kontokorrent – Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101230, 'SKR04', '1: Umlaufvermögenskonten',                                   '1230', '101200', 'Wechsel aus Lieferungen und Leistungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101231, 'SKR04', '1: Umlaufvermögenskonten',                                   '1231', '101200', 'Wechsel aus Lieferungen und Leistungen – Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101232, 'SKR04', '1: Umlaufvermögenskonten',                                   '1232', '101200', 'Wechsel aus Lieferungen und Leistungen – Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101235, 'SKR04', '1: Umlaufvermögenskonten',                                   '1235', '101200', 'Wechsel aus Lieferungen und Leistungen, bundesbankfähig');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101240, 'SKR04', '1: Umlaufvermögenskonten',                                   '1240', '101200', 'Zweifelhafte Forderungen');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101241, 'SKR04', '1: Umlaufvermögenskonten',                                   '1241', '101200', 'Zweifelhafte Forderungen – Restlaufzeit bis 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101245, 'SKR04', '1: Umlaufvermögenskonten',                                   '1245', '101200', 'Zweifelhafte Forderungen – Restlaufzeit größer 1 Jahr');
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label) VALUES (__ENTITY__, 101246, 'SKR04', '1: Umlaufvermögenskonten',                                   '1246', '